/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractBigIntegerParser;
import com.fasterxml.jackson.core.io.doubleparser.AbstractNumberParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import com.fasterxml.jackson.core.io.doubleparser.ParseDigitsTaskCharArray;
import java.math.BigInteger;
import java.util.NavigableMap;

class JavaBigIntegerFromCharArray
extends AbstractBigIntegerParser {
    JavaBigIntegerFromCharArray() {
    }

    public BigInteger parseBigIntegerString(char[] cArray, int n2, int n3, int n4) throws NumberFormatException {
        try {
            boolean bl2;
            int n5 = AbstractNumberParser.checkBounds(cArray.length, n2, n3);
            int n6 = n2;
            char c2 = cArray[n6];
            boolean bl3 = bl2 = c2 == '-';
            if ((bl2 || c2 == '+') && (c2 = JavaBigIntegerFromCharArray.charAt(cArray, ++n6, n5)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            switch (n4) {
                case 10: {
                    return this.parseDecDigits(cArray, n6, n5, bl2);
                }
                case 16: {
                    return this.parseHexDigits(cArray, n6, n5, bl2);
                }
            }
            return new BigInteger(new String(cArray, n2, n3), n4);
        }
        catch (ArithmeticException arithmeticException) {
            NumberFormatException numberFormatException = new NumberFormatException("value exceeds limits");
            numberFormatException.initCause(arithmeticException);
            throw numberFormatException;
        }
    }

    private BigInteger parseDecDigits(char[] cArray, int n2, int n3, boolean bl2) {
        int n4 = n3 - n2;
        if (JavaBigIntegerFromCharArray.hasManyDigits(n4)) {
            return this.parseManyDecDigits(cArray, n2, n3, bl2);
        }
        int n5 = n2 + (n4 & 7);
        long l2 = FastDoubleSwar.tryToParseUpTo7Digits(cArray, n2, n5);
        boolean bl3 = l2 >= 0L;
        for (n2 = n5; n2 < n3; n2 += 8) {
            int n6 = FastDoubleSwar.tryToParseEightDigits(cArray, n2);
            bl3 &= n6 >= 0;
            l2 = l2 * 100000000L + (long)n6;
        }
        if (!bl3) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(bl2 ? -l2 : l2);
    }

    private BigInteger parseHexDigits(char[] cArray, int n2, int n3, boolean bl2) {
        int n4;
        int n5 = n3 - (n2 = this.skipZeroes(cArray, n2, n3));
        if (n5 <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromCharArray.checkHexBigIntegerBounds(n5);
        byte[] byArray = new byte[(n5 + 1 >> 1) + 1];
        int n6 = 1;
        boolean bl3 = false;
        if ((n5 & 1) != 0) {
            n4 = cArray[n2++];
            int c2 = JavaBigIntegerFromCharArray.lookupHex((char)n4);
            byArray[n6++] = (byte)c2;
            bl3 = c2 < 0;
        }
        n4 = n2 + (n3 - n2 & 7);
        while (n2 < n4) {
            char l2 = cArray[n2];
            char c2 = cArray[n2 + 1];
            int n7 = JavaBigIntegerFromCharArray.lookupHex(l2);
            int n8 = JavaBigIntegerFromCharArray.lookupHex(c2);
            byArray[n6++] = (byte)(n7 << 4 | n8);
            bl3 |= n7 < 0 || n8 < 0;
            n2 += 2;
        }
        while (n2 < n3) {
            long bigInteger = FastDoubleSwar.tryToParseEightHexDigits(cArray, n2);
            FastDoubleSwar.writeIntBE(byArray, n6, (int)bigInteger);
            bl3 |= bigInteger < 0L;
            n2 += 8;
            n6 += 4;
        }
        if (bl3) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger bigInteger = new BigInteger(byArray);
        return bl2 ? bigInteger.negate() : bigInteger;
    }

    private BigInteger parseManyDecDigits(char[] cArray, int n2, int n3, boolean bl2) {
        n2 = this.skipZeroes(cArray, n2, n3);
        int n4 = n3 - n2;
        JavaBigIntegerFromCharArray.checkDecBigIntegerBounds(n4);
        NavigableMap<Integer, BigInteger> navigableMap = FastIntegerMath.fillPowersOf10Floor16(n2, n3);
        BigInteger bigInteger = ParseDigitsTaskCharArray.parseDigitsRecursive(cArray, n2, n3, navigableMap, 400);
        return bl2 ? bigInteger.negate() : bigInteger;
    }

    private int skipZeroes(char[] cArray, int n2, int n3) {
        while (n2 < n3 - 8 && FastDoubleSwar.isEightZeroes(cArray, n2)) {
            n2 += 8;
        }
        while (n2 < n3 && cArray[n2] == '0') {
            ++n2;
        }
        return n2;
    }
}

