/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.layout;

import atlantafx.base.controls.ModalPane;
import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import org.jetbrains.annotations.Nullable;

public class ModalBox
extends AnchorPane {
    protected final StackPane closeButton = new StackPane();
    protected final StackPane closeButtonIcon = new StackPane();
    @Nullable
    protected final String selector;
    @Nullable
    protected ModalPane modalPane;
    protected final ObjectProperty<EventHandler<? super Event>> onClose = new SimpleObjectProperty((Object)this, "onClose");
    protected final BooleanProperty clearOnClose = new SimpleBooleanProperty((Object)this, "clearOnClose");

    public ModalBox() {
        this((String)null, new Node[0]);
    }

    public ModalBox(Node ... nodeArray) {
        this((String)null, nodeArray);
    }

    public ModalBox(@NamedArg(value="selector") @Nullable String string, Node ... nodeArray) {
        super(nodeArray);
        this.selector = string;
        this.modalPane = null;
        this.createLayout();
    }

    public ModalBox(@Nullable ModalPane modalPane, Node ... nodeArray) {
        super(nodeArray);
        this.selector = null;
        this.modalPane = modalPane;
        this.createLayout();
    }

    public void addContent(Node node) {
        Objects.requireNonNull(node, "Node cannot be null.");
        this.getChildren().add(this.getChildren().indexOf((Object)this.closeButton), (Object)node);
    }

    public void close() {
        this.handleClose();
    }

    protected void createLayout() {
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.getChildren().setAll((Object[])new Node[]{this.closeButtonIcon});
        this.closeButton.setOnMouseClicked(mouseEvent -> this.handleClose());
        this.closeButtonIcon.getStyleClass().add((Object)"icon");
        this.getStyleClass().add((Object)"modal-box");
        this.getChildren().add((Object)this.closeButton);
        this.setCloseButtonPosition();
    }

    protected void setCloseButtonPosition() {
        ModalBox.setTopAnchor((Node)this.closeButton, (Double)10.0);
        ModalBox.setRightAnchor((Node)this.closeButton, (Double)10.0);
    }

    protected void handleClose() {
        Node node;
        if (this.modalPane != null) {
            this.modalPane.hide(this.clearOnClose.get());
        } else if (this.selector != null && this.getScene() != null && (node = this.getScene().lookup(this.selector)) instanceof ModalPane) {
            ModalPane modalPane;
            this.modalPane = modalPane = (ModalPane)node;
            this.modalPane.hide(this.clearOnClose.get());
        }
        if (this.onClose.get() != null) {
            ((EventHandler)this.onClose.get()).handle(new Event(Event.ANY));
        }
    }

    public ObjectProperty<EventHandler<? super Event>> onCloseProperty() {
        return this.onClose;
    }

    public EventHandler<? super Event> getOnClose() {
        return (EventHandler)this.onClose.get();
    }

    public void setOnClose(EventHandler<? super Event> eventHandler) {
        this.onClose.set(eventHandler);
    }

    public BooleanProperty clearOnCloseProperty() {
        return this.clearOnClose;
    }

    public boolean isClearOnClose() {
        return this.clearOnClose.get();
    }

    public void setClearOnClose(boolean bl2) {
        this.clearOnClose.set(bl2);
    }
}

