/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.text.HitInfo;

public abstract class CustomTextFieldSkin
extends TextFieldSkin {
    private static final PseudoClass HAS_NO_SIDE_NODE = PseudoClass.getPseudoClass((String)"no-side-nodes");
    private static final PseudoClass HAS_LEFT_NODE = PseudoClass.getPseudoClass((String)"left-node-visible");
    private static final PseudoClass HAS_RIGHT_NODE = PseudoClass.getPseudoClass((String)"right-node-visible");
    private StackPane leftPane;
    private StackPane rightPane;
    private final TextField control;

    public CustomTextFieldSkin(TextField textField) {
        super(textField);
        this.control = textField;
        this.updateChildren();
        this.registerChangeListener((ObservableValue)this.leftProperty(), observableValue -> this.updateChildren());
        this.registerChangeListener((ObservableValue)this.rightProperty(), observableValue -> this.updateChildren());
    }

    public abstract ObjectProperty<Node> leftProperty();

    public abstract ObjectProperty<Node> rightProperty();

    private void updateChildren() {
        Node node;
        Node node2;
        Node node3 = (Node)this.leftProperty().get();
        this.getChildren().remove((Object)this.leftPane);
        if (node3 != null) {
            this.leftPane = new StackPane(new Node[]{node3});
            this.leftPane.setManaged(false);
            this.leftPane.setAlignment(Pos.CENTER_LEFT);
            this.leftPane.getStyleClass().add((Object)"left-pane");
            this.getChildren().add((Object)this.leftPane);
            node2 = node3;
        } else {
            this.leftPane = null;
            node2 = null;
        }
        Node node4 = (Node)this.rightProperty().get();
        this.getChildren().remove((Object)this.rightPane);
        if (node4 != null) {
            this.rightPane = new StackPane(new Node[]{node4});
            this.rightPane.setManaged(false);
            this.rightPane.setAlignment(Pos.CENTER_RIGHT);
            this.rightPane.getStyleClass().add((Object)"right-pane");
            this.getChildren().add((Object)this.rightPane);
            node = node4;
        } else {
            this.rightPane = null;
            node = null;
        }
        this.control.pseudoClassStateChanged(HAS_LEFT_NODE, node2 != null);
        this.control.pseudoClassStateChanged(HAS_RIGHT_NODE, node != null);
        this.control.pseudoClassStateChanged(HAS_NO_SIDE_NODE, node2 == null && node == null);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d5 + this.snappedTopInset() + this.snappedBottomInset();
        double d8 = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.prefWidth(d7));
        double d9 = this.rightPane == null ? 0.0 : this.snapSizeX(this.rightPane.prefWidth(d7));
        double d10 = this.snapPositionX(d2) + this.snapSizeX(d8);
        double d11 = d4 - this.snapSizeX(d8) - this.snapSizeX(d9);
        super.layoutChildren(d10, 0.0, d11, d7);
        if (this.leftPane != null) {
            d6 = 0.0;
            this.leftPane.resizeRelocate(0.0, 0.0, d8, d7);
        }
        if (this.rightPane != null) {
            d6 = d4 - d9 + this.snappedLeftInset();
            this.rightPane.resizeRelocate(d6, 0.0, d9, d7);
        }
    }

    public HitInfo getIndex(double d2, double d3) {
        double d4 = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.prefWidth(((TextField)this.getSkinnable()).getHeight()));
        return super.getIndex(d2 - d4, d3);
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computePrefWidth(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.prefWidth(d2));
        double d9 = this.rightPane == null ? 0.0 : this.snapSizeX(this.rightPane.prefWidth(d2));
        return d7 + d8 + d9;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computePrefHeight(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.prefHeight(-1.0));
        double d9 = this.rightPane == null ? 0.0 : this.snapSizeX(this.rightPane.prefHeight(-1.0));
        return Math.max(d7, Math.max(d8, d9));
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computeMinWidth(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.minWidth(d2));
        double d9 = this.rightPane == null ? 0.0 : this.snapSizeX(this.rightPane.minWidth(d2));
        return d7 + d8 + d9;
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computeMinHeight(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSizeX(this.leftPane.minHeight(-1.0));
        double d9 = this.rightPane == null ? 0.0 : this.snapSizeX(this.rightPane.minHeight(-1.0));
        return Math.max(d7, Math.max(d8, d9));
    }
}

