/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.atn;
import us.hebi.gui.lib.auy;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.axz;
import us.hebi.gui.lib.bbp;
import us.hebi.gui.lib.bbq;
import us.hebi.gui.lib.bbx;
import us.hebi.gui.lib.bby;
import us.hebi.gui.lib.bcc;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.beb;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bmo;
import us.hebi.gui.lib.bmx;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class MotorEncoderCalibrationDialog
extends CalibrationDialog<bcc> {
    ReadOnlyObjectProperty<ano> motorEncoder;
    ReadOnlyObjectProperty<bby> calibrationAction;
    DoubleBinding idCmd;
    DoubleBinding poleSweepTime;
    ReadOnlyDoubleProperty numPolePairs;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate motor encoder");
        this.calibrationAction = this.addEnumParameter("Action", List.of(bby.values()), bby.Calibrate, "Verify runs the calibration process with the existing table");
        List<ano> list = List.of(ano.c, ano.d, ano.e, ano.f);
        Object object = this.device.getInfo();
        object = ((axs)object).a;
        this.motorEncoder = this.addEnumParameter("Motor Encoder", list, ((axy)object).a.a(), "The port used for the encoder");
        this.idCmd = this.addDoubleParameter("FOC Id [A]", 1.0, "If the motor doesn't move, or doesn\u2019t move smoothly, this should be increased. Be careful to make sure this value stays at or below the current rating for your motor.");
        this.poleSweepTime = this.addDoubleParameter("Pole sweep time", 1.5, "Time spent per pole [s]");
        object = this.device.getInfo();
        object = ((axs)object).a;
        object = ((axy)object).a;
        this.numPolePairs = ((axz)object).cv;
    }

    @Override
    protected void sendPersistAllAsync() throws IOException {
        Optional.ofNullable((bcc)this.result.get()).map(bcc::a).ifPresent(bbq2 -> bbq2.c((ald)this.device.getDeviceAddress().get()));
    }

    private bbp subsample(bbp bbp2, int n2) {
        if (bbp2.getNumSamples() < n2) {
            return bbp2;
        }
        bbp bbp3 = new bbp().a(n2);
        int n3 = bbp2.getNumSamples() / n2;
        for (int i2 = 0; i2 < bbp2.getNumSamples() && bbp3.getNumSamples() <= n2; i2 += n3) {
            bbp3.c(bbp2.c(i2), bbp2.d(i2));
        }
        return bbp3;
    }

    @Override
    protected void fillResultGrid(bcc bcc2) {
        bbp bbp2;
        bbp bbp3 = this.subsample(bcc2.e, 2000);
        String string = Math.abs(bbp2.h()[0]) < 1.0E-4 ? "Wrong encoder" : (!bbp3.aN() ? "Bad fit" : (bbp3.h()[1] < 0.0 ? "Wrong direction" : "Ok"));
        this.addChart(MotorEncoderCalibrationDialog.createPrimaryChart(bcc2));
        this.addResult("Linear fit", bbp3.dl(), string);
        this.addResult("Offset (1 rotation)", atn.d(bcc2.dB), "[rad]");
        this.addResult("Offset (+/- 0.5 rotation)", atn.d(bcc2.dC), "[rad]");
    }

    private static beb toDataSet(String string, bbq bbq2) {
        return (beb)new beb(string, bbq2::M, n2 -> auy.i(bbq2.f(n2)), n2 -> auy.i(bbq2.g(n2))).addStyleClasses(new String[]{bek.c.D()});
    }

    private static XYChart createChartWithAxes() {
        XYChart xYChart = bdc.c();
        xYChart.getXAxis().setName("Commanded Rotor Position Offset");
        xYChart.getXAxis().setUnit("deg");
        xYChart.getYAxis().setName("Encoder Position");
        xYChart.getYAxis().setUnit("deg");
        return xYChart;
    }

    public static XYChart createPrimaryChart(bcc bcc2) {
        XYChart xYChart = MotorEncoderCalibrationDialog.createChartWithAxes();
        xYChart.getDatasets().add((Object)new beb("Samples", bcc2.e::getNumSamples, n2 -> auy.i(bmo.a(true, bcc2.e.c(n2))), n2 -> auy.i(bcc2.e.e(n2))).addStyleClasses(new String[]{bek.c.D()}));
        xYChart.getDatasets().addAll((Object[])new DataSet[]{MotorEncoderCalibrationDialog.toDataSet("Forward table", bcc2.b), MotorEncoderCalibrationDialog.toDataSet("Backward table", bcc2.c), MotorEncoderCalibrationDialog.toDataSet("Combined table", bcc2.a())});
        double[] dArray = bmo.a(0.0, Math.PI * 2, 4096);
        xYChart.getDatasets().add((Object)new beb("Offset", () -> dArray.length, n2 -> auy.i(dArray[n2]), n2 -> auy.i(bcc2.a().q(dArray[n2]))).addStyleClasses(new String[]{bek.a.D()}));
        return xYChart;
    }

    public static XYChart createSecondaryChart(bcc bcc2) {
        bbq bbq2 = bcc2.a();
        bbp bbp2 = bcc2.e;
        XYChart xYChart = MotorEncoderCalibrationDialog.createChartWithAxes();
        Object[] objectArray = new DataSet[3];
        objectArray[0] = new beb("Forward delta", bbq2::M, n2 -> auy.i(bbq2.f(n2)), n2 -> auy.i(bcc2.b.g(n2) - bbq2.g(n2))).addStyleClasses(new String[]{bek.c.D()});
        objectArray[1] = new beb("Backward delta", bbq2::M, n2 -> auy.i(bbq2.f(n2)), n2 -> auy.i(bcc2.c.g(n2) - bbq2.g(n2))).addStyleClasses(new String[]{bek.c.D()});
        objectArray[2] = new beb("Corrected samples", bbp2::getNumSamples, n2 -> auy.i(bmo.a(true, bbp2.c(n2))), n2 -> auy.i(bbp2.e(n2) - bbq2.q(bbp2.c(n2)))).addStyleClasses(new String[]{bek.c.D()});
        xYChart.getDatasets().addAll(objectArray);
        return xYChart;
    }

    @Override
    protected Parent renderResult(bcc bcc2) {
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(MotorEncoderCalibrationDialog.createPrimaryChart(bcc2));
        calibrationResultDialog.setSecondaryChart(MotorEncoderCalibrationDialog.createSecondaryChart(bcc2));
        if (bcc2.cU > 0) {
            calibrationResultDialog.addResult("Missing Data", bcc2.cU, "[buckets]");
        }
        calibrationResultDialog.addResult("Raw Offset", bcc2.dA, "[rad]");
        calibrationResultDialog.addResult("Offset (1 rotation)", bcc2.dC, "[rad]");
        calibrationResultDialog.addResult("Offset (1 pole)", bcc2.dE, "[rad]");
        calibrationResultDialog.setMatFileSupplier(() -> bcc2.a().a("motorEncoder", bmx.a(String.valueOf(this.motorEncoder))).a("idCmd", bmx.a(this.idCmd.get())).a("poleSweepTime", bmx.a(this.poleSweepTime.get())).a("numPolePairs", bmx.a(this.numPolePairs.get())));
        calibrationResultDialog.setPrefHeight(900.0);
        calibrationResultDialog.setPrefWidth(900.0);
        return calibrationResultDialog;
    }

    @Override
    protected Callable<bcc> createTask(ald ald2) {
        bbx bbx2 = new bbx(ald2, (ano)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get(), (bby)((Object)((Object)this.calibrationAction.get())));
        MotorEncoderCalibrationDialog motorEncoderCalibrationDialog = this;
        new bbx(ald2, (ano)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get(), (bby)((Object)((Object)this.calibrationAction.get()))).a = motorEncoderCalibrationDialog;
        return bbx2;
    }
}

