/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs;

import com.jfoenix.controls.JFXSlider;
import io.fair_acc.chartfx.XYChart;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.inject.Inject;
import us.hebi.gui.Bootloader;
import us.hebi.gui.Inspector;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.lib.asu;
import us.hebi.gui.lib.asv;
import us.hebi.gui.lib.atg;
import us.hebi.gui.lib.att;
import us.hebi.gui.lib.avn;
import us.hebi.gui.lib.aye;
import us.hebi.gui.lib.ayh;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.baz;
import us.hebi.gui.lib.bbb;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.beo;
import us.hebi.gui.lib.bgl;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bhe;
import us.hebi.gui.lib.bhh;
import us.hebi.gui.lib.bhp;
import us.hebi.gui.views.scope.assets.AssetCache;
import us.hebi.gui.views.scope.components.MonitoringController;

public class SettingsController {
    @FXML
    private Parent root;
    @FXML
    private Button plotInfoRttBtn;
    @FXML
    private ToggleGroup language;
    @FXML
    private Button infoFrequencyTarget;
    @FXML
    private Text infoFrequencyLabel;
    @FXML
    private JFXSlider infoFrequencySlider;
    @FXML
    private Button broadcastRatioTarget;
    @FXML
    private Text broadcastRatioLabel;
    @FXML
    private JFXSlider broadcastRatioSlider;
    @FXML
    private ComboBox<String> interfaceChoiceBox;
    @FXML
    private ComboBox<bhe> themeChoiceBox;
    @FXML
    private Button refreshInterfacesBtn;
    @FXML
    private Button addInterfaceBtn;
    @FXML
    private Button removeInterfaceBtn;
    @FXML
    private Button applyBtn;
    @FXML
    private ToggleButton disableHwAccelerationToggle;
    @FXML
    private ToggleButton combineChartsToggle;
    @FXML
    private ToggleButton plotErrorAbsToggle;
    @FXML
    private ToggleButton showPlotGridToggle;
    @FXML
    private ToggleButton showInfoToggle;
    @FXML
    private Button setCustomChartDirBtn;
    @FXML
    private Button resetCustomChartDirBtn;
    @FXML
    private Button bootloaderBtn;
    @FXML
    private Button inspectorBtn;
    @FXML
    private Button checkUpdatesBtn;
    @FXML
    private Button clearAssetCacheBtn;
    @FXML
    private Button macAddToShellBtn;
    @FXML
    private Pane macOptionPane;
    @Inject
    ayh properties;
    @Inject
    baz interfaceChoiceService;
    @Inject
    beo customChartDirectory;
    @Inject
    azz notificationService;
    @Inject
    bhh downloadCache;
    @Inject
    bbb lookupService;

    @FXML
    void initialize() {
        bgl bgl2;
        bhp.e(this.root);
        this.themeChoiceBox.getItems().setAll((Object[])bhe.values());
        this.themeChoiceBox.getSelectionModel().select((Object)this.properties.a());
        this.properties.d.bind((ObservableValue)this.themeChoiceBox.getSelectionModel().selectedItemProperty());
        this.refreshInterfacesBtn.setOnAction(actionEvent -> this.interfaceChoiceService.refreshInterfaces());
        this.interfaceChoiceService.initComboBox(this.interfaceChoiceBox);
        this.infoFrequencySlider.setValue(MonitoringController.hzToSlider(this.properties.a.get()));
        this.properties.a.unbind();
        this.disableHwAccelerationToggle.setSelected(this.properties.d.get());
        this.properties.d.bind((ObservableValue)this.disableHwAccelerationToggle.selectedProperty());
        this.showInfoToggle.setSelected(this.properties.b.get());
        this.properties.b.bind((ObservableValue)this.showInfoToggle.selectedProperty());
        this.combineChartsToggle.setSelected(this.properties.a.get());
        this.properties.a.bind((ObservableValue)this.combineChartsToggle.selectedProperty());
        this.plotErrorAbsToggle.setSelected(this.properties.f.get());
        this.properties.f.bind((ObservableValue)this.plotErrorAbsToggle.selectedProperty());
        this.showPlotGridToggle.setSelected(this.properties.e.get());
        this.properties.e.bind((ObservableValue)this.showPlotGridToggle.selectedProperty());
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> MonitoringController.sliderToHz(this.infoFrequencySlider.getValue()), (Observable[])new Observable[]{this.infoFrequencySlider.valueProperty()});
        this.properties.a.bind((ObservableValue)doubleBinding);
        this.infoFrequencyLabel.textProperty().bind((ObservableValue)doubleBinding.asString("%.1f Hz"));
        this.infoFrequencySlider.setLabelFormatter(MonitoringController.frequencylabelFormatter);
        SliderUtil.setValueLabelFactory(this.infoFrequencySlider, MonitoringController::sliderToHz);
        SliderUtil.setupTargetButton(this.infoFrequencySlider, (BooleanProperty)new SimpleBooleanProperty(true), this.infoFrequencyTarget, MonitoringController::hzToSlider, MonitoringController::sliderToHz);
        this.broadcastRatioSlider.setValue(this.properties.c.get());
        IntegerBinding integerBinding = Bindings.createIntegerBinding(() -> (int)Math.max(1.0, this.broadcastRatioSlider.getValue()), (Observable[])new Observable[]{this.broadcastRatioSlider.valueProperty()});
        this.properties.c.bind((ObservableValue)integerBinding);
        this.broadcastRatioLabel.textProperty().bind((ObservableValue)integerBinding.asString("1 / %d"));
        this.broadcastRatioSlider.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)jFXSlider -> integerBinding.asString("%d")));
        SliderUtil.setupTargetButton(this.broadcastRatioSlider, (BooleanProperty)new SimpleBooleanProperty(true), this.broadcastRatioTarget, d2 -> d2, d2 -> d2);
        this.removeInterfaceBtn.setOnAction(actionEvent -> this.interfaceChoiceService.removeSelectedInterface());
        this.addInterfaceBtn.setOnAction(actionEvent -> {
            Optional<String> optional = avn.a("Interface Address (IPv4)", "10.11.12.13", this.addInterfaceBtn.getScene().getWindow());
            if (optional.isPresent()) {
                try {
                    InetSocketAddress inetSocketAddress = att.a(optional.get().trim(), 16665);
                    this.interfaceChoiceService.addInterface(inetSocketAddress);
                    return;
                }
                catch (Exception exception) {
                    azy.e(exception);
                }
            }
        });
        this.setCustomChartDirBtn.textProperty().bind((ObservableValue)this.customChartDirectory.selectedDirectoryProperty().asString());
        this.setCustomChartDirBtn.setOnAction(actionEvent -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("Select directory");
            directoryChooser.setInitialDirectory(this.customChartDirectory.getSelectedDirectory().toFile());
            Optional.ofNullable(directoryChooser.showDialog(bgt.a(actionEvent))).map(File::toPath).map(Path::toAbsolutePath).ifPresent(this.customChartDirectory::setSelectedDirectory);
        });
        this.resetCustomChartDirBtn.setOnAction(actionEvent -> this.customChartDirectory.setSelectedDirectory(null));
        this.clearAssetCacheBtn.setOnAction(bgt.a(this.clearAssetCacheBtn.disableProperty(), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                AssetCache.clear();
                Path path = this.downloadCache.h;
                if (Files.exists(path, new LinkOption[0])) {
                    Files.walkFileTree(path, new asu());
                    if (Files.exists(path, new LinkOption[0])) {
                        throw new IOException("Target path was not deleted");
                    }
                }
                azy.b("Cleared cached assets.", bgt.a(actionEvent));
                return;
            }
            catch (IOException iOException) {
                this.notificationService.f(iOException);
                return;
            }
        })));
        this.inspectorBtn.setOnAction(actionEvent -> {
            if (!azy.a("Do you want to launch the Inspector app?", bgt.a(actionEvent))) {
                return;
            }
            try {
                Inspector.b();
                return;
            }
            catch (IOException iOException) {
                azy.a(iOException, bgt.a(actionEvent));
                return;
            }
        });
        this.bootloaderBtn.setOnAction(actionEvent -> {
            if (!azy.a("This hidden button opens an internal Bootloader utility. Incorrect usage may lead to bricking your devices in a way that will not be covered by warranty. Do you want to proceed?", bgt.a(actionEvent))) {
                return;
            }
            try {
                Bootloader.a();
                return;
            }
            catch (IOException iOException) {
                azy.a(iOException, bgt.a(actionEvent));
                return;
            }
        });
        if (bgl.isAvailable()) {
            bgl2 = new bgl();
            this.checkUpdatesBtn.disableProperty().bind((ObservableValue)bgl2.M);
            this.checkUpdatesBtn.setOnAction(actionEvent -> {
                this.checkUpdatesBtn.getParent().requestFocus();
                bgl2.w((ActionEvent)actionEvent);
            });
            this.checkUpdatesBtn.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)bgl2.M).then("Working ...").otherwise("Check for updates"));
        } else if (!bgt.aU()) {
            bgt.b(this.checkUpdatesBtn);
        }
        if (atg.aw() && asv.au() || bgt.aU()) {
            bgl2 = this.macAddToShellBtn.disableProperty();
            this.macAddToShellBtn.setOnAction(arg_0 -> SettingsController.lambda$initialize$15((BooleanProperty)bgl2, arg_0));
            this.macAddToShellBtn.prefHeightProperty().bind((ObservableValue)this.checkUpdatesBtn.heightProperty());
        } else {
            bgt.b(this.macOptionPane);
        }
        this.plotInfoRttBtn.setOnAction(actionEvent -> {
            XYChart xYChart = bdc.a(0.0, 5.0, "ms");
            for (aye aye2 : this.lookupService.getRegistry().getDeviceList()) {
                xYChart.getDatasets().add((Object)aye2.a);
            }
            bgt.a((Parent)xYChart);
            Iterator iterator = new Stage();
            iterator.setScene(new Scene((Parent)xYChart));
            bgt.b((Stage)iterator);
        });
    }

    public Button getCloseButton() {
        return this.applyBtn;
    }

    private static /* synthetic */ void lambda$initialize$15(BooleanProperty booleanProperty, ActionEvent actionEvent) {
        booleanProperty.set(true);
        bgt.a(asv::a, atf2 -> {
            booleanProperty.set(false);
            Window window = bgt.a(actionEvent);
            if (atf2.aL) {
                azy.b(atf2.S, window);
                return;
            }
            azy.a(atf2.S, window);
        });
    }
}

