/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.util.OptionalDouble;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.TextFieldUtil;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.af;
import us.hebi.gui.lib.aoq;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.atk;
import us.hebi.gui.lib.axd;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.ayb;
import us.hebi.gui.lib.aye;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bbc;
import us.hebi.gui.lib.bbh;
import us.hebi.gui.lib.bgh;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.cbm;
import us.hebi.gui.lib.hf;
import us.hebi.gui.views.scope.components.ParseUtils;

public class DeviceParams {
    @FXML
    private HBox positionField;
    @FXML
    private HBox positionOffsetField;
    @FXML
    private HBox effortField;
    @FXML
    private HBox deflectionOffsetField;
    @FXML
    private Button applyBtn;
    @FXML
    private Button applySelectedBtn;
    @FXML
    private Button calibratePositionBtn;
    @Inject
    bbh module;
    @Inject
    bbc moduleSelector;
    @Inject
    bat commandService;
    final aoq cmd = new aoq();
    final ValidationSupport validation = bgh.a();

    @FXML
    void initialize() {
        axd axd2 = this.module.getFeedback();
        Object object = this.module.getInfo();
        ayb ayb2 = ((axs)object).a;
        DeviceParams deviceParams = this;
        object = ayb2;
        axd axd3 = axd2;
        deviceParams.initializeField(deviceParams.positionField, (ReadOnlyBooleanProperty)((ayb)object).E, (ReadOnlyDoubleProperty)axd3.E, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        DeviceParams deviceParams2 = this;
        object = ayb2;
        axd3 = axd2;
        deviceParams2.initializeField(deviceParams2.positionOffsetField, (ReadOnlyBooleanProperty)((ayb)object).C, (ReadOnlyDoubleProperty)axd3.E, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        DeviceParams deviceParams3 = this;
        object = ayb2;
        axd3 = axd2;
        deviceParams3.initializeField(deviceParams3.effortField, (ReadOnlyBooleanProperty)((ayb)object).D, (ReadOnlyDoubleProperty)axd3.h, ParseUtils.ONLY_ZERO_VALIDATOR);
        DeviceParams deviceParams4 = this;
        object = ayb2;
        axd3 = axd2;
        deviceParams4.initializeField(deviceParams4.deflectionOffsetField, (ReadOnlyBooleanProperty)((ayb)object).B, (ReadOnlyDoubleProperty)axd3.f, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.applyBtn.setOnAction(actionEvent -> this.sendMessage(false));
        this.applySelectedBtn.setOnAction(actionEvent -> this.sendMessage(true));
        this.applyBtn.disableProperty().bind((ObservableValue)this.module.getEmptyProperty().or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.applySelectedBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionMultiple().not().or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.deflectionOffsetField.setVisible(false);
        this.deflectionOffsetField.setManaged(false);
        if (!atk.i("hebi.scope.enableCalibrateButton")) {
            this.calibratePositionBtn.setVisible(false);
            this.calibratePositionBtn.setManaged(false);
        }
        this.calibratePositionBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionSingle().not());
        this.calibratePositionBtn.setOnAction(this::sendCalibratePosition);
    }

    private void sendCalibratePosition(ActionEvent actionEvent) {
        if (!azy.a("This will calibrate the position encoder. This action is irreversible, and \nchanges internal device state that will change the behavior of commands sent \nto the module. Make sure that the actuator is sitting on a flat surface and \nthat nothing is attached to the actuator output.", bgt.a(actionEvent))) {
            return;
        }
        ((aqt)this.cmd).clear();
        ((aqt)this.cmd).getRootMessage().a().e().a(true);
        this.commandService.a(this.moduleSelector.getSingleSelection().map(aye::a), this.cmd);
    }

    private void sendMessage(boolean bl2) {
        if (!azy.a("Are you sure you want to change the reference points? This action is irreversible, \nand changes internal device state that will change the behavior of commands sent \nto the module. Note that this will cause code commanding this module to perform \ndifferently.", this.applyBtn.getScene().getWindow())) {
            return;
        }
        ((aqt)this.cmd).clear();
        cbm cbm2 = ((aqt)this.cmd).getRootMessage().a().e();
        DeviceParams deviceParams = this;
        deviceParams.tryParseValue(deviceParams.positionField).ifPresent(d2 -> cbm2.c(true).a((float)d2));
        DeviceParams deviceParams2 = this;
        deviceParams2.tryParseValue(deviceParams2.positionOffsetField).ifPresent(d2 -> cbm2.f(true).c((float)d2));
        DeviceParams deviceParams3 = this;
        deviceParams3.tryParseValue(deviceParams3.effortField).ifPresent(d2 -> cbm2.e(true).b((float)d2));
        DeviceParams deviceParams4 = this;
        deviceParams4.tryParseValue(deviceParams4.deflectionOffsetField).ifPresent(d2 -> cbm2.g(true).d((float)d2));
        if (bl2) {
            this.commandService.a(this.moduleSelector.getSelectedAddresses(), this.cmd);
            return;
        }
        this.commandService.a(this.module.getModule().a(), this.cmd);
    }

    private void initializeField(HBox hBox, ReadOnlyBooleanProperty readOnlyBooleanProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty, Validator<String> validator) {
        CustomTextField customTextField = (CustomTextField)((Object)hBox.getChildren().get(hBox.getChildren().size() - 2));
        Button button = (Button)hBox.getChildren().get(1);
        Text text = (Text)hBox.getChildren().get(hBox.getChildren().size() - 1);
        TextFieldUtil.setupClearButtonField(customTextField);
        this.validation.registerValidator((Control)customTextField, false, validator);
        if (validator == ParseUtils.ONLY_ZERO_VALIDATOR) {
            button.setOnAction(actionEvent -> customTextField.setText("0"));
        } else {
            button.setOnAction(actionEvent -> customTextField.setText(TextUtil.format4digitsWithoutZeros(readOnlyDoubleProperty.getValue())));
        }
        text.textProperty().bind((ObservableValue)ParseUtils.asFormattedString(readOnlyDoubleProperty));
        hBox.disableProperty().bind((ObservableValue)readOnlyBooleanProperty.not().or((ObservableBooleanValue)ParseUtils.isNaN((ObservableDoubleValue)readOnlyDoubleProperty)));
        text.visibleProperty().bind((ObservableValue)hBox.disabledProperty().not());
    }

    private OptionalDouble tryParseValue(HBox hBox) {
        String string = ((CustomTextField)((Object)hBox.getChildren().get(hBox.getChildren().size() - 2))).getText();
        if (af.a(string)) {
            return OptionalDouble.empty();
        }
        Double d2 = hf.a(string);
        if (d2 == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(d2);
    }
}

