/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.plugins.YRangeIndicator;
import io.fair_acc.chartfx.plugins.YValueIndicator;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.inject.Inject;
import us.hebi.gui.lib.aue;
import us.hebi.gui.lib.axb;
import us.hebi.gui.lib.axc;
import us.hebi.gui.lib.aym;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdf;
import us.hebi.gui.lib.bds;
import us.hebi.gui.lib.bdt;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bil;

public class TfmImageView
extends VBox {
    @Inject
    axc tfmImageAnalysis;
    @Inject
    aym properties;

    public TfmImageView() {
        b.a(this);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("tfmimageview.css").toExternalForm());
        this.setPrefHeight(500.0);
        this.initialize();
    }

    void initialize() {
        Chart chart = bgt.a(this.createTfmChart(), "tfm-chart");
        Chart chart2 = bgt.a(this.createColorPicker(), "color-picker");
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{chart, chart2});
    }

    private Chart createTfmChart() {
        bds bds2 = new bds("image").a();
        bdf bdf2 = bdf.a("selected", 1000, new String[0]);
        bdf2.addStyleClasses(new String[]{"trace-points"});
        bdf2.setStyle(DataSetStyleBuilder.instance().setDatasetColor("black").setLineWidth(2.0).build());
        bdf bdf3 = bdf.a("surface", 1000, new String[0]);
        bdf3.addStyleClasses(new String[]{"trace-solid"});
        bdf3.setStyle(DataSetStyleBuilder.instance().setDatasetColor("lightgreen").setMarkerSize(3.0).build());
        XYChart xYChart = new XYChart();
        Zoomer zoomer = bdc.a();
        xYChart.getToolBar().setVisible(false);
        xYChart.getPlugins().add((Object)zoomer);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{new bdt(bds2), bdc.a()});
        DefaultNumericAxis defaultNumericAxis = (DefaultNumericAxis)xYChart.getFirstAxis(Orientation.HORIZONTAL);
        defaultNumericAxis.setTickUnit(5.0);
        defaultNumericAxis.setSide(Side.TOP);
        defaultNumericAxis.setUnit("mm");
        defaultNumericAxis.setName("x width");
        defaultNumericAxis.setAutoRanging(false);
        DefaultNumericAxis defaultNumericAxis2 = (DefaultNumericAxis)xYChart.getFirstAxis(Orientation.VERTICAL);
        defaultNumericAxis2.setTickUnit(5.0);
        defaultNumericAxis2.invertAxis(true);
        defaultNumericAxis2.setUnit("mm");
        defaultNumericAxis2.setName("z depth");
        defaultNumericAxis2.setAutoRanging(false);
        YValueIndicator yValueIndicator = new YValueIndicator((Axis)defaultNumericAxis2, 0.0);
        YValueIndicator yValueIndicator2 = new YValueIndicator((Axis)defaultNumericAxis2, 0.0);
        YRangeIndicator yRangeIndicator = new YRangeIndicator(defaultNumericAxis2, yValueIndicator.getValue(), yValueIndicator2.getValue());
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> Math.min(yValueIndicator.getValue(), yValueIndicator2.getValue()), (Observable[])new Observable[]{yValueIndicator.valueProperty(), yValueIndicator2.valueProperty()});
        DoubleBinding doubleBinding2 = Bindings.createDoubleBinding(() -> Math.max(yValueIndicator.getValue(), yValueIndicator2.getValue()), (Observable[])new Observable[]{yValueIndicator.valueProperty(), yValueIndicator2.valueProperty()});
        yRangeIndicator.lowerBoundProperty().bind((ObservableValue)doubleBinding);
        yRangeIndicator.upperBoundProperty().bind((ObservableValue)doubleBinding2);
        xYChart.getPlugins().addAll((Object[])new ChartPlugin[]{yValueIndicator, yValueIndicator2, yRangeIndicator});
        bgt.a(this.tfmImageAnalysis::n, (ObservableDoubleValue)doubleBinding);
        bgt.a(this.tfmImageAnalysis::o, (ObservableDoubleValue)doubleBinding2);
        this.tfmImageAnalysis.f(axb2 -> {
            bdf2.v(axb2.L());
            axb2.a(bdf2::f);
            bdf2.bE();
            bdf3.v(axb2.a.A.at());
            aue aue2 = bdf3::f;
            axb axb3 = axb2;
            float f2 = axb3.a.de;
            float f3 = axb3.a.df;
            int n2 = axb3.a.A.at();
            float[] fArray = axb3.a.A.A;
            for (int i2 = 0; i2 < n2; ++i2) {
                aue2.accept(f2 + f3 * (float)i2, fArray[i2]);
            }
            bdf3.bE();
            axb axb4 = axb2;
            axb3 = axb4;
            axb3 = axb2;
            bds2.a((Image)axb2.c.a, axb2.a.dg, axb4.a.dg + axb3.a.di * (float)axb3.a.hC, axb2.a.dh, axb3.a.dh + axb3.a.dj * (float)axb3.a.hD);
        });
        yValueIndicator.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MIN_DEPTH", 1.0));
        yValueIndicator2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MAX_DEPTH", 11.0));
        ObservableList<DataSet> observableList = ((Chart)xYChart).getAllDatasets();
        DataRange dataRange = new DataRange();
        DataRange dataRange2 = new DataRange();
        Runnable runnable = () -> {
            double d2;
            if (!zoomer.zoomStackDeque().isEmpty()) {
                return;
            }
            dataRange.clear();
            dataRange2.clear();
            for (DataSet dataSet : observableList) {
                AxisDescription axisDescription = dataSet.getAxisDescription(0);
                dataRange.add(axisDescription.getMin());
                dataRange.add(axisDescription.getMax());
                AxisDescription axisDescription2 = dataSet.getAxisDescription(1);
                dataRange2.add(axisDescription2.getMin());
                dataRange2.add(axisDescription2.getMax());
            }
            double d3 = dataRange.getLength() / xYChart.getCanvas().getWidth();
            double d4 = dataRange2.getLength() / xYChart.getCanvas().getHeight();
            double d5 = d3 / d4;
            if (d2 > 1.0) {
                double d6 = dataRange2.getLength() * (d5 - 1.0);
                DataRange dataRange3 = dataRange2;
                dataRange3.set(dataRange3.getMin(), dataRange2.getMax() + d6);
            } else if (d5 < 1.0) {
                double d7 = dataRange.getLength() * (1.0 / d5 - 1.0);
                DataRange dataRange4 = dataRange;
                dataRange4.set(dataRange4.getMin(), dataRange.getMax() + d7);
            }
            if (doubleBinding2.get() > dataRange2.getMax()) {
                if (yValueIndicator.getValue() > dataRange2.getMax()) {
                    yValueIndicator.setValue(dataRange2.getMax());
                }
                if (yValueIndicator2.getValue() > dataRange2.getMax()) {
                    yValueIndicator2.setValue(dataRange2.getMax());
                }
            }
            if (doubleBinding.get() < dataRange2.getMin()) {
                if (yValueIndicator.getValue() < dataRange2.getMin()) {
                    yValueIndicator.setValue(dataRange2.getMin());
                }
                if (yValueIndicator2.getValue() < dataRange2.getMin()) {
                    yValueIndicator2.setValue(dataRange2.getMin());
                }
            }
            defaultNumericAxis.set(dataRange.getMin(), dataRange.getMax());
            defaultNumericAxis2.set(dataRange2.getMin(), dataRange2.getMax());
        };
        bgt.b(runnable, new Observable[]{xYChart.getCanvas().heightProperty(), xYChart.getCanvas().widthProperty()});
        bds2.addListener((bitState, n2) -> bgt.b(runnable));
        return xYChart;
    }

    private Chart createColorPicker() {
        Color[] colorArray = this.tfmImageAnalysis.b.a();
        azi azi2 = new azi(1.0, 1.0);
        azi azi3 = new azi(1.0, 1.0);
        azi azi4 = new azi((double)colorArray.length, 1.0);
        azi2.a(0, colorArray[0]);
        azi3.a(0, colorArray[colorArray.length - 1]);
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            azi4.a(i2, colorArray[i2]);
        }
        XYChart xYChart = new XYChart();
        xYChart.setLegendVisible(false);
        xYChart.getGridRenderer().getHorizontalMajorGrid().setVisible(false);
        xYChart.getGridRenderer().getVerticalMajorGrid().setVisible(false);
        xYChart.getToolBar().setVisible(false);
        Axis axis = xYChart.getXAxis();
        axis.setTickUnit(100.0);
        axis.setUnit(null);
        axis.setName("intensity");
        XValueIndicator xValueIndicator = new XValueIndicator(axis, 0.0);
        XValueIndicator xValueIndicator2 = new XValueIndicator(axis, 0.0);
        xYChart.getPlugins().addAll((Object[])new ChartPlugin[]{xValueIndicator, xValueIndicator2});
        bil bil2 = new bil(this, axis);
        bgt.a(this.tfmImageAnalysis::m, (ObservableDoubleValue)bil2.valueProperty());
        xYChart.getPlugins().add((Object)bil2);
        bds bds2 = new bds("below");
        bds bds3 = new bds("above");
        bds bds4 = new bds("range");
        xYChart.getRenderers().setAll((Object[])new Renderer[]{new bdt(bds2, bds3, bds4)});
        bgt.b(() -> {
            double d2;
            double d3 = Math.min(xValueIndicator.getValue(), xValueIndicator2.getValue());
            double d4 = Math.max(xValueIndicator.getValue(), xValueIndicator2.getValue());
            this.tfmImageAnalysis.b.dV = d2 = d3;
            this.tfmImageAnalysis.b.D = d2 = d4;
            bds2.a((Image)azi2.a, 0.0, d3, 0.0, 0.1);
            bds3.a((Image)azi3.a, d4, 350.0, 0.0, 0.1);
            bds4.a((Image)azi4.a, d3, d4, 0.0, 0.1);
        }, new Observable[]{xValueIndicator.valueProperty(), xValueIndicator2.valueProperty()});
        xValueIndicator.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_COLORMAP_MIN", 50.0));
        xValueIndicator2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_COLORMAP_MAX", 235.0));
        bil2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MIN_INTENSITY", 122.0));
        return xYChart;
    }
}

