/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.utils;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.hebi.gui.lib.aui;
import us.hebi.gui.lib.bqs;
import us.hebi.gui.lib.bqu;
import us.hebi.gui.lib.bre;
import us.hebi.gui.lib.brg;
import us.hebi.gui.lib.chn;
import us.hebi.gui.lib.chw;
import us.hebi.gui.views.maps.utils.MapsFeedbackDataSet;

public class MapsFeedbackRenderer
extends AbstractRendererXY<MapsFeedbackRenderer> {
    chw ascan;
    aui xToDisplay;
    aui yToDisplay;
    double ascanLineWidth = 2.0;
    double gateLineWidth = 2.0;
    double gateLineSideLength = 4.0;
    double refPosWidth = 4.0;

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof MapsFeedbackDataSet)) {
            return;
        }
        MapsFeedbackDataSet mapsFeedbackDataSet = (MapsFeedbackDataSet)dataSet;
        this.xToDisplay = d2 -> this.xAxis.getDisplayPosition(mapsFeedbackDataSet.xTransform.apply(d2));
        this.yToDisplay = d2 -> this.yAxis.getDisplayPosition(mapsFeedbackDataSet.yTransform.apply(d2));
        this.ascan = mapsFeedbackDataSet.utData.a;
        bqu bqu2 = mapsFeedbackDataSet.message.a.a;
        brg brg2 = mapsFeedbackDataSet.message.a.a;
        graphicsContext.save();
        this.drawAscan(graphicsContext, dataSetNode.getLineColor());
        if (brg2.cd()) {
            graphicsContext.setLineWidth(this.refPosWidth);
            graphicsContext.setStroke(dataSetNode.getMarkerColor());
            graphicsContext.setLineDashes(dataSetNode.getMarkerLineDashes());
            this.drawDashedVerticalLine(graphicsContext, brg2.ep);
            graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        }
        this.drawGate(graphicsContext, bqu2.a, brg2.a, bqu2.ca, 0, Color.RED);
        this.drawGate(graphicsContext, bqu2.b, brg2.b, bqu2.ca, brg2.a.em, Color.GREEN);
        this.drawGate(graphicsContext, bqu2.c, brg2.c, bqu2.ca, brg2.b.em, Color.BLUE);
        graphicsContext.restore();
    }

    private void drawAscan(GraphicsContext graphicsContext, Paint paint) {
        if (this.ascan.at() == 0) {
            return;
        }
        graphicsContext.setLineWidth(this.ascanLineWidth);
        graphicsContext.setStroke(paint);
        graphicsContext.beginPath();
        graphicsContext.moveTo(this.xToDisplay.apply(0.0), this.yToDisplay.apply(this.ascan.a(0)));
        for (int i2 = 1; i2 < this.ascan.at(); ++i2) {
            graphicsContext.lineTo(this.xToDisplay.apply(i2), this.yToDisplay.apply(this.ascan.a(i2)));
        }
        graphicsContext.stroke();
    }

    private void drawGate(GraphicsContext graphicsContext, bqs bqs2, bre bre2, boolean bl2, int n2, Color color) {
        if (((chn)bqs2).isEmpty()) {
            return;
        }
        if (!bl2) {
            n2 = 0;
        }
        double d2 = this.xToDisplay.apply(bqs2.ee + n2);
        double d3 = this.xToDisplay.apply(bqs2.ee + bqs2.ef + n2);
        double d4 = this.yToDisplay.apply(bqs2.eg);
        double d5 = this.yToDisplay.apply((double)bqs2.eg + this.gateLineSideLength);
        double d6 = this.yToDisplay.apply((double)bqs2.eg - this.gateLineSideLength);
        graphicsContext.setStroke((Paint)color);
        graphicsContext.setLineWidth(this.gateLineWidth);
        graphicsContext.strokeLine(d2, d4, d3, d4);
        graphicsContext.strokeLine(d2, d5, d2, d6);
        graphicsContext.strokeLine(d3, d5, d3, d6);
        if (!((chn)bre2).isEmpty()) {
            DefaultMarker.drawCross(graphicsContext, this.xToDisplay.apply(bre2.em), d4, 8.0);
            DefaultMarker.drawEmptyCircle(graphicsContext, this.xToDisplay.apply(bre2.en), this.yToDisplay.apply(bre2.eo), 8.0);
        }
    }

    private void drawDashedVerticalLine(GraphicsContext graphicsContext, int n2) {
        graphicsContext.strokeLine(this.xToDisplay.apply(n2), Math.min(this.yToDisplay.apply(-128.0), this.yToDisplay.apply(0.0)), this.xToDisplay.apply(n2), Math.max(this.yToDisplay.apply(127.0), this.yToDisplay.apply(0.0)));
    }

    @Override
    protected MapsFeedbackRenderer getThis() {
        return this;
    }
}

