/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.hrdf;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Generated;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.cfr;
import us.hebi.gui.lib.chf;
import us.hebi.gui.lib.chg;
import us.hebi.gui.lib.cht;
import us.hebi.gui.views.maps.hrdf.DirectoryUpdateService;

public class ProbeLoader
extends DirectoryUpdateService {
    final ObservableList<cfr> probes = FXCollections.observableArrayList();

    public ProbeLoader() {
        super("probes");
    }

    public void forceReload() {
        this.probes.clear();
        this.onDirectoryUpdate();
    }

    public void saveProbe(cfr cfr2) {
        Path path = this.getDirectoryPath().resolve(cfr2.aq.a(cht.a) + ".json");
        if (Files.isRegularFile(path, new LinkOption[0]) && !this.notificationService.j("This probe already exists. Do you want to overwrite the content?")) {
            return;
        }
        try {
            Files.writeString(path, (CharSequence)cfr2.toString(), new OpenOption[0]);
            return;
        }
        catch (IOException iOException) {
            this.notificationService.f(iOException);
            return;
        }
    }

    @Override
    protected void onDirectoryUpdate() {
        CompletableFuture.supplyAsync(this::loadSourceFiles, this.executor).thenAcceptAsync(arg_0 -> this.probes.setAll(arg_0), bgt.c);
    }

    private List<cfr> loadSourceFiles() {
        ArrayList<cfr> arrayList;
        block12: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getDirectoryPath(), "*.json");
            try {
                ArrayList<cfr> arrayList2 = new ArrayList<cfr>();
                for (Path path : directoryStream) {
                    if (Files.size(path) <= 0L) continue;
                    chg chg2 = chf.a(Files.readAllBytes(path));
                    try {
                        cfr cfr2 = cfr.a(chg2);
                        if (!cfr2.ov()) {
                            cfr2.a(path.getFileName().toString());
                        }
                        arrayList2.add(cfr2);
                    }
                    catch (IOException iOException) {
                        System.err.println(String.valueOf(path) + " could not be parsed: " + iOException.getMessage());
                    }
                }
                arrayList = arrayList2;
                if (directoryStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    bgt.b(() -> this.notificationService.f(iOException));
                    return Collections.emptyList();
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    @Generated
    public ObservableList<cfr> getProbes() {
        return this.probes;
    }
}

