/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.state;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.CategoryAxis;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.BasicDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import lombok.Generated;
import org.HdrHistogram.PackedDoubleHistogram;
import us.hebi.gui.lib.bcx;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bde;
import us.hebi.gui.lib.bdq;
import us.hebi.gui.lib.bdv;
import us.hebi.gui.lib.beb;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bhz;
import us.hebi.gui.lib.bia;
import us.hebi.gui.lib.bib;
import us.hebi.gui.lib.bic;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.lib.cht;
import us.hebi.gui.lib.na;
import us.hebi.gui.lib.nb;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.logviewer.state.VisibilityState;

public class ChartList {
    final XYChart sharedTimeChart;
    DoubleProperty indicatorTime;
    na time;
    bek traceType;
    PackedDoubleHistogram tmpHistogram;
    na tmpSortValues;
    private static final boolean DISABLE_USER_RANGE = true;
    final List<NamedChart> charts;
    public final VisibilityState visibilityState;

    public ChartList() {
        Optional<XValueIndicator> optional;
        block1: {
            XYChart xYChart = bdc.a(0.0, 0.0, "");
            bde bde2 = new bde(xYChart.getXAxis(), "", xYChart);
            xYChart.getPlugins().add((Object)bde2);
            this.sharedTimeChart = xYChart;
            for (ChartPlugin chartPlugin : this.sharedTimeChart.getPlugins()) {
                if (!(chartPlugin instanceof XValueIndicator)) continue;
                optional = Optional.of((XValueIndicator)chartPlugin);
                break block1;
            }
            optional = Optional.empty();
        }
        this.indicatorTime = optional.map(AbstractSingleValueIndicator::valueProperty).orElseThrow();
        this.traceType = bek.a;
        this.tmpHistogram = new PackedDoubleHistogram(2);
        this.tmpSortValues = new na(0);
        this.charts = new ArrayList<NamedChart>();
        this.visibilityState = new VisibilityState();
    }

    public ChartList clear() {
        this.charts.clear();
        return this;
    }

    public ChartList addXyzCommandChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray, na[] naArray2) {
        bek bek2 = this.traceType;
        try {
            this.setTraceType(bek.a);
            ChartList chartList = this;
            Renderer renderer = chartList.toXyzRenderer(n2 -> this.time, naArray2);
            this.setTraceType(bek.b);
            ChartList chartList2 = this;
            Renderer renderer2 = chartList2.toXyzRenderer(n2 -> this.time, naArray).setShowInLegend(false);
            for (int i2 = 0; i2 < naArray.length; ++i2) {
                DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
                ((DataSetNode)renderer2.getDatasetNodes().get(i2)).visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
            ChartList chartList3 = this;
            ChartList chartList4 = chartList3.addChart(chartList3.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, renderer, renderer2));
            return chartList4;
        }
        finally {
            this.setTraceType(bek2);
        }
    }

    public ChartList addXyzErrorChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray, na[] naArray2) {
        bpd.b(this.time, (Object)"time must be set");
        Renderer renderer = bdc.a();
        for (int i2 = 0; i2 < naArray2.length; ++i2) {
            renderer.getDatasets().add((Object)new bdq("", this.time, naArray[i2], naArray2[i2]).addStyleClasses(new String[]{this.traceType.D(), bcx.b(i2)}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, renderer));
    }

    public ChartList addXyzChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray) {
        ChartList chartList = this;
        Renderer[] rendererArray = new Renderer[1];
        ChartList chartList2 = this;
        rendererArray[0] = chartList2.toXyzRenderer(n2 -> this.time, naArray);
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, rendererArray));
    }

    public ChartList addCommandChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray, na[] naArray2) {
        bek bek2 = this.traceType;
        try {
            this.setTraceType(bek.a);
            Renderer renderer = this.toDeviceRenderer(naArray2);
            this.setTraceType(bek.b);
            Renderer renderer2 = this.toDeviceRenderer(naArray).setShowInLegend(false);
            for (int i2 = 0; i2 < naArray.length; ++i2) {
                DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
                dataSetNode.getStyleClass().add((Object)"feedback");
                DataSetNode dataSetNode2 = (DataSetNode)renderer2.getDatasetNodes().get(i2);
                dataSetNode2.getStyleClass().add((Object)"command");
                dataSetNode2.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
            ChartList chartList = this;
            ChartList chartList2 = chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer, renderer2));
            return chartList2;
        }
        finally {
            this.setTraceType(bek2);
        }
    }

    public ChartList addPhaseChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray, na[] naArray2, na[] naArray3) {
        ChartList chartList = this;
        Renderer renderer = chartList.toDeviceRenderer((int n2) -> this.time, naArray);
        ChartList chartList2 = this;
        Renderer renderer2 = chartList2.toDeviceRenderer((int n2) -> this.time, naArray2).setShowInLegend(false);
        ChartList chartList3 = this;
        Renderer renderer3 = chartList3.toDeviceRenderer((int n2) -> this.time, naArray3).setShowInLegend(false);
        for (int i2 = 0; i2 < naArray.length; ++i2) {
            DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
            DataSetNode dataSetNode2 = (DataSetNode)renderer2.getDatasetNodes().get(i2);
            DataSetNode dataSetNode3 = (DataSetNode)renderer3.getDatasetNodes().get(i2);
            dataSetNode2.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            dataSetNode3.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
        }
        ChartList chartList4 = this;
        return chartList4.addChart(chartList4.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer, renderer2, renderer3));
    }

    public ChartList addQuaternionTraces(Supplier<String> supplier, String string, na[] naArray) {
        return this.addTimeTraces(supplier, string, "quaternion", -1.0, 1.0, naArray, (Renderer renderer) -> {
            ChartList.updateDataSet(renderer, 0, "W", "color-primary");
            ChartList.updateDataSet(renderer, 1, "X", "color-red");
            ChartList.updateDataSet(renderer, 2, "Y", "color-green");
            ChartList.updateDataSet(renderer, 3, "Z", "color-blue");
        });
    }

    private static void updateDataSet(Renderer renderer, int n2, String string, String ... stringArray) {
        DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(n2);
        ((AbstractDataSet)dataSetNode.getDataSet()).setName(string);
        dataSetNode.getStyleClass().addAll((Object[])stringArray);
    }

    public ChartList addErrorChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray, na[] naArray2) {
        bpd.b(this.time, (Object)"time must be set");
        Renderer renderer = bdc.a();
        for (int i2 = 0; i2 < naArray2.length; ++i2) {
            renderer.addDataSet(new bdq("", this.time, naArray[i2], naArray2[i2]).addStyleClasses(new String[]{"error", this.traceType.D()}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer));
    }

    public ChartList addDeviceChart(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, this.toDeviceRenderer(naArray)));
    }

    public ChartList addDeviceXY(Supplier<String> supplier, String string, Axis axis, na[] naArray, Axis axis2, na[] naArray2) {
        XYChart xYChart = bdc.a(new XYChart(axis, axis2));
        Renderer renderer = this.toDeviceRenderer((int n2) -> naArray[n2], naArray2);
        return this.addChart(new bhz(this, supplier, string, xYChart, renderer));
    }

    public void applyDeviceVisibility(Renderer renderer) {
        int n2 = 0;
        for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
            ((AbstractDataSet)dataSetNode.getDataSet()).setName(this.visibilityState.getDeviceName(n2));
            BooleanProperty booleanProperty = this.visibilityState.deviceVisibilityProperty(n2);
            booleanProperty.unbind();
            dataSetNode.setVisible(booleanProperty.get());
            booleanProperty.bind((ObservableValue)dataSetNode.visibleProperty());
            ++n2;
        }
    }

    private void applyXyzVisibility(Renderer renderer) {
        int n2 = 0;
        for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
            ((AbstractDataSet)dataSetNode.getDataSet()).setName(this.visibilityState.getXyzName(n2));
            BooleanProperty booleanProperty = this.visibilityState.xyzVisibilityProperty(n2);
            booleanProperty.unbind();
            dataSetNode.setVisible(booleanProperty.get());
            booleanProperty.bind((ObservableValue)dataSetNode.visibleProperty());
            ++n2;
        }
    }

    public ChartList addSingleTrace(Supplier<String> supplier, String string, String string2, double d2, double d3, na na2) {
        return this.addTimeTraces(supplier, string, string2, d2, d3, na2, (Renderer renderer) -> bdc.a(renderer, 0, string, new String[0]));
    }

    public ChartList addStandaloneTimeTrace(Supplier<String> supplier, String string, na na2, na na3) {
        XYChart xYChart = bdc.a(Double.NaN, Double.NaN, null);
        Consumer<Renderer> consumer = renderer -> {};
        DataSet[] dataSetArray = new DataSet[1];
        dataSetArray[0] = new beb(string, na2::size, na2::a, na3::a);
        BasicDataSetRenderer basicDataSetRenderer = new BasicDataSetRenderer(dataSetArray);
        return this.addChart(ChartList.newChart(xYChart, supplier, consumer, string, null, Double.NaN, Double.NaN, basicDataSetRenderer));
    }

    public ChartList addCombinedUserStates(Supplier<String> supplier, String string, na[] naArray) {
        XYChart xYChart = bdc.a(Double.NaN, Double.NaN, null);
        Consumer<Renderer> consumer = renderer -> {};
        BasicDataSetRenderer basicDataSetRenderer = new BasicDataSetRenderer(new DataSet[0]);
        for (int i2 = 1; i2 < naArray.length; ++i2) {
            na na2 = naArray[0];
            na na3 = naArray[i2];
            basicDataSetRenderer.addDataSet(new beb("State " + i2, na2::size, na2::a, na3::a));
        }
        return this.addChart(ChartList.newChart(xYChart, supplier, consumer, string, null, Double.NaN, Double.NaN, basicDataSetRenderer));
    }

    public ChartList addTimeTraces(Supplier<String> supplier, String string, String string2, double d2, double d3, na na2, Consumer<Renderer> consumer) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, consumer, string, string2, d2, d3, this.toDeviceRenderer(na2)));
    }

    public ChartList addTimeTraces(Supplier<String> supplier, String string, String string2, double d2, double d3, na[] naArray, Consumer<Renderer> consumer) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, consumer, string, string2, d2, d3, this.toDeviceRenderer(naArray)));
    }

    public ChartList addMedianBarChart(Supplier<String> supplier, String string, Axis axis, na[] naArray) {
        double[] dArray = Stream.of(naArray).mapToDouble(this::getMedian).toArray();
        return this.addIndexBarChart(supplier, string, axis, n2 -> dArray[n2], naArray.length);
    }

    private double getMedian(na na2) {
        if (na2.size() == 0) {
            return Double.NaN;
        }
        na na3 = this.tmpSortValues;
        this.tmpSortValues.ag = 0;
        na na4 = na2;
        na na5 = this.tmpSortValues;
        boolean bl2 = false;
        nb nb2 = na4.a();
        while (nb2.hasNext()) {
            double d2 = nb2.c();
            na5.c(d2);
            bl2 = true;
        }
        na5 = this.tmpSortValues;
        Arrays.sort(na5.b, 0, na5.ag);
        return this.tmpSortValues.a(this.tmpSortValues.size() / 2);
    }

    public ChartList addIndexBarChart(Supplier<String> supplier, String string, Axis axis, IntToDoubleFunction intToDoubleFunction, int n3) {
        if (n3 <= 1) {
            return this;
        }
        ObservableList observableList = FXCollections.observableArrayList();
        for (int i2 = 0; i2 < n3; ++i2) {
            observableList.add((Object)String.valueOf(i2 + 1));
        }
        CategoryAxis categoryAxis = new CategoryAxis("Index", (ObservableList<String>)observableList);
        categoryAxis.setUnit(null);
        XYChart xYChart = bdc.a(new XYChart(categoryAxis, axis));
        xYChart.setLegendVisible(false);
        ErrorDataSetRenderer errorDataSetRenderer = new ErrorDataSetRenderer();
        errorDataSetRenderer.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{errorDataSetRenderer});
        errorDataSetRenderer.addDataSet(new beb(string, () -> n3, n2 -> n2, intToDoubleFunction));
        xYChart.getGridRenderer().getHorizontalMajorGrid().visibleProperty().set(false);
        xYChart.getGridRenderer().getVerticalMajorGrid().visibleProperty().set(true);
        return this.addCustomChart(supplier, string, visibilityState -> xYChart);
    }

    public ChartList addAsHistogram(Supplier<String> supplier, String string, String string2, na[] naArray) {
        return this.addAsHistogram(supplier, string, string2, naArray, this::applyDeviceVisibility);
    }

    public ChartList addAsHistogram(Supplier<String> supplier, String string, String string2, na[] naArray, Consumer<Renderer> consumer) {
        Renderer renderer = bdc.a();
        for (int i2 = 0; i2 < naArray.length; ++i2) {
            renderer.getDatasets().add((Object)bdv.a(naArray[i2], this.tmpHistogram).addStyleClasses(new String[]{"trace-solid"}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newPercentileChart(supplier, consumer, string, string2, Double.NaN, Double.NaN, renderer));
    }

    private Renderer toDeviceRenderer(na ... naArray) {
        bpd.b(this.time, (Object)"time must be set");
        ChartList chartList = this;
        return chartList.toDeviceRenderer((int n2) -> this.time, naArray);
    }

    private Renderer toDeviceRenderer(IntFunction<na> intFunction, na[] naArray) {
        Renderer renderer = bdc.a();
        for (int i2 = 0; i2 < naArray.length; ++i2) {
            renderer.getDatasets().add((Object)new beb("", intFunction.apply(i2), naArray[i2]).addStyleClasses(new String[]{this.traceType.D()}));
        }
        return renderer;
    }

    private Renderer toXyzRenderer(IntFunction<na> intFunction, na[] naArray) {
        bpd.a(naArray.length == 3, "Expected xyz data");
        Renderer renderer = bdc.a();
        for (int i2 = 0; i2 < naArray.length; ++i2) {
            renderer.getDatasets().add((Object)new beb("", intFunction.apply(i2), naArray[i2]).addStyleClasses(new String[]{bcx.b(i2), this.traceType.D()}));
        }
        return renderer;
    }

    public ChartList setTraceType(bek bek2) {
        this.traceType = bpd.b(bek2);
        return this;
    }

    public ChartList setTime(na na2) {
        this.time = na2;
        return this;
    }

    public List<TreeItem<NamedChart>> createHierarchy() {
        Stream<String> stream = Stream.of(ChartCategory.values()).map(ChartCategory::get);
        Stream<String> stream2 = this.charts.stream().map(NamedChart::getCategory);
        return Stream.concat(stream, stream2).distinct().map(this::newCategory).filter(treeItem -> treeItem.getChildren().size() > 0).toList();
    }

    private TreeItem<NamedChart> newCategory(String string) {
        TreeItem treeItem = new TreeItem((Object)new bia(this, string));
        treeItem.setExpanded(true);
        this.charts.stream().filter(namedChart -> cht.a(string, namedChart.getCategory())).forEach(namedChart -> treeItem.getChildren().add((Object)new TreeItem(namedChart)));
        return treeItem;
    }

    public List<NamedChart> getCharts() {
        return this.charts;
    }

    public ChartList addChart(NamedChart namedChart) {
        this.charts.add(namedChart);
        return this;
    }

    public ChartList addCustomChart(Supplier<String> supplier, String string, Function<VisibilityState, Chart> function) {
        return this.addChart(new bib(this, supplier, string, function));
    }

    private NamedChart newTimeChart(Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        if (this.isUserRangeDisabled(supplier, string)) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        return ChartList.newChart(this.sharedTimeChart != null ? this.sharedTimeChart : bdc.a(d2, d3, string2), supplier, consumer, string, string2, d2, d3, rendererArray);
    }

    private NamedChart newPercentileChart(Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        if (this.isUserRangeDisabled(supplier, string)) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        return ChartList.newChart(bdc.a(), supplier, consumer, string, string2, d2, d3, rendererArray);
    }

    private static NamedChart newChart(XYChart xYChart, Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        Renderer[] rendererArray2 = rendererArray;
        int n2 = rendererArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            rendererArray2[i2].getAxes().setAll(xYChart.getAxes());
        }
        return new bic(supplier, string, xYChart, consumer, rendererArray, string2, d2, d3);
    }

    private boolean isUserRangeDisabled(Supplier<String> supplier, String string) {
        return supplier != ChartCategory.Network;
    }

    @Generated
    public DoubleProperty getIndicatorTime() {
        return this.indicatorTime;
    }

    @Generated
    public VisibilityState getVisibilityState() {
        return this.visibilityState;
    }
}

