/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.mapslog.data;

import java.util.function.Supplier;
import us.hebi.gui.lib.adp;
import us.hebi.gui.lib.avg;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdu;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bqm;
import us.hebi.gui.lib.brq;
import us.hebi.gui.lib.bsc;
import us.hebi.gui.lib.bss;
import us.hebi.gui.lib.bsu;
import us.hebi.gui.lib.buo;
import us.hebi.gui.lib.bux;
import us.hebi.gui.lib.bvb;
import us.hebi.gui.lib.chn;
import us.hebi.gui.lib.cic;
import us.hebi.gui.lib.cie;
import us.hebi.gui.lib.na;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class MapsLogFeedback
extends adp {
    private static final Supplier<String> poseCategory = () -> "World Pose";
    private static final Supplier<String> MapPointCategory = () -> "Mapped Point";
    private static final Supplier<String> utCategory = () -> "UT Data";
    private static final Supplier<String> RobotCategory = () -> "Robot";
    private static final Supplier<String> RuntimeCategory = () -> "Runtime";
    long startTime = 0L;
    int numJoints = -1;
    int maxEntries = -1;
    public na time;
    public na mapX;
    public na mapY;
    public na mapTheta;
    public na mapDistance;
    public na mapAngularDistance;
    public na[] mapXyz;
    public na runtimeAmbientTemperature;
    public na runtimeBatteryVoltage;
    public na runtimePcResidentMemoryUsage;
    public na runtimePcVirtualMemoryUsage;
    public na runtimePcUserCpuUsage;
    public na runtimePcKernelCpuUsage;
    public na runtimePcTemperature;
    public na runtimePcVoltage;
    public na runtimeMainCycleTimeMs;
    public na runtimeMainBusyTimeMs;
    public na runtimeCyclesSincePositionSourceData;
    public na utThicknessSamples;
    public na[] poseTranslation;
    public na[] poseOrientation;
    public na poseDelay;
    public na[] position;
    public na[] velocity;
    public na[] power;
    public na[] sequence;
    public na[] rxSequence;
    public na[] temperature;
    public na[] voltage;
    public na[] roundTripTime;
    public na[] hwResponseTime;
    public na[] transmitTimeDelta;
    public na[] packetLoss;
    public na[] firstOrientation;
    private final bss prevRobotFbk = bss.a();

    public MapsLogFeedback() {
        this.init(8192);
    }

    public MapsLogFeedback init(int n2) {
        this.maxEntries = n2;
        this.resize();
        return this;
    }

    private na[] resizeGroup(na[] naArray) {
        return this.resizeMultiple(naArray, this.numJoints);
    }

    private na[] resizeMultiple(na[] naArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(naArray, n2, this.maxEntries);
    }

    private na resizeSingle(na na2) {
        return TDoubleArrayListRegistry.resizeSingle(na2, this.maxEntries);
    }

    @Override
    public void onHeader(bvb bvb2) {
        if (bvb2.eF()) {
            this.startTime = bvb2.bc;
            return;
        }
        if (bvb2.eE()) {
            this.startTime = bvb2.T;
        }
    }

    @Override
    public void onResponse(bux bux2, bsc bsc2, int n2) {
        if (!bsc2.cz()) {
            return;
        }
        bqm bqm2 = bsc2.a;
        brq brq2 = bsc2.a.a;
        this.time.c(avg.a(bux2.T - this.startTime));
        this.mapX.c(brq2.o);
        this.mapY.c(brq2.p);
        this.mapTheta.c(brq2.z);
        this.mapDistance.c(brq2.A);
        this.mapAngularDistance.c(brq2.B);
        this.mapXyz[0].c((double)brq2.a.o * 1000.0);
        this.mapXyz[1].c((double)brq2.a.p * 1000.0);
        this.mapXyz[2].c((double)brq2.a.q * 1000.0);
        bsu bsu2 = bsc2.a.a;
        this.runtimeAmbientTemperature.c(bsu2.aj);
        this.runtimeBatteryVoltage.c(bsu2.ak);
        this.runtimePcResidentMemoryUsage.c(bsu2.al / 1024.0f);
        this.runtimePcVirtualMemoryUsage.c(bsu2.am / 1024.0f);
        this.runtimePcUserCpuUsage.c(bsu2.an);
        this.runtimePcKernelCpuUsage.c(bsu2.ao);
        this.runtimePcTemperature.c(bsu2.ap);
        this.runtimePcVoltage.c(bsu2.aq);
        this.runtimeMainCycleTimeMs.c(bsu2.ar);
        this.runtimeMainBusyTimeMs.c(bsu2.as);
        this.runtimeCyclesSincePositionSourceData.c((double)bsu2.ey);
        this.utThicknessSamples.c((double)bqm2.a.ep);
        buo buo2 = bsc2.a.a;
        this.poseTranslation[0].c((double)buo2.d.o * 1000.0);
        this.poseTranslation[1].c((double)buo2.d.p * 1000.0);
        this.poseTranslation[2].c((double)buo2.d.q * 1000.0);
        this.poseOrientation[0].c(buo2.c.ai);
        this.poseOrientation[1].c(buo2.c.o);
        this.poseOrientation[2].c(buo2.c.p);
        this.poseOrientation[3].c(buo2.c.q);
        this.poseDelay.c((double)buo2.eJ);
        if (bqm2.bG()) {
            bss bss2 = bqm2.a;
            if (this.numJoints < 0) {
                this.numJoints = bss2.b.at();
                this.resizeRobotFeedback(bss2);
            }
            MapsLogFeedback mapsLogFeedback = this;
            mapsLogFeedback.addMultiple(mapsLogFeedback.position, bss2.b);
            MapsLogFeedback mapsLogFeedback2 = this;
            mapsLogFeedback2.addMultiple(mapsLogFeedback2.velocity, bss2.c);
            MapsLogFeedback mapsLogFeedback3 = this;
            mapsLogFeedback3.addMultiple(mapsLogFeedback3.power, bss2.d);
            MapsLogFeedback mapsLogFeedback4 = this;
            mapsLogFeedback4.addMultiple(mapsLogFeedback4.sequence, bss2.a);
            MapsLogFeedback mapsLogFeedback5 = this;
            mapsLogFeedback5.addMultiple(mapsLogFeedback5.rxSequence, bss2.b);
            MapsLogFeedback mapsLogFeedback6 = this;
            mapsLogFeedback6.addMultiple(mapsLogFeedback6.temperature, bss2.e);
            MapsLogFeedback mapsLogFeedback7 = this;
            mapsLogFeedback7.addMultiple(mapsLogFeedback7.voltage, bss2.f);
            MapsLogFeedback mapsLogFeedback8 = this;
            mapsLogFeedback8.addMultiple(mapsLogFeedback8.firstOrientation, bss2.g);
            for (int i2 = 0; i2 < this.roundTripTime.length; ++i2) {
                this.roundTripTime[i2].c(1000.0 * avg.a(bss2.e.e(i2) - bss2.f.e(i2)));
                this.hwResponseTime[i2].c(1000.0 * avg.a(bss2.d.e(i2) - bss2.c.e(i2)));
                if (((chn)this.prevRobotFbk).isEmpty()) {
                    this.transmitTimeDelta[i2].c(Double.NaN);
                    this.packetLoss[i2].c(Double.NaN);
                    continue;
                }
                double d2 = avg.a(bss2.f.e(i2) - this.prevRobotFbk.f.e(i2));
                this.transmitTimeDelta[i2].c(d2 * 1000.0);
                this.packetLoss[i2].c(bss2.a.e(i2) - this.prevRobotFbk.a.e(i2) - 1L);
            }
            this.prevRobotFbk.a(bss2);
        }
    }

    private void addMultiple(na[] naArray, cic cic2) {
        for (int i2 = 0; i2 < naArray.length; ++i2) {
            naArray[i2].c(cic2.a(i2));
        }
    }

    private void addMultiple(na[] naArray, cie cie2) {
        for (int i2 = 0; i2 < naArray.length; ++i2) {
            naArray[i2].c(cie2.e(i2));
        }
    }

    public void getCharts(ChartList chartList) {
        chartList.setTime(this.time).setTraceType(bek.a).addTimeTraces(MapPointCategory, "Position XY", null, 0.0, 1.0, new na[]{this.mapX, this.mapY}, renderer -> {
            bdc.a(renderer, 0, "X", "trace-solid");
            bdc.a(renderer, 1, "Y", "trace-solid");
        }).addDeviceXY(MapPointCategory, "Position XY (2D)", bdu.a("X", null), new na[]{this.mapX}, bdu.a("Y", null), new na[]{this.mapY}).addSingleTrace(MapPointCategory, "Theta", null, 0.0, 1.0, this.mapTheta).addSingleTrace(MapPointCategory, "Distance", null, 0.0, 0.0, this.mapDistance).addSingleTrace(MapPointCategory, "Angular Distance", null, 0.0, 0.0, this.mapAngularDistance).addXyzChart(MapPointCategory, "Position XYZ (closest)", "mm", -50.0, 50.0, this.mapXyz).addXyzChart(poseCategory, "Position XYZ", "mm", -50.0, 50.0, this.poseTranslation).addQuaternionTraces(poseCategory, "Orientation", this.poseOrientation).addSingleTrace(poseCategory, "Delay", "ms", 0.0, 10.0, this.poseDelay);
        if (!((chn)this.prevRobotFbk).isEmpty()) {
            chartList.setTraceType(bek.a).addDeviceChart(RobotCategory, "Position", "rad", -1.5707963267948966, 1.5707963267948966, this.position).addDeviceChart(RobotCategory, "Velocity", "rad/s", -5.0, 5.0, this.velocity).addDeviceChart(RobotCategory, "Power", "W", 0.0, 1.0, this.power).addDeviceChart(RobotCategory, "Voltage", "V", 0.0, 50.0, this.voltage).addDeviceChart(RobotCategory, "Temperature", "\u00b0C", 0.0, 100.0, this.temperature).addQuaternionTraces(RobotCategory, "First Orientation", this.firstOrientation).setTraceType(bek.c).addDeviceChart(RobotCategory, "Round Trip Time", "ms", 0.0, 0.5, this.roundTripTime).addAsHistogram(RobotCategory, "Round Trip Time %", "ms", this.roundTripTime).addDeviceChart(RobotCategory, "Hardware Response Time", "ms", 0.0, 0.5, this.hwResponseTime).addAsHistogram(RobotCategory, "Hardware Response Time %", "ms", this.hwResponseTime).addDeviceChart(RobotCategory, "Transmit Time Delta", "ms", 0.0, 0.5, this.transmitTimeDelta).addAsHistogram(RobotCategory, "Transmit Time Delta %", "ms", this.transmitTimeDelta).addDeviceChart(RobotCategory, "Packet Loss", "", 0.0, 1.0, this.packetLoss).addAsHistogram(RobotCategory, "Packet Loss %", "", this.packetLoss).addDeviceChart(RobotCategory, "Rx Sequence", "", 0.0, 1.0, this.rxSequence).setTraceType(bek.a);
        }
        chartList.setTraceType(bek.a).addTimeTraces(RuntimeCategory, "Voltage", "V", 0.0, 50.0, new na[]{this.runtimeBatteryVoltage, this.runtimePcVoltage}, renderer -> {
            bdc.a(renderer, 0, "battery", new String[0]);
            bdc.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Temperature", "\u00b0C", 0.0, 50.0, new na[]{this.runtimeAmbientTemperature, this.runtimePcTemperature}, renderer -> {
            bdc.a(renderer, 0, "ambient", new String[0]);
            bdc.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "CPU Usage", "%", 0.0, 100.0, new na[]{this.runtimePcUserCpuUsage, this.runtimePcKernelCpuUsage}, renderer -> {
            bdc.a(renderer, 0, "user", new String[0]);
            bdc.a(renderer, 1, "kernel", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Memory Usage", "MB", 0.0, 10.0, new na[]{this.runtimePcResidentMemoryUsage, this.runtimePcVirtualMemoryUsage}, renderer -> {
            bdc.a(renderer, 0, "resident", new String[0]);
            bdc.a(renderer, 1, "virtual", new String[0]);
        }).addSingleTrace(RuntimeCategory, "Cycles Since Position", null, 0.0, 1.0, this.runtimeCyclesSincePositionSourceData).setTraceType(bek.c).addTimeTraces(RuntimeCategory, "Main Loop Times", "ms", 0.0, 10.0, new na[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            bdc.a(renderer, 0, "cycle time", new String[0]);
            bdc.a(renderer, 1, "busy time", new String[0]);
        }).addAsHistogram(RuntimeCategory, "Main Loop Times %", "ms", new na[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            bdc.a(renderer, 0, "cycle time", new String[0]);
            bdc.a(renderer, 1, "busy time", new String[0]);
        });
    }

    private void resize() {
        this.time = this.resizeSingle(this.time);
        this.mapX = this.resizeSingle(this.mapX);
        this.mapY = this.resizeSingle(this.mapY);
        this.mapTheta = this.resizeSingle(this.mapTheta);
        this.mapDistance = this.resizeSingle(this.mapDistance);
        this.mapAngularDistance = this.resizeSingle(this.mapAngularDistance);
        this.mapXyz = this.resizeMultiple(this.mapXyz, 3);
        this.runtimeAmbientTemperature = this.resizeSingle(this.runtimeAmbientTemperature);
        this.runtimeBatteryVoltage = this.resizeSingle(this.runtimeBatteryVoltage);
        this.runtimePcResidentMemoryUsage = this.resizeSingle(this.runtimePcResidentMemoryUsage);
        this.runtimePcVirtualMemoryUsage = this.resizeSingle(this.runtimePcVirtualMemoryUsage);
        this.runtimePcUserCpuUsage = this.resizeSingle(this.runtimePcUserCpuUsage);
        this.runtimePcKernelCpuUsage = this.resizeSingle(this.runtimePcKernelCpuUsage);
        this.runtimePcTemperature = this.resizeSingle(this.runtimePcTemperature);
        this.runtimePcVoltage = this.resizeSingle(this.runtimePcVoltage);
        this.runtimeMainCycleTimeMs = this.resizeSingle(this.runtimeMainCycleTimeMs);
        this.runtimeMainBusyTimeMs = this.resizeSingle(this.runtimeMainBusyTimeMs);
        this.runtimeCyclesSincePositionSourceData = this.resizeSingle(this.runtimeCyclesSincePositionSourceData);
        this.utThicknessSamples = this.resizeSingle(this.utThicknessSamples);
        this.poseTranslation = this.resizeMultiple(this.poseTranslation, 3);
        this.poseOrientation = this.resizeMultiple(this.poseOrientation, 4);
        this.poseDelay = this.resizeSingle(this.poseDelay);
    }

    private void resizeRobotFeedback(bss bss2) {
        this.numJoints = bss2.b.at();
        this.position = this.resizeMultiple(this.position, bss2.b.at());
        this.velocity = this.resizeMultiple(this.velocity, bss2.c.at());
        this.power = this.resizeMultiple(this.power, bss2.d.at());
        this.sequence = this.resizeMultiple(this.sequence, bss2.a.at());
        this.rxSequence = this.resizeMultiple(this.rxSequence, bss2.b.at());
        this.roundTripTime = this.resizeMultiple(this.roundTripTime, bss2.c.at());
        this.hwResponseTime = this.resizeMultiple(this.hwResponseTime, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.packetLoss = this.resizeMultiple(this.packetLoss, this.roundTripTime.length);
        this.temperature = this.resizeMultiple(this.temperature, bss2.e.at());
        this.voltage = this.resizeMultiple(this.voltage, bss2.f.at());
        this.firstOrientation = this.resizeMultiple(this.firstOrientation, 4);
        this.prevRobotFbk.c();
    }
}

