/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import io.fair_acc.chartfx.renderer.Renderer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.na;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class MobileIoFeedback
implements GroupFeedbackHandler {
    public na time;
    public na[] orientation;
    public na[] arOrientation;
    public na[] arPosition;
    public na arQuality;
    public na[] magnetometer;
    public na batteryLevel;
    public na[] buttons;
    public na[] axes;
    int ix = -1;
    int maxEntries = -1;

    public MobileIoFeedback init(int n2, int n3) {
        if (this.ix != n2 || this.maxEntries != n3) {
            this.ix = n2;
            this.maxEntries = n3;
            this.resize();
        }
        return this;
    }

    @Override
    public void init(int n2) {
    }

    @Override
    public void onGroupFeedback(double d2, FlatFeedback[] flatFeedbackArray, FlatFeedback[] flatFeedbackArray2) {
        if (this.ix < 0) {
            return;
        }
        FlatFeedback flatFeedback = flatFeedbackArray2[this.ix];
        this.time.c(d2);
        this.orientation[0].c(flatFeedback.orientationW);
        this.orientation[1].c(flatFeedback.orientationX);
        this.orientation[2].c(flatFeedback.orientationY);
        this.orientation[3].c(flatFeedback.orientationZ);
        this.arOrientation[0].c(flatFeedback.arOrientationW);
        this.arOrientation[1].c(flatFeedback.arOrientationX);
        this.arOrientation[2].c(flatFeedback.arOrientationY);
        this.arOrientation[3].c(flatFeedback.arOrientationZ);
        this.arPosition[0].c(flatFeedback.arPositionX * XyzLogData.XYZ_SCALE);
        this.arPosition[1].c(flatFeedback.arPositionY * XyzLogData.XYZ_SCALE);
        this.arPosition[2].c(flatFeedback.arPositionZ * XyzLogData.XYZ_SCALE);
        this.arQuality.c(flatFeedback.arQuality);
        this.magnetometer[0].c(flatFeedback.magnetometerX * 1000000.0);
        this.magnetometer[1].c(flatFeedback.magnetometerY * 1000000.0);
        this.magnetometer[2].c(flatFeedback.magnetometerZ * 1000000.0);
        this.batteryLevel.c(flatFeedback.batteryLevel);
        this.axes[0].c(flatFeedback.a1);
        this.axes[1].c(flatFeedback.a2);
        this.axes[2].c(flatFeedback.a3);
        this.axes[3].c(flatFeedback.a4);
        this.axes[4].c(flatFeedback.a5);
        this.axes[5].c(flatFeedback.a6);
        this.axes[6].c(flatFeedback.a7);
        this.axes[7].c(flatFeedback.a8);
        this.buttons[0].c(flatFeedback.b1);
        this.buttons[1].c(flatFeedback.b2);
        this.buttons[2].c(flatFeedback.b3);
        this.buttons[3].c(flatFeedback.b4);
        this.buttons[4].c(flatFeedback.b5);
        this.buttons[5].c(flatFeedback.b6);
        this.buttons[6].c(flatFeedback.b7);
        this.buttons[7].c(flatFeedback.b8);
    }

    public void getCharts(ChartList chartList) {
        if (this.ix < 0) {
            return;
        }
        Supplier<String> supplier = () -> MobileIoFeedback.lambda$getCharts$0((String)(this.ix == 0 ? "MobileIO" : "MobileIO (" + (this.ix + 1) + ")"));
        chartList.setTime(this.time).setTraceType(bek.a).addQuaternionTraces(supplier, "Orientation", this.orientation).addQuaternionTraces(supplier, "AR Orientation", this.arOrientation).addXyzChart(supplier, "AR Position", "mm", -50.0, 50.0, this.arPosition).addTimeTraces(supplier, "AR Quality", "enum", 0.0, 5.0, this.arQuality, renderer -> {}).addXyzChart(supplier, "Magnetometer", "uT", -300.0, 300.0, this.magnetometer).addTimeTraces(supplier, "Battery Level", "%", 0.0, 100.0, this.batteryLevel, renderer -> {}).addTimeTraces(supplier, "Axes", "[0-1]", -1.0, 1.0, this.axes, MobileIoFeedback.colors8("A")).addTimeTraces(supplier, "Buttons", "[0-1]", 0.0, 1.0, this.buttons, MobileIoFeedback.colors8("B"));
    }

    private static Consumer<Renderer> colors8(String string) {
        return renderer -> {
            for (int i2 = 0; i2 < 8; ++i2) {
                bdc.a(renderer, i2, string + (i2 + 1), new String[0]);
            }
        };
    }

    @Override
    public void onInvalidate() {
        GroupFeedbackHandler.super.onInvalidate();
    }

    private void resize() {
        this.time = this.resizeSingle(this.time);
        this.orientation = this.resizeMultiple(this.orientation, 4);
        this.arOrientation = this.resizeMultiple(this.arOrientation, 4);
        this.arPosition = this.resizeMultiple(this.arPosition, 3);
        this.arQuality = this.resizeSingle(this.arQuality);
        this.magnetometer = this.resizeMultiple(this.magnetometer, 3);
        this.batteryLevel = this.resizeSingle(this.batteryLevel);
        this.buttons = this.resizeMultiple(this.buttons, 8);
        this.axes = this.resizeMultiple(this.axes, 8);
    }

    private na[] resizeMultiple(na[] naArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(naArray, n2, this.maxEntries);
    }

    private na resizeSingle(na na2) {
        return TDoubleArrayListRegistry.resizeSingle(na2, this.maxEntries);
    }

    private static /* synthetic */ String lambda$getCharts$0(String string) {
        return string;
    }
}

