/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import us.hebi.core.messages.flat.BaseFlatFeedback;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.adg;
import us.hebi.gui.lib.adj;
import us.hebi.gui.lib.ado;
import us.hebi.gui.lib.aku;
import us.hebi.gui.lib.apk;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.avg;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.lib.byw;
import us.hebi.gui.lib.chr;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;

public class HebiLogAnalysis$FeedbackSynchronizer
implements ado {
    private apk msg;
    private FlatFeedback flatFbk;
    private aku fbkSync;
    private byw userState = byw.a();
    private double startTime = Double.NaN;
    private double absoluteTimeOffset = Double.NaN;
    private long timestampOffset = -1L;
    private final List<GroupFeedbackHandler> fbkHandlers = new ArrayList<GroupFeedbackHandler>();
    protected int numDevices = 0;

    public int getNumDevices() {
        return this.numDevices;
    }

    public int getNumReceived(int n2) {
        return this.fbkSync.X[n2];
    }

    public OptionalDouble getStartTime() {
        if (Double.isNaN(this.startTime)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.startTime);
    }

    public OptionalDouble getAbsoluteTimeOffset() {
        if (Double.isNaN(this.absoluteTimeOffset)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.absoluteTimeOffset);
    }

    public int[] getNumReceived() {
        return this.fbkSync.X;
    }

    public int[] getNumDropped() {
        return this.fbkSync.Y;
    }

    public int getNumSynced() {
        return this.fbkSync.cg;
    }

    @Override
    public void onHeader(adg adg2) {
        this.numDevices = adg2.getAddressMap().C();
        if (adg2.K()) {
            this.timestampOffset = adg2.o();
            this.startTime = avg.a(adg2.o());
        }
        if (adg2.L()) {
            this.absoluteTimeOffset = avg.a(adg2.p());
        }
        this.msg = new apk();
        this.flatFbk = new FlatFeedback();
        this.fbkSync = new aku(adg2.getAddressMap().C());
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().init(this.numDevices);
        }
    }

    @Override
    public void onEntry(adj adj2, int n2, long l2, chr chr2) throws IOException {
        if (adj2 == adj.a) {
            this.onFeedback(n2, l2, chr2);
            return;
        }
        if (adj2 == adj.c) {
            this.onUserState(l2, chr2);
        }
    }

    public void onFeedback(int n2, long l2, chr chr2) throws IOException {
        ((aqt)this.msg).clear();
        this.msg.a(l2, chr2);
        if (!this.msg.at()) {
            return;
        }
        if (this.timestampOffset < 0L) {
            this.timestampOffset = l2;
        }
        double d2 = avg.a(l2 - this.timestampOffset);
        ((BaseFlatFeedback)this.flatFbk).a(d2, this.msg);
        byw byw2 = this.userState;
        FlatFeedback flatFeedback = this.flatFbk;
        this.flatFbk.state1 = byw2.bw;
        flatFeedback.state2 = byw2.bx;
        flatFeedback.state3 = byw2.by;
        flatFeedback.state4 = byw2.bz;
        flatFeedback.state5 = byw2.bA;
        flatFeedback.state6 = byw2.bB;
        flatFeedback.state7 = byw2.bC;
        flatFeedback.state8 = byw2.bD;
        flatFeedback.state9 = byw2.bE;
        if (this.fbkSync.a(n2, this.flatFbk)) {
            this.onGroupFeedback(d2, this.fbkSync.b, this.fbkSync.a);
            this.fbkSync.ac();
        }
    }

    protected void onGroupFeedback(double d2, FlatFeedback[] flatFeedbackArray, FlatFeedback[] flatFeedbackArray2) {
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onGroupFeedback(d2, flatFeedbackArray, flatFeedbackArray2);
        }
    }

    public void onUserState(long l2, chr chr2) throws IOException {
        this.userState.b().a(chr2);
        double d2 = avg.a(l2 - this.timestampOffset);
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onUserState(d2, this.userState);
        }
    }

    @Override
    public void onEoF() {
        this.msg = null;
        this.flatFbk = null;
        this.fbkSync = null;
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onInvalidate();
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public HebiLogAnalysis$FeedbackSynchronizer addHandler(GroupFeedbackHandler groupFeedbackHandler) {
        this.fbkHandlers.add(bpd.b(groupFeedbackHandler));
        return this;
    }

    public HebiLogAnalysis$FeedbackSynchronizer addHandlers(Collection<? extends GroupFeedbackHandler> collection) {
        this.fbkHandlers.addAll(collection);
        return this;
    }
}

