/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.io.IOException;
import java.util.Optional;
import us.hebi.gui.lib.ac;
import us.hebi.gui.lib.adg;
import us.hebi.gui.lib.adj;
import us.hebi.gui.lib.ado;
import us.hebi.gui.lib.ah;
import us.hebi.gui.lib.aky;
import us.hebi.gui.lib.amo;
import us.hebi.gui.lib.apk;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.avg;
import us.hebi.gui.lib.chr;

public class HebiLogAnalysis$BasicLogInfo
implements ado {
    int[] numInfoReceived = new int[0];
    int[] numFbkReceived = new int[0];
    apk[] infos = new apk[0];
    int numUserStateEntries = 0;
    long firstTimestamp = -1L;
    long lastTimestamp = -1L;
    aky addressMap = aky.a();

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void onHeader(adg adg2) {
        this.addressMap = adg2.getAddressMap();
        this.numFbkReceived = new int[adg2.getAddressMap().C()];
        this.numInfoReceived = new int[adg2.getAddressMap().C()];
        this.infos = new apk[adg2.getAddressMap().C()];
        this.numUserStateEntries = 0;
        this.firstTimestamp = -1L;
        this.lastTimestamp = -1L;
    }

    @Override
    public void onEntry(adj adj2, int n2, long l2, chr chr2) throws IOException {
        if (adj2 == adj.a) {
            int n3 = n2;
            this.numFbkReceived[n3] = this.numFbkReceived[n3] + 1;
            if (this.firstTimestamp < 0L) {
                this.firstTimestamp = l2;
            }
        } else if (adj2 == adj.b) {
            int n4 = n2;
            this.numInfoReceived[n4] = this.numInfoReceived[n4] + 1;
            if (this.infos[n2] == null) {
                apk apk2 = new apk();
                apk2.a(l2, chr2);
                this.infos[n2] = apk2;
            }
        } else if (adj2 == adj.c) {
            ++this.numUserStateEntries;
        }
        this.lastTimestamp = l2;
    }

    @Override
    public void onEoF() {
    }

    public aky getAddressMap() {
        return this.addressMap;
    }

    public int getNumDevices() {
        return this.addressMap.C();
    }

    public boolean hasInfo() {
        apk[] apkArray = this.infos;
        int n2 = this.infos.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (apkArray[i2] != null) continue;
            return false;
        }
        return true;
    }

    public Optional<amo> getInfo(int n2) {
        return Optional.ofNullable(this.infos[n2]);
    }

    public String getName(int n2) {
        return this.getInfo(n2).map(amo::getName).orElseGet(() -> "joint" + n2);
    }

    public boolean isMobileIO(int n2) {
        return Optional.ofNullable(this.infos[n2]).map(object -> ((aqt)((apk)object)).getRootMessage()).filter(bzp2 -> bzp2.b.gv()).isPresent();
    }

    public int[] getInfoCount() {
        return (int[])this.numInfoReceived.clone();
    }

    public int[] getFeedbackCount() {
        return (int[])this.numFbkReceived.clone();
    }

    public int getFeedbackCount(int n2) {
        return this.numFbkReceived[n2];
    }

    public int getMaxFeedbackCount() {
        int[] nArray = this.numFbkReceived;
        ah.a(this.numFbkReceived.length > 0);
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public int getMinFeedbackCount() {
        int[] nArray = this.numFbkReceived;
        ah.a(this.numFbkReceived.length > 0);
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public int getTotalFeedbackCount() {
        int n2 = 0;
        int[] nArray = this.numFbkReceived;
        int n3 = this.numFbkReceived.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            n2 += n4;
        }
        return n2;
    }

    public long getTotalDurationMicros() {
        return this.lastTimestamp - this.firstTimestamp;
    }

    public double getTotalDuration() {
        return avg.a(this.getTotalDurationMicros());
    }

    public String toString() {
        String string = "BasicStats";
        double d2 = this.getTotalDuration();
        String string2 = "duration";
        int[] nArray = this.numFbkReceived;
        String string3 = "numFbk";
        ac ac2 = new ac(string, 0).a("duration", String.valueOf(d2)).a("numFbk", nArray);
        nArray = this.numInfoReceived;
        string3 = "numInfo";
        return ac2.a("numInfo", nArray).toString();
    }
}

