/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.custom;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.amo;
import us.hebi.gui.lib.arn;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.beb;
import us.hebi.gui.lib.beq;
import us.hebi.gui.lib.ber;
import us.hebi.gui.lib.bes;
import us.hebi.gui.lib.bhx;
import us.hebi.gui.lib.na;

public class DeviceData {
    final ald deviceAddress;
    String family;
    String name;
    final na time = new na();
    final List<ber> xmlCharts;
    final HashMap<String, bhx> expressionMap = new HashMap();
    final List<bhx> traceValues;
    private boolean hasInfo = false;
    private final arn info = new arn();
    private List<List<DataSet>> allChartTraces = Collections.emptyList();

    public DeviceData(ald ald2, List<ber> list, int n2) {
        this.xmlCharts = list;
        this.deviceAddress = ald2;
        for (ber ber2 : list) {
            for (bes bes2 : ber2.getTraces()) {
                if (this.expressionMap.containsKey(bes2.getValue())) continue;
                this.expressionMap.put(bes2.getValue(), new bhx(bes2.getFunc(), new na(n2)));
            }
            beq beq2 = ber2.getAxisX();
            if (beq2 == null || this.expressionMap.containsKey(beq2.getExpression())) continue;
            this.expressionMap.put(beq2.getExpression(), new bhx(beq2.getFunc(), new na(n2)));
        }
        this.traceValues = List.copyOf(this.expressionMap.values());
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public amo getInfo() {
        return this.info;
    }

    public void addInfo(amo amo2) {
        this.family = amo2.getFamily();
        this.name = amo2.getName();
        this.info.a(amo2);
        this.hasInfo = true;
    }

    public void addFeedback(double d2, FlatFeedback flatFeedback, FlatFeedback flatFeedback2) {
        this.time.c(d2);
        Iterator<bhx> iterator = this.traceValues.iterator();
        while (iterator.hasNext()) {
            FlatFeedback flatFeedback3 = flatFeedback2;
            FlatFeedback flatFeedback4 = flatFeedback;
            bhx bhx2 = iterator.next();
            bhx2.d.c(bhx2.a.computeValue(flatFeedback4, flatFeedback3));
        }
    }

    public void convertToDataSets() {
        double[] dArray = DeviceData.toArrayAndReset(this.time);
        this.allChartTraces = new ArrayList<List<DataSet>>(this.xmlCharts.size());
        for (int i2 = 0; i2 < this.xmlCharts.size(); ++i2) {
            ber ber2 = this.xmlCharts.get(i2);
            int n2 = ber2.getTraces().size();
            ArrayList<beb> arrayList = new ArrayList<beb>(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                bes bes2 = ber2.getTraces().get(i3);
                double[] dArray2 = ber2.getAxisX() == null ? dArray : this.getValues(ber2.getAxisX().getExpression());
                double[] dArray3 = this.getValues(bes2.getValue());
                String string = bes2.getLabel() + "[" + bes2.getUnits() + "]";
                beb beb2 = new beb(string, dArray2, dArray3);
                beb2.addStyleClasses(new String[]{bes2.getStyle().D()});
                beb2.setStyle(DataSetStyleBuilder.instance().setDatasetColor(bdc.a(bes2.getColor())).build());
                arrayList.add(beb2);
            }
            this.allChartTraces.add(arrayList);
        }
    }

    public List<DataSet> getDataSets(int n2) {
        return this.allChartTraces.get(n2);
    }

    static double[] toArrayAndReset(na na2) {
        try {
            double[] dArray = na2.a();
            return dArray;
        }
        finally {
            na2.E();
        }
    }

    private double[] getValues(String string) {
        bhx bhx2 = this.expressionMap.get(string);
        if (bhx2.M == null) {
            bhx2.M = DeviceData.toArrayAndReset(bhx2.d);
        }
        return bhx2.M;
    }

    public String toString() {
        if (this.family != null || this.name != null) {
            return this.family + " | " + this.name;
        }
        return String.valueOf(this.deviceAddress).substring(1);
    }
}

