/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer;

import io.fair_acc.chartfx.XYChart;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Material;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.e;
import us.hebi.gui.lib.adb;
import us.hebi.gui.lib.aft;
import us.hebi.gui.lib.aje;
import us.hebi.gui.lib.ajg;
import us.hebi.gui.lib.amo;
import us.hebi.gui.lib.aul;
import us.hebi.gui.lib.avq;
import us.hebi.gui.lib.ayh;
import us.hebi.gui.lib.ayq;
import us.hebi.gui.lib.ayx;
import us.hebi.gui.lib.azf;
import us.hebi.gui.lib.azg;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azo;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.bcf;
import us.hebi.gui.lib.bdb;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bge;
import us.hebi.gui.lib.bgs;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bgx;
import us.hebi.gui.lib.bgy;
import us.hebi.gui.lib.bhm;
import us.hebi.gui.lib.bhn;
import us.hebi.gui.lib.bhp;
import us.hebi.gui.lib.bhu;
import us.hebi.gui.lib.bka;
import us.hebi.gui.lib.blg;
import us.hebi.gui.lib.blh;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.views.logviewer.custom.CustomLogviewerView;
import us.hebi.gui.views.logviewer.hebilog.HebiLogContent;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.MobileIoFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.scope.assets.Asset;

public class LogviewerPresenter
extends bge {
    @FXML
    private Pane root;
    @FXML
    private TreeView<NamedChart> plotTree;
    @FXML
    private AnchorPane chartPane;
    @FXML
    private Button saveGainsBtn;
    @FXML
    private Button loadHrdfOrConfigBtn;
    @FXML
    private Button loadCustomBtn;
    @FXML
    private Button showInfoBtn;
    @FXML
    private Button view3dBtn;
    public static final PseudoClass CELL_CATEGORY = PseudoClass.getPseudoClass((String)"category");
    final TreeItem<NamedChart> rootNode = new TreeItem();
    @Inject
    HebiLogContent logContent;
    @Inject
    bcf fileChooser;
    @Inject
    ayh properties;
    @Inject
    azz notificationService;
    bgy indicator = new bgy();
    DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    bgs timer = bgs.a(d2 -> this.selectedTime.set(this.selectedTime.get() + d2));
    IntegerBinding selectedIndex = Bindings.createIntegerBinding(() -> {
        double d2 = this.selectedTime.get();
        if (!Double.isFinite(d2) || this.logContent == null || !this.logContent.hasValidFeedback()) {
            return -1;
        }
        return this.logContent.getFeedback().getIndexAt(d2);
    }, (Observable[])new Observable[]{this.selectedTime});
    BooleanProperty showModelCmd = new SimpleBooleanProperty(false);
    SimpleObjectProperty<Parent> infoTable = new SimpleObjectProperty();

    @Override
    public void initializeFx() {
        bhp.e((Parent)this.root);
        this.indicator.a((Pane)this.root).loading.bind((ObservableValue)this.logContent.loadingProperty());
        this.logContent.loadAsync().thenRunAsync(this::updateChartMenu, Platform::runLater);
        XYChart xYChart = bdc.a(-10.0, 10.0, "");
        this.chartPane.getChildren().setAll((Object[])new Node[]{bgt.c(xYChart)});
        bgx.b((Node)this.chartPane);
        this.plotTree.setCellFactory(LogviewerPresenter::createStyledCell);
        this.plotTree.setRoot(this.rootNode);
        this.plotTree.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> {
            if (treeItem2 == null || treeItem2.getValue() == null || ((NamedChart)treeItem2.getValue()).isCategory()) {
                return;
            }
            this.chartPane.getChildren().setAll((Object[])new Node[]{bgt.c(((NamedChart)treeItem2.getValue()).getChart())});
        });
        this.showInfoBtn.disableProperty().bind((ObservableValue)this.infoTable.isNull());
        this.showInfoBtn.setOnAction(actionEvent -> this.chartPane.getChildren().setAll((Object[])new Node[]{bgt.c((Parent)this.infoTable.get())}));
        this.saveGainsBtn.disableProperty().bind((ObservableValue)this.logContent.hasInfoProperty().not());
        this.saveGainsBtn.setOnAction(actionEvent -> {
            Window window = bgt.a(actionEvent);
            File file = this.fileChooser.f(window);
            if (file != null) {
                try {
                    File file2 = file;
                    aft aft2 = aft.a(this.logContent.getInfo());
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        aft2.a(fileOutputStream);
                    }
                    azy.a(file, window);
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.f(exception);
                }
            }
        });
        this.loadHrdfOrConfigBtn.setOnAction(actionEvent -> {
            Window window = bgt.a(actionEvent);
            File file = this.fileChooser.c(window);
            if (file != null) {
                try {
                    this.logContent.setRobotConfig(null);
                    if (adb.a(file) == adb.e) {
                        ajg ajg2 = ajg.tryReadFile(file.toPath());
                        this.logContent.setRobotConfig(ajg2);
                        file = new File(bpd.b(ajg2.getHrdf(), (Object)"Robot config does not specify an hrdf"));
                    }
                    int n2 = blh.a(file).a().S();
                    if (this.logContent.getNumJoints() != n2) {
                        throw new IllegalArgumentException("The log file contains " + this.logContent.getNumJoints() + " joints, but the selected HRDF lists " + n2 + " joints.");
                    }
                    this.logContent.setHrdfFile(file, this.logContent.getIndexMap());
                    this.updateChartMenu();
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.f(exception);
                }
            }
        });
        this.loadCustomBtn.setOnAction(actionEvent -> new CustomLogviewerView(this.logContent.getFile()).getViewAsync(parent -> {
            Stage stage = new Stage();
            stage.getIcons().add((Object)e.b);
            stage.setTitle(this.logContent.getFileName());
            stage.setScene(new Scene(parent));
            bgt.a(stage, bgt.a(actionEvent));
        }));
        if (!bgt.aV()) {
            this.view3dBtn.setDisable(true);
        } else {
            BooleanBinding booleanBinding = Bindings.size(this.logContent.getMobileIoList()).isEqualTo(0);
            this.view3dBtn.disableProperty().bind((ObservableValue)booleanBinding.and((ObservableBooleanValue)this.logContent.hasValidHrdf().not()));
            this.view3dBtn.setOnAction(actionEvent -> {
                Window window = bgt.a(actionEvent);
                if (this.logContent.hasValidHrdf().get()) {
                    this.launchStage(window, (Pane)this.createRobotView3d());
                }
                for (MobileIoFeedback mobileIoFeedback : this.logContent.getMobileIoList()) {
                    this.launchStage(window, (Pane)this.createMobileIo3d(mobileIoFeedback));
                }
            });
        }
        this.selectedTime.bindBidirectional((Property)this.logContent.getChartList().getIndicatorTime());
        bgt.a((Node)this.root, this::registerKeyHandler);
    }

    private void launchStage(Window window, Pane pane) {
        Stage stage = new Stage();
        stage.getIcons().add((Object)e.b);
        stage.setTitle(this.logContent.getFileName());
        stage.setScene(new Scene((Parent)pane, 700.0, 450.0, true));
        bgt.a(stage, window);
        Stage stage2 = stage;
        bgx.a(stage2, () -> ((Stage)stage2).close());
    }

    private void registerKeyHandler(Scene scene) {
        scene.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (bgx.o.match(keyEvent)) {
                this.timer.bS();
                keyEvent.consume();
                return;
            }
            if (bgx.a.match(keyEvent)) {
                this.showModelCmd.set(!this.showModelCmd.get());
                keyEvent.consume();
                return;
            }
            if (bgx.e.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() - 1.0);
                keyEvent.consume();
                return;
            }
            if (bgx.f.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() + 1.0);
                keyEvent.consume();
            }
        });
    }

    private AnchorPane createRobotView3d() {
        azl azl2 = new azl().a();
        avq avq2 = azl2.a;
        ayx ayx2 = new ayx(this.logContent.getXmlContent());
        ayx2.s.bind((ObservableValue)azl2.e.visibleProperty());
        ayx2.t.bind((ObservableValue)avq2.a("CoM Axes", false));
        Object object = "Models";
        ayx2.u.bind((ObservableValue)avq2.a("Models", true));
        BooleanProperty booleanProperty = avq2.a("Command Overlay", this.showModelCmd.get(), "ctrl + f");
        bgt.a(booleanProperty, this.showModelCmd);
        ayx ayx3 = new ayx(this.logContent.getXmlContent());
        ayx3.s.set(false);
        ayx3.t.set(false);
        ayx3.u.bind((ObservableValue)ayx2.u);
        ayx3.c.visibleProperty().bind((ObservableValue)booleanProperty);
        azg.a((Node)ayx3.c, (Material)ayx.c);
        XyzLogData xyzLogData = this.logContent.getXyzData();
        azf azf2 = new azf(xyzLogData.xyzPosition, bdb.f);
        azf azf3 = new azf(xyzLogData.xyzPositionCmd, bdb.e);
        object = "Fbk Line";
        azf2.visibleProperty().bind((ObservableValue)avq2.a("Fbk Line", true));
        object = "Cmd Line";
        azf3.visibleProperty().bind((ObservableValue)avq2.a("Cmd Line", true));
        BooleanProperty booleanProperty2 = avq2.a("Full Line", false);
        azf2.D.bind((ObservableValue)booleanProperty2);
        azf3.D.bind((ObservableValue)booleanProperty2);
        Node node = ayx.a();
        node.visibleProperty().bind((ObservableValue)ayx2.t);
        bka bka2 = blh.a(this.logContent.getXmlContent()).a();
        object = node;
        ayq ayq2 = new ayq(new blg(bka2));
        new ayq(new blg(bka2)).b = object;
        azl azl3 = azl2;
        object = azl3.d;
        v0.a = object;
        ayq ayq3 = ayq2;
        this.logContent.getRobotConfig().flatMap(aje::getGravComp).ifPresent(ayq3::a);
        ayq3.q.bind((ObservableValue)avq2.a("Orient Base", false));
        ayq3.r.bind((ObservableValue)avq2.a("Offset Base", false));
        ayq3.update();
        bgt.a(avq2.a("Play", this.timer.N.get(), "ctrl + space"), this.timer.N);
        azl3 = azl2;
        azl3.d.getChildren().setAll((Object[])new Node[]{ayx2.c, ayx3.c, azf2, azf3, node});
        aul aul2 = this.logContent.getIndexMap();
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            azf3.u(n2);
            azf2.u(n2);
            HebiLogFeedback hebiLogFeedback = this.logContent.getFeedback();
            for (int i2 = 0; i2 < hebiLogFeedback.getNumJoints(); ++i2) {
                int n3 = aul2.apply(i2);
                ayx2.b(i2, hebiLogFeedback.position[n3].a(n2));
                ayx3.b(i2, hebiLogFeedback.positionCmd[n3].a(n2));
                ayq3.a(i2, hebiLogFeedback.position[n3].a(n2));
                ayq3.a(i2, hebiLogFeedback.orientationW[n3].a(n2), hebiLogFeedback.orientationX[n3].a(n2), hebiLogFeedback.orientationY[n3].a(n2), hebiLogFeedback.orientationZ[n3].a(n2));
            }
            ayq3.update();
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        bgt.a((Node)azl2, this::registerKeyHandler);
        bhn.d((Parent)azl2);
        bhm.b((Parent)azl2);
        bhp.e((Parent)azl2);
        bgt.a((Parent)azl2);
        return azl2;
    }

    private AnchorPane createMobileIo3d(MobileIoFeedback mobileIoFeedback) {
        azl azl2 = new azl().a();
        avq avq2 = azl2.a;
        String string = "Model";
        BooleanProperty booleanProperty = avq2.a("Model", true);
        azo azo2 = new azo(new Node[0]);
        Asset.Iphone.getModelAsync(group -> {
            group.visibleProperty().bind((ObservableValue)booleanProperty);
            azo2.getChildren().add(group);
        });
        azf azf2 = new azf(mobileIoFeedback.arPosition, bdb.i);
        BooleanProperty booleanProperty2 = avq2.a("Full Path", false);
        string = "Path";
        azf2.visibleProperty().bind((ObservableValue)avq2.a("Path", true));
        azf2.D.bind((ObservableValue)booleanProperty2);
        bgt.a(avq2.a("Play", this.timer.N.get(), "ctrl + space"), this.timer.N);
        azl azl3 = azl2;
        azl3.d.getChildren().setAll((Object[])new Node[]{azf2, azo2});
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            azf2.u(n2);
            azo2.b(mobileIoFeedback.arOrientation[0].a(n2), mobileIoFeedback.arOrientation[1].a(n2), mobileIoFeedback.arOrientation[2].a(n2), mobileIoFeedback.arOrientation[3].a(n2), mobileIoFeedback.arPosition[0].a(n2), mobileIoFeedback.arPosition[1].a(n2), mobileIoFeedback.arPosition[2].a(n2));
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        bgt.a((Node)azl2, this::registerKeyHandler);
        bhn.d((Parent)azl2);
        bhm.b((Parent)azl2);
        bhp.e((Parent)azl2);
        bgt.a((Parent)azl2);
        return azl2;
    }

    public void updateChartMenu() {
        this.plotTree.getSelectionModel().clearSelection();
        this.rootNode.getChildren().setAll(this.logContent.createChartHierarchy());
        if (this.rootNode.getChildren().size() > 0) {
            this.plotTree.getSelectionModel().select(1);
        }
        LogviewerPresenter logviewerPresenter = this;
        Optional.ofNullable(logviewerPresenter.createInfoTable(logviewerPresenter.logContent.getInfo())).ifPresent(arg_0 -> this.infoTable.set(arg_0));
    }

    TableView<amo> createInfoTable(amo[] amoArray) {
        if (amoArray == null || amoArray.length == 0) {
            return null;
        }
        ObservableList observableList = FXCollections.observableArrayList((Object[])amoArray);
        TableView tableView = new TableView();
        Object[] objectArray = new TableColumn[7];
        objectArray[0] = this.createColumn("Index", arg_0 -> observableList.indexOf(arg_0));
        objectArray[1] = this.createCategory("Identifier", this.createColumn("Family", amo::getFamily), this.createColumn("Name", amo::getName), this.createColumn("Serial", amo2 -> amo2.a().f()));
        objectArray[2] = this.createCategory("Gains", this.createColumn("Strategy", amo2 -> amo2.a().a()));
        objectArray[3] = this.createCategory("Mechanical", this.createColumn("Type", amo2 -> amo2.a().u()), this.createColumn("Rev", amo2 -> amo2.a().v()));
        objectArray[4] = this.createCategory("Electrical", this.createColumn("Type", amo2 -> amo2.a().s()), this.createColumn("Rev", amo2 -> amo2.a().t()));
        objectArray[5] = this.createCategory("Firmware", this.createColumn("Type", amo2 -> amo2.a().getType()), this.createColumn("Rev", amo2 -> amo2.a().p()));
        objectArray[6] = this.createCategory("Network", this.createColumn("Mac", amo2 -> amo2.a().b()), this.createColumn("IP", amo2 -> amo2.a().b().getHostAddress()), this.createColumn("Subnet", amo2 -> amo2.a().c().getHostAddress()));
        tableView.getColumns().addAll(objectArray);
        tableView.setItems(observableList);
        bgt.c(tableView);
        tableView.setPrefSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return tableView;
    }

    private TableColumn<amo, String> createCategory(String string, TableColumn<amo, String> ... tableColumnArray) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.getColumns().setAll((Object[])tableColumnArray);
        return tableColumn;
    }

    private TableColumn<amo, String> createColumn(String string, Function<amo, Object> function) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setCellValueFactory(cellDataFeatures -> {
            String string = String.valueOf(function.apply((amo)cellDataFeatures.getValue()));
            return new SimpleStringProperty(string);
        });
        return tableColumn;
    }

    public static <T> TreeCell<NamedChart> createStyledCell(TreeView<NamedChart> treeView) {
        return new bhu();
    }
}

