/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2;

import impl.org.controlsfx.tableview2.FilteredColumnPredicate;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.controlsfx.control.tableview2.FilteredTableColumn;
import org.controlsfx.control.tableview2.TableView2;
import org.controlsfx.control.tableview2.event.FilterEvent;
import org.controlsfx.control.tableview2.filter.filtereditor.FilterEditor;
import org.controlsfx.control.tableview2.filter.filtereditor.SouthFilter;

public class FilteredTableView<S>
extends TableView2<S> {
    private ObservableList<S> backingList;
    public static final Callback<FilteredTableView, Boolean> DEFAULT_FILTER_POLICY = filteredTableView -> {
        try {
            Object object;
            ObservableList observableList = filteredTableView.getItems();
            FilteredList filteredList = null;
            if (observableList instanceof FilteredList) {
                filteredList = (FilteredList)observableList;
            } else if (observableList instanceof SortedList && (object = (SortedList)observableList).getSource() instanceof FilteredList) {
                filteredList = (FilteredList)object.getSource();
            }
            if (filteredList != null) {
                boolean bl2;
                if (filteredTableView.getBackingList() == null) {
                    filteredTableView.setBackingList(filteredList.getSource());
                }
                if (!(bl2 = filteredList.predicateProperty().isEqualTo(filteredTableView.predicateProperty()).get())) {
                    String string = "FilteredTableView items list is a FilteredList, but the FilteredList predicate should be bound to the FilteredTableView predicate for filtering to be enabled (e.g. filteredList.predicateProperty().bind(tableView.predicateProperty());).";
                    Logger.getLogger(FilteredTableView.class.getName()).log(Level.WARNING, string);
                }
                return bl2;
            }
            if (observableList == null || observableList.isEmpty()) {
                return true;
            }
            object = "FilteredTableView items list is not a FilteredList. Filtering options are not available unless the list is wrapped with a FilteredList. FilteredTableView.configureForFiltering(tableView, items); is called";
            Logger.getLogger(FilteredTableView.class.getName()).log(Level.WARNING, (String)object);
            FilteredTableView.configureForFiltering(filteredTableView, observableList);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    };
    private ReadOnlyObjectWrapper<Predicate<S>> predicate;
    private ObjectProperty<Callback<TableView<S>, Boolean>> filterPolicy;
    private ObjectProperty<EventHandler<FilterEvent<TableView<S>>>> onFilter;

    public FilteredTableView() {
    }

    public FilteredTableView(ObservableList<S> observableList) {
        super(observableList);
        this.backingList = observableList;
    }

    public static <S> void configureForFiltering(FilteredTableView<S> filteredTableView, ObservableList<S> observableList) {
        filteredTableView.setBackingList(observableList);
        FilteredList filteredList = new FilteredList(observableList);
        filteredList.predicateProperty().bind(filteredTableView.predicateProperty());
        SortedList sortedList = new SortedList((ObservableList)filteredList);
        sortedList.comparatorProperty().bind((ObservableValue)filteredTableView.comparatorProperty());
        filteredTableView.setItems((ObservableList)sortedList);
    }

    public void setBackingList(ObservableList<S> observableList) {
        this.backingList = observableList;
    }

    private void setPredicate(Predicate<S> predicate) {
        this.predicatePropertyImpl().set(predicate);
    }

    public final Predicate<S> getPredicate() {
        return this.predicate == null ? null : (Predicate)this.predicate.get();
    }

    public final ReadOnlyObjectProperty<Predicate<S>> predicateProperty() {
        return this.predicatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Predicate<S>> predicatePropertyImpl() {
        if (this.predicate == null) {
            this.predicate = new ReadOnlyObjectWrapper<Predicate<S>>((Object)this, "predicate"){

                protected void invalidated() {
                    if (this.get() == null) {
                        FilteredTableView.this.resetColumnsFilter();
                    }
                }
            };
        }
        return this.predicate;
    }

    public final void setFilterPolicy(Callback<TableView<S>, Boolean> callback) {
        this.filterPolicyProperty().set(callback);
    }

    public final Callback<TableView<S>, Boolean> getFilterPolicy() {
        return this.filterPolicy == null ? DEFAULT_FILTER_POLICY : (Callback)this.filterPolicy.get();
    }

    public final ObjectProperty<Callback<TableView<S>, Boolean>> filterPolicyProperty() {
        if (this.filterPolicy == null) {
            this.filterPolicy = new SimpleObjectProperty<Callback<TableView<S>, Boolean>>((Object)this, "filterPolicy", DEFAULT_FILTER_POLICY){

                protected void invalidated() {
                    FilteredTableView.this.filter();
                }
            };
        }
        return this.filterPolicy;
    }

    public final void setOnFilter(EventHandler<FilterEvent<TableView<S>>> eventHandler) {
        this.onFilterProperty().set(eventHandler);
    }

    public final EventHandler<FilterEvent<TableView<S>>> getOnFilter() {
        if (this.onFilter != null) {
            return (EventHandler)this.onFilter.get();
        }
        return null;
    }

    public final ObjectProperty<EventHandler<FilterEvent<TableView<S>>>> onFilterProperty() {
        if (this.onFilter == null) {
            this.onFilter = new ObjectPropertyBase<EventHandler<FilterEvent<TableView<S>>>>(){

                protected void invalidated() {
                    EventType eventType = FilterEvent.filterEvent();
                    EventHandler eventHandler = (EventHandler)this.get();
                    FilteredTableView.this.setEventHandler(eventType, eventHandler);
                }

                public Object getBean() {
                    return FilteredTableView.this;
                }

                public String getName() {
                    return "onFilter";
                }
            };
        }
        return this.onFilter;
    }

    public void resetFilter() {
        this.setPredicate(null);
        this.resetColumnsFilter();
    }

    public void filter() {
        Predicate<S> predicate = this.getPredicate();
        boolean bl2 = this.getVisibleLeafColumns().stream().filter(FilteredTableColumn.class::isInstance).map(FilteredTableColumn.class::cast).filter(FilteredTableColumn::isFilterable).noneMatch(filteredTableColumn -> filteredTableColumn.getPredicate() != null);
        this.setPredicate(bl2 ? null : new FilteredColumnPredicate((List<? extends TableColumnBase>)this.getVisibleLeafColumns()));
        FilterEvent<FilteredTableView> filterEvent = new FilterEvent<FilteredTableView>(this, (EventTarget)this);
        this.fireEvent(filterEvent);
        if (filterEvent.isConsumed()) {
            this.setPredicate(predicate);
            return;
        }
        Callback<TableView<S>, Boolean> callback = this.getFilterPolicy();
        if (callback == null) {
            return;
        }
        boolean bl3 = (Boolean)callback.call((Object)this);
        if (!bl3) {
            this.setPredicate(predicate);
        }
    }

    ObservableList<S> getBackingList() {
        return this.backingList;
    }

    private void resetColumnsFilter() {
        this.getVisibleLeafColumns().stream().filter(FilteredTableColumn.class::isInstance).map(FilteredTableColumn.class::cast).filter(FilteredTableColumn::isFilterable).peek(filteredTableColumn -> filteredTableColumn.setPredicate(null)).map(filteredTableColumn -> filteredTableColumn.getSouthNode()).filter(Objects::nonNull).filter(SouthFilter.class::isInstance).map(node -> ((SouthFilter)((Object)node)).getFilterEditor()).forEach(FilterEditor::cancelFilter);
    }
}

