/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javafx.event.ActionEvent;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.action.AnnotatedAction;
import org.controlsfx.control.action.AnnotatedActionFactory;
import org.controlsfx.control.action.DefaultActionFactory;

public class ActionMap {
    private static AnnotatedActionFactory actionFactory = new DefaultActionFactory();
    private static final Map<String, AnnotatedAction> actions = new HashMap<String, AnnotatedAction>();

    private ActionMap() {
    }

    public static AnnotatedActionFactory getActionFactory() {
        return actionFactory;
    }

    public static void setActionFactory(AnnotatedActionFactory annotatedActionFactory) {
        Objects.requireNonNull(annotatedActionFactory);
        actionFactory = annotatedActionFactory;
    }

    public static void register(Object object) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            Annotation[] annotationArray = method.getAnnotationsByType(ActionProxy.class);
            if (annotationArray.length == 0) continue;
            int n2 = method.getParameterCount();
            Class<?>[] classArray = method.getParameterTypes();
            if (n2 > 2) {
                throw new IllegalArgumentException(String.format("Method %s has too many parameters", method.getName()));
            }
            if (n2 == 1 && !ActionEvent.class.isAssignableFrom(classArray[0])) {
                throw new IllegalArgumentException(String.format("Method %s -- single parameter must be of type ActionEvent", method.getName()));
            }
            if (!(n2 != 2 || ActionEvent.class.isAssignableFrom(classArray[0]) && Action.class.isAssignableFrom(classArray[1]))) {
                throw new IllegalArgumentException(String.format("Method %s -- parameters must be of types (ActionEvent, Action)", method.getName()));
            }
            ActionProxy actionProxy = (ActionProxy)annotationArray[0];
            AnnotatedActionFactory annotatedActionFactory = ActionMap.determineActionFactory(actionProxy);
            AnnotatedAction annotatedAction = annotatedActionFactory.createAction(actionProxy, method, object);
            String string = actionProxy.id().isEmpty() ? method.getName() : actionProxy.id();
            actions.put(string, annotatedAction);
        }
    }

    private static AnnotatedActionFactory determineActionFactory(ActionProxy actionProxy) {
        AnnotatedActionFactory annotatedActionFactory = actionFactory;
        String string = actionProxy.factory();
        if (!string.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(string);
                annotatedActionFactory = (AnnotatedActionFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(String.format("Action proxy refers to non-existant factory class %s", string), classNotFoundException);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new IllegalStateException(String.format("Unable to instantiate action factory class %s", string), reflectiveOperationException);
            }
        }
        return annotatedActionFactory;
    }

    public static void unregister(Object object) {
        if (object != null) {
            Iterator<Map.Entry<String, AnnotatedAction>> iterator = actions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, AnnotatedAction> entry = iterator.next();
                Object object2 = entry.getValue().getTarget();
                if (object2 != null && object2 != object) continue;
                iterator.remove();
            }
        }
    }

    public static Action action(String string) {
        return actions.get(string);
    }

    public static Collection<Action> actions(String ... stringArray) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (String string : stringArray) {
            Action action;
            if (string.startsWith("---")) {
                arrayList.add(ActionUtils.ACTION_SEPARATOR);
            }
            if ((action = ActionMap.action(string)) == null) continue;
            arrayList.add(action);
        }
        return arrayList;
    }
}

