/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.broadcast;

import java.util.concurrent.atomic.AtomicLong;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.MemoryAccess;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.broadcast.RecordDescriptor;

public class BroadcastReceiver {
    private long cursor;
    private long nextRecord;
    private int recordOffset;
    private final int capacity;
    private final int tailIntentCounterIndex;
    private final int tailCounterIndex;
    private final int latestCounterIndex;
    private final AtomicBuffer buffer;
    private final AtomicLong lappedCount = new AtomicLong();

    public BroadcastReceiver(AtomicBuffer atomicBuffer) {
        this.buffer = atomicBuffer;
        this.capacity = atomicBuffer.capacity() - BroadcastBufferDescriptor.TRAILER_LENGTH;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        atomicBuffer.verifyAlignment();
        this.tailIntentCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_INTENT_COUNTER_OFFSET;
        this.tailCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_COUNTER_OFFSET;
        this.latestCounterIndex = this.capacity + BroadcastBufferDescriptor.LATEST_COUNTER_OFFSET;
        this.cursor = this.nextRecord = atomicBuffer.getLongVolatile(this.latestCounterIndex);
        this.recordOffset = (int)this.cursor & this.capacity - 1;
    }

    public int capacity() {
        return this.capacity;
    }

    public long lappedCount() {
        return this.lappedCount.get();
    }

    public int typeId() {
        return this.buffer.getInt(RecordDescriptor.typeOffset(this.recordOffset));
    }

    public int offset() {
        return RecordDescriptor.msgOffset(this.recordOffset);
    }

    public int length() {
        return this.buffer.getInt(RecordDescriptor.lengthOffset(this.recordOffset)) - 8;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public boolean receiveNext() {
        long l2;
        boolean bl2 = false;
        AtomicBuffer atomicBuffer = this.buffer;
        long l3 = atomicBuffer.getLongVolatile(this.tailCounterIndex);
        if (l3 > (l2 = this.nextRecord)) {
            int n2 = this.capacity;
            int n3 = (int)l2 & n2 - 1;
            if (!this.validate(l2, atomicBuffer, n2)) {
                this.lappedCount.lazySet(this.lappedCount.get() + 1L);
                l2 = atomicBuffer.getLongVolatile(this.latestCounterIndex);
                n3 = (int)l2 & n2 - 1;
            }
            this.cursor = l2;
            this.nextRecord = l2 + (long)BitUtil.align(atomicBuffer.getInt(RecordDescriptor.lengthOffset(n3)), 8);
            if (-1 == atomicBuffer.getInt(RecordDescriptor.typeOffset(n3))) {
                n3 = 0;
                this.cursor = this.nextRecord;
                this.nextRecord += (long)BitUtil.align(atomicBuffer.getInt(RecordDescriptor.lengthOffset(n3)), 8);
            }
            this.recordOffset = n3;
            bl2 = true;
        }
        return bl2;
    }

    public boolean validate() {
        MemoryAccess.acquireFence();
        return this.validate(this.cursor, this.buffer, this.capacity);
    }

    private boolean validate(long l2, AtomicBuffer atomicBuffer, int n2) {
        return l2 + (long)n2 > atomicBuffer.getLongVolatile(this.tailIntentCounterIndex);
    }
}

