/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import org.agrona.concurrent.AbstractSnowflakeIdGeneratorPaddingRhs;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdGenerator;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.hints.ThreadHints;

public final class SnowflakeIdGenerator
extends AbstractSnowflakeIdGeneratorPaddingRhs
implements IdGenerator {
    public static final int UNUSED_BITS = 1;
    public static final int EPOCH_BITS = 41;
    public static final int MAX_NODE_ID_AND_SEQUENCE_BITS = 22;
    public static final int NODE_ID_BITS_DEFAULT = 10;
    public static final int SEQUENCE_BITS_DEFAULT = 12;
    private final int nodeIdAndSequenceBits;
    private final int sequenceBits;
    private final long maxNodeId;
    private final long maxSequence;
    private final long nodeBits;
    private final long timestampOffsetMs;
    private final EpochClock clock;

    public SnowflakeIdGenerator(int n2, int n3, long l2, long l3, EpochClock epochClock) {
        if (n2 < 0) {
            throw new IllegalArgumentException("must be >= 0: nodeIdBits=" + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("must be >= 0: sequenceBits=" + n3);
        }
        int n4 = n2 + n3;
        if (n4 > 22) {
            throw new IllegalArgumentException("too many bits used: nodeIdBits=" + n2 + " + sequenceBits=" + n3 + " > 22");
        }
        long l4 = (long)(Math.pow(2.0, n2) - 1.0);
        if (l2 < 0L || l2 > l4) {
            throw new IllegalArgumentException("must be >= 0 && <= " + l4 + ": nodeId=" + l2);
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("must be >= 0: timestampOffsetMs=" + l3);
        }
        long l5 = epochClock.time();
        if (l3 > l5) {
            throw new IllegalArgumentException("timestampOffsetMs=" + l3 + " > nowMs=" + l5);
        }
        this.nodeIdAndSequenceBits = n4;
        this.maxNodeId = l4;
        this.sequenceBits = n3;
        this.maxSequence = (long)(Math.pow(2.0, n3) - 1.0);
        this.nodeBits = l2 << n3;
        this.timestampOffsetMs = l3;
        this.clock = epochClock;
    }

    public SnowflakeIdGenerator(long l2) {
        this(10, 12, l2, 0L, SystemEpochClock.INSTANCE);
    }

    public long nodeId() {
        return this.nodeBits >>> this.sequenceBits;
    }

    public long timestampOffsetMs() {
        return this.timestampOffsetMs;
    }

    public long maxNodeId() {
        return this.maxNodeId;
    }

    public long maxSequence() {
        return this.maxSequence;
    }

    @Override
    public long nextId() {
        while (true) {
            long l2;
            long l3 = this.timestampSequence;
            long l4 = this.clock.time() - this.timestampOffsetMs;
            if (l4 > (l2 = l3 >>> this.nodeIdAndSequenceBits)) {
                var7_4 = l4 << this.nodeIdAndSequenceBits;
                if (TIMESTAMP_SEQUENCE_UPDATER.compareAndSet(this, l3, var7_4)) {
                    return var7_4 | this.nodeBits;
                }
            } else {
                long l5;
                var7_4 = l3 & this.maxSequence;
                if (var7_4 < this.maxSequence && TIMESTAMP_SEQUENCE_UPDATER.compareAndSet(this, l3, l5 = l3 + 1L)) {
                    return l5 | this.nodeBits;
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new IllegalStateException("unexpected thread interrupt");
            }
            ThreadHints.onSpinWait();
        }
    }

    long extractTimestamp(long l2) {
        return l2 >>> this.nodeIdAndSequenceBits;
    }

    long extractNodeId(long l2) {
        return l2 >>> this.sequenceBits & this.maxNodeId;
    }

    long extractSequence(long l2) {
        return l2 & this.maxSequence;
    }
}

