/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongObjConsumer;
import org.agrona.collections.LongObjectToObjectFunction;

public class Long2ObjectCache<V>
implements Map<Long, V> {
    private long cachePuts = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private int size;
    private final int capacity;
    private final int setSize;
    private final int setSizeShift;
    private final int mask;
    private final long[] keys;
    private final Object[] values;
    private final Consumer<V> evictionConsumer;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Long2ObjectCache(int n2, int n3, Consumer<V> consumer) {
        CollectionUtil.validatePositivePowerOfTwo(n2);
        CollectionUtil.validatePositivePowerOfTwo(n3);
        Objects.requireNonNull(consumer, "null values are not permitted");
        if ((long)n2 * (long)n3 > 0x7FFFFFFFFFFFFFF7L) {
            throw new IllegalArgumentException("total capacity must be <= max array size: numSets=" + n2 + " setSize=" + n3);
        }
        this.setSize = n3;
        this.setSizeShift = Long.numberOfTrailingZeros(n3);
        this.capacity = n2 << this.setSizeShift;
        this.mask = n2 - 1;
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
        this.evictionConsumer = consumer;
    }

    public long cacheHits() {
        return this.cacheHits;
    }

    public long cacheMisses() {
        return this.cacheMisses;
    }

    public long cachePuts() {
        return this.cachePuts;
    }

    public void resetCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cachePuts = 0L;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((Long)object);
    }

    public boolean containsKey(long l2) {
        boolean bl2 = false;
        int n2 = Hashing.hash(l2, this.mask);
        int n3 = n2 << this.setSizeShift;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = n3 + this.setSize;
        for (int i2 = n3; i2 < n4 && null != objectArray[i2]; ++i2) {
            if (l2 != lArray[i2]) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl2 = false;
        if (null != object) {
            Object[] objectArray;
            for (Object object2 : objectArray = this.values) {
                if (!Objects.equals(object2, object)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    @Override
    public V get(Object object) {
        return this.get((Long)object);
    }

    public V get(long l2) {
        Object object;
        int n2 = Hashing.hash(l2, this.mask);
        int n3 = n2 << this.setSizeShift;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = n3 + this.setSize;
        for (int i2 = n3; i2 < n4 && null != (object = objectArray[i2]); ++i2) {
            if (l2 != lArray[i2]) continue;
            ++this.cacheHits;
            return (V)object;
        }
        ++this.cacheMisses;
        return null;
    }

    public V getOrDefault(long l2, V v2) {
        V v3 = this.get(l2);
        return null != v3 ? v3 : v2;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super V> biConsumer) {
        this.forEachLong(biConsumer::accept);
    }

    public void forEachLong(LongObjConsumer<? super V> longObjConsumer) {
        Objects.requireNonNull(longObjConsumer);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            longObjConsumer.accept(lArray[i2], object);
            --n3;
        }
    }

    @Override
    public V computeIfAbsent(Long l2, Function<? super Long, ? extends V> function) {
        return (V)this.computeIfAbsent((long)l2, function::apply);
    }

    public V computeIfAbsent(long l2, LongFunction<? extends V> longFunction) {
        Objects.requireNonNull(longFunction);
        V v2 = this.get(l2);
        if (null == v2 && null != (v2 = longFunction.apply(l2))) {
            this.put(l2, v2);
        }
        return v2;
    }

    @Override
    public V computeIfPresent(Long l2, BiFunction<? super Long, ? super V, ? extends V> biFunction) {
        return (V)this.computeIfPresent((long)l2, biFunction::apply);
    }

    public V computeIfPresent(long l2, LongObjectToObjectFunction<? super V, ? extends V> longObjectToObjectFunction) {
        Objects.requireNonNull(longObjectToObjectFunction);
        V v2 = this.get(l2);
        if (null != v2) {
            V v3 = longObjectToObjectFunction.apply(l2, v2);
            if (null != v3) {
                this.put(l2, v3);
                return v3;
            }
            this.remove(l2);
            return null;
        }
        return null;
    }

    @Override
    public V compute(Long l2, BiFunction<? super Long, ? super V, ? extends V> biFunction) {
        return (V)this.compute((long)l2, biFunction::apply);
    }

    public V compute(long l2, LongObjectToObjectFunction<? super V, ? extends V> longObjectToObjectFunction) {
        V v2 = this.get(l2);
        V v3 = longObjectToObjectFunction.apply(l2, v2);
        if (null != v3) {
            this.put(l2, v3);
            return v3;
        }
        if (null != v2) {
            this.remove(l2);
        }
        return null;
    }

    @Override
    public V merge(Long l2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        return this.merge((long)l2, v2, biFunction);
    }

    @Override
    public V merge(long l2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v3;
        Objects.requireNonNull(v2);
        Objects.requireNonNull(biFunction);
        V v4 = this.get(l2);
        V v5 = v3 = null == v4 ? v2 : biFunction.apply(v4, v2);
        if (null != v3) {
            this.put(l2, v3);
            return v3;
        }
        this.remove(l2);
        return null;
    }

    @Override
    public V putIfAbsent(Long l2, V v2) {
        return this.putIfAbsent((long)l2, v2);
    }

    @Override
    public V putIfAbsent(long l2, V v2) {
        V v3 = this.get(l2);
        if (null == v3) {
            this.put(l2, v2);
            return null;
        }
        return v3;
    }

    @Override
    public V put(Long l2, V v2) {
        return this.put((long)l2, v2);
    }

    @Override
    public V put(long l2, V v2) {
        int n2;
        Objects.requireNonNull(v2, "null values are not supported");
        int n3 = Hashing.hash(l2, this.mask);
        Object[] objectArray = this.values;
        long[] lArray = this.keys;
        Object object = null;
        int n4 = n2 + this.setSize;
        for (int i2 = n2 = n3 << this.setSizeShift; i2 < n4 && null != (object = objectArray[i2]); ++i2) {
            if (l2 != lArray[i2]) continue;
            this.shuffleUp(i2, n4 - 1);
            break;
        }
        if (null == object) {
            object = objectArray[n2 + (this.setSize - 1)];
        }
        this.shuffleDown(n2);
        lArray[n2] = l2;
        objectArray[n2] = v2;
        ++this.cachePuts;
        if (null != object) {
            this.evictionConsumer.accept(object);
        } else {
            ++this.size;
        }
        return null;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove((Long)object, object2);
    }

    public boolean remove(long l2, V v2) {
        V v3 = this.get(l2);
        if (null != v3 && Objects.equals(v3, v2)) {
            this.remove(l2);
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object object) {
        return this.remove((Long)object);
    }

    public V remove(long l2) {
        int n2 = Hashing.hash(l2, this.mask);
        int n3 = n2 << this.setSizeShift;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        Object object = null;
        int n4 = n3 + this.setSize;
        for (int i2 = n3; i2 < n4 && null != (object = objectArray[i2]); ++i2) {
            if (l2 != lArray[i2]) continue;
            this.shuffleUp(i2, n4 - 1);
            --this.size;
            this.evictionConsumer.accept(object);
            break;
        }
        return (V)object;
    }

    @Override
    public boolean replace(Long l2, V v2, V v3) {
        return this.replace((long)l2, v2, v3);
    }

    @Override
    public boolean replace(long l2, V v2, V v3) {
        V v4 = this.get(l2);
        if (null != v4 && Objects.equals(v4, v2)) {
            this.put(l2, v3);
            return true;
        }
        return false;
    }

    @Override
    public V replace(Long l2, V v2) {
        return this.replace((long)l2, v2);
    }

    @Override
    public V replace(long l2, V v2) {
        V v3 = this.get(l2);
        if (null != v3) {
            this.put(l2, v2);
        }
        return v3;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super V, ? extends V> biFunction) {
        this.replaceAllLong(biFunction::apply);
    }

    public void replaceAllLong(LongObjectToObjectFunction<? super V, ? extends V> longObjectToObjectFunction) {
        Objects.requireNonNull(longObjectToObjectFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            V v2 = longObjectToObjectFunction.apply(lArray[i2], object);
            Objects.requireNonNull(v2, "null values are not supported");
            objectArray[i2] = v2;
            --n3;
        }
    }

    private void shuffleUp(int n2, int n3) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = n2; i2 < n3; ++i2) {
            objectArray[i2] = objectArray[i2 + 1];
            lArray[i2] = lArray[i2 + 1];
        }
        objectArray[n3] = null;
    }

    private void shuffleDown(int n2) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = n2 + (this.setSize - 1); i2 > n2; --i2) {
            objectArray[i2] = objectArray[i2 - 1];
            lArray[i2] = lArray[i2 - 1];
        }
        objectArray[n2] = null;
    }

    @Override
    public void clear() {
        for (Object object : this.values) {
            if (null == object) continue;
            var1_1[var2_2] = null;
            --this.size;
            this.evictionConsumer.accept(object);
        }
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Long2ObjectCache<? extends V> long2ObjectCache) {
        EntryIterator entryIterator = long2ObjectCache.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.findNext();
            this.put(entryIterator.getLongKey(), (V)entryIterator.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            stringBuilder.append(lArray[i2]).append('=').append(object).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object v2;
            Object object2 = objectArray[i2];
            if (null == object2 || object2.equals(v2 = map.get(lArray[i2]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            n2 += Long.hashCode(lArray[i2]) ^ object.hashCode();
        }
        return n2;
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private final EntryIterator iterator;

        public EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        public EntryIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Cannot remove from EntrySet");
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<Long, V>> predicate) {
            throw new UnsupportedOperationException("Cannot remove from EntrySet");
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Long, V>>
    implements Map.Entry<Long, V> {
        @Override
        public Map.Entry<Long, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2ObjectCache.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Long2ObjectCache.this.values[this.position()];
        }

        @Override
        public V setValue(V v2) {
            throw new UnsupportedOperationException("no set on this iterator");
        }
    }

    public final class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Long2ObjectCache.this.containsKey(object);
        }

        public boolean contains(long l2) {
            return Long2ObjectCache.this.containsKey(l2);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Cannot remove from KeySet");
        }

        @Override
        public boolean removeIf(Predicate<? super Long> predicate) {
            throw new UnsupportedOperationException("Cannot remove from KeySet");
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Long2ObjectCache.this.containsValue(object);
        }

        public ValueIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Cannot remove from ValueCollection");
        }

        @Override
        public boolean removeIf(Predicate<? super V> predicate) {
            throw new UnsupportedOperationException("Cannot remove from ValueCollection");
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectCache.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Long2ObjectCache.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int remaining;
        private int position = -1;

        AbstractIterator() {
        }

        protected final int position() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            boolean bl2 = false;
            Object[] objectArray = Long2ObjectCache.this.values;
            int n2 = Long2ObjectCache.this.capacity;
            for (int i2 = this.position + 1; i2 < n2; ++i2) {
                if (null == objectArray[i2]) continue;
                bl2 = true;
                this.position = i2;
                --this.remaining;
                break;
            }
            if (!bl2) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on Iterator");
        }

        void reset() {
            this.remaining = Long2ObjectCache.this.size;
            this.position = -1;
        }
    }
}

