/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.matrix.MatrixD;

public class MatrixFactory {
    public static MatrixD constructWithCopy(double[][] dArray) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        MatrixD matrixD = new MatrixD(n2, n3);
        double[][] dArray2 = matrixD.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (dArray[i2].length != n3) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            System.arraycopy(dArray[i2], 0, dArray2[i2], 0, n3);
        }
        return matrixD;
    }

    public static MatrixD identity(int n2, int n3) {
        MatrixD matrixD = new MatrixD(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                matrixD.set(i2, i3, i2 == i3 ? 1.0 : 0.0);
            }
        }
        return matrixD;
    }

    public static MatrixD random(int n2, int n3) {
        MatrixD matrixD = new MatrixD(n2, n3);
        double[][] dArray = matrixD.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                dArray[i2][i3] = Math.random();
            }
        }
        return matrixD;
    }
}

