/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public class StyleBuilder<T extends StyleBuilder<T>> {
    private final HashMap<String, String> properties = new HashMap();
    private final StringBuilder builder = new StringBuilder();
    private static final Pattern PROPERTY_END_PATTERN = Pattern.compile(";");
    private static final Pattern STYLE_ASSIGNMENT_PATTERN = Pattern.compile("[=:]");

    public T reset() {
        this.properties.clear();
        return this.getThis();
    }

    public T withExisting(String string) {
        StyleBuilder.forEachProperty(string, this.properties::put);
        return this.getThis();
    }

    protected T setIntegerProp(String string, int n2) {
        this.properties.put(string, String.valueOf(n2));
        return this.getThis();
    }

    protected T setDoubleProp(String string, double d2) {
        this.properties.put(string, this.english(d2));
        return this.getThis();
    }

    protected T setDoubleArray(String string, double ... dArray) {
        return this.setStringProp(string, this.toDoubleArray(dArray));
    }

    protected String toDoubleArray(double[] dArray) {
        if (dArray.length == 0) {
            return "null";
        }
        this.builder.setLength(0);
        this.builder.append(dArray[0]);
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            this.builder.append(" ").append(this.english(dArray[i2]));
        }
        return this.builder.toString();
    }

    protected T setBooleanProp(String string, boolean bl2) {
        this.properties.put(string, String.valueOf(bl2));
        return this.getThis();
    }

    public T setStringProp(String string, String string2) {
        this.properties.put(string, string2);
        return this.getThis();
    }

    protected T setColorProp(String string, double d2, double d3, double d4, double d5) {
        return this.setColorProp(string, (int)Math.round(d2 * 255.0), (int)Math.round(d3 * 255.0), (int)Math.round(d4 * 255.0), d5);
    }

    protected T setColorProp(String string, int n2, int n3, int n4, double d2) {
        int n5 = (int)Math.round(d2 * 255.0);
        this.properties.put(string, String.format("#%02x%02x%02x%02x", n2 & 0xFF, n3 & 0xFF, n4 & 0xFF, n5 & 0xFF));
        return this.getThis();
    }

    public String build() {
        if (this.properties.isEmpty()) {
            return "";
        }
        this.builder.setLength(0);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(";\n");
        }
        if (this.builder.length() == 0) {
            return "";
        }
        if (this.builder.charAt(this.builder.length() - 1) == '\n') {
            this.builder.setLength(this.builder.length() - 1);
        }
        return this.builder.toString();
    }

    protected T getThis() {
        return (T)this;
    }

    public static int forEachProperty(String string, BiConsumer<String, String> biConsumer) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        int n2 = 0;
        for (String string2 : PROPERTY_END_PATTERN.split(string)) {
            String[] stringArray = STYLE_ASSIGNMENT_PATTERN.split(string2, 2);
            if (stringArray.length != 2) continue;
            String string3 = stringArray[0].trim();
            String string4 = stringArray[1].trim();
            if (string4.startsWith("\"") || string4.startsWith("'")) {
                string4 = string4.substring(1, string4.length() - 1);
            }
            biConsumer.accept(string3, string4);
            ++n2;
        }
        return n2;
    }

    private String english(double d2) {
        String string = String.valueOf(d2);
        if (string.contains(",")) {
            return string.replace(',', '.');
        }
        return string;
    }
}

