/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

public final class MathUtils {
    private MathUtils() {
    }

    public static boolean nearlyEqual(double d2, double d3) {
        return MathUtils.nearlyEqual(d2, d3, 1.0E-14);
    }

    public static boolean nearlyEqual(double d2, double d3, double d4) {
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        double d7 = Math.abs(d2 - d3);
        if (d2 == d3) {
            return true;
        }
        if (d2 == 0.0 || d3 == 0.0 || d5 + d6 < Double.MIN_NORMAL) {
            return d7 < d4 * Double.MIN_NORMAL;
        }
        return d7 / Math.min(d5 + d6, Double.MAX_VALUE) < d4;
    }

    public static boolean nearlyEqual(float f2, float f3) {
        return MathUtils.nearlyEqual(f2, f3, 1.0E-5f);
    }

    public static boolean nearlyEqual(float f2, float f3, float f4) {
        float f5 = Math.abs(f2);
        float f6 = Math.abs(f3);
        float f7 = Math.abs(f2 - f3);
        if (f2 == f3) {
            return true;
        }
        if (f2 == 0.0f || f3 == 0.0f || f5 + f6 < Float.MIN_NORMAL) {
            return f7 < f4 * Float.MIN_NORMAL;
        }
        return f7 / Math.min(f5 + f6, Float.MAX_VALUE) < f4;
    }

    public static double relativeEpsilon(double d2, double d3) {
        return Math.max(Math.ulp(d2), Math.ulp(d3));
    }

    public static float relativeEpsilon(float f2, float f3) {
        return Math.max(Math.ulp(f2), Math.ulp(f3));
    }

    public static double[] toDoubles(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    public static float[] toFloats(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
        return fArray;
    }
}

