/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.events;

import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.StateListener;
import java.util.Objects;
import java.util.function.IntSupplier;

public interface EventSource
extends StateListener {
    default public void addListener(StateListener stateListener) {
        Objects.requireNonNull(stateListener, "UpdateListener must not be null");
        this.getBitState().addChangeListener(stateListener);
        this.getBitState().getBits(stateListener);
    }

    default public void removeListener(StateListener stateListener) {
        Objects.requireNonNull(stateListener, "UpdateListener must not be null");
        this.getBitState().removeChangeListener(stateListener);
    }

    @Override
    default public void accept(BitState bitState, int n2) {
        this.getBitState().accept(bitState, n2);
    }

    default public void fireInvalidated(IntSupplier intSupplier) {
        this.getBitState().setDirty(intSupplier.getAsInt());
    }

    default public void fireInvalidated(IntSupplier intSupplier, IntSupplier intSupplier2) {
        this.getBitState().setDirty(intSupplier.getAsInt() | intSupplier2.getAsInt());
    }

    default public void fireInvalidated(IntSupplier intSupplier, IntSupplier intSupplier2, IntSupplier intSupplier3) {
        this.getBitState().setDirty(intSupplier.getAsInt() | intSupplier2.getAsInt() | intSupplier3.getAsInt());
    }

    default public void fireInvalidated(IntSupplier intSupplier, IntSupplier intSupplier2, IntSupplier intSupplier3, IntSupplier intSupplier4) {
        this.getBitState().setDirty(intSupplier.getAsInt() | intSupplier2.getAsInt() | intSupplier3.getAsInt() | intSupplier4.getAsInt());
    }

    public BitState getBitState();
}

