/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.marchingsquares;

import javafx.geometry.Side;

class Cell {
    private byte cellNdx;
    private final boolean flipped;
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    Cell(int n2, boolean bl2, float f2, float f3, float f4, float f5) {
        this.cellNdx = (byte)n2;
        this.flipped = bl2 && n2 != 5 && n2 != 10 ? false : bl2;
        this.left = f2;
        this.top = f3;
        this.right = f4;
        this.bottom = f5;
    }

    public void clear() {
        switch (this.cellNdx) {
            case 0: 
            case 5: 
            case 10: 
            case 15: {
                break;
            }
            default: {
                this.cellNdx = (byte)15;
            }
        }
    }

    public byte getCellNdx() {
        return this.cellNdx;
    }

    public float[] getXY(Side side) {
        switch (side) {
            case BOTTOM: {
                return new float[]{this.bottom, 0.0f};
            }
            case LEFT: {
                return new float[]{0.0f, this.left};
            }
            case RIGHT: {
                return new float[]{1.0f, this.right};
            }
            case TOP: {
                return new float[]{this.top, 1.0f};
            }
        }
        throw new IllegalStateException("getXY: N/A w/o a non-trivial edge");
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public boolean isSaddle() {
        return this.cellNdx == 5 || this.cellNdx == 10;
    }

    public boolean isTrivial() {
        return this.cellNdx == 0 || this.cellNdx == 15;
    }

    public String toString() {
        return "Cell{index=" + this.cellNdx + ", flipped? " + this.flipped + ", left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + "}";
    }
}

