/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.plugins.ChartPlugin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class ChartOverlay
extends ChartPlugin {
    private final ObjectProperty<Node> node = new SimpleObjectProperty((Object)this, "node");
    private final ObjectProperty<OverlayArea> overlayArea = new SimpleObjectProperty<OverlayArea>((Object)this, "overlayArea"){

        protected void invalidated() {
            ChartOverlay.this.layoutChildren();
        }
    };

    public ChartOverlay(OverlayArea overlayArea) {
        this(overlayArea, null);
    }

    public ChartOverlay(OverlayArea overlayArea, Node node) {
        this.setOverlayArea(overlayArea);
        this.nodeProperty().addListener((observableValue, node2, node3) -> {
            this.getChartChildren().remove(node2);
            if (node3 != null) {
                this.getChartChildren().add(node3);
                node.setManaged(false);
            }
            this.layoutChildren();
        });
        this.setNode(node);
    }

    public final Node getNode() {
        return (Node)this.nodeProperty().get();
    }

    public final OverlayArea getOverlayArea() {
        return (OverlayArea)((Object)this.overlayAreaProperty().get());
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null || this.getNode() == null) {
            return;
        }
        if (this.getOverlayArea() == OverlayArea.CHART_PANE) {
            this.getNode().resizeRelocate(0.0, 0.0, this.getChart().getWidth(), this.getChart().getHeight());
        } else {
            Bounds bounds = this.getChart().getBoundsInLocal();
            this.getNode().resizeRelocate(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        }
    }

    public final ObjectProperty<Node> nodeProperty() {
        return this.node;
    }

    public final ObjectProperty<OverlayArea> overlayAreaProperty() {
        return this.overlayArea;
    }

    public final void setNode(Node node) {
        this.nodeProperty().set((Object)node);
    }

    public final void setOverlayArea(OverlayArea overlayArea) {
        this.overlayAreaProperty().set((Object)overlayArea);
    }

    public static enum OverlayArea {
        CHART_PANE,
        PLOT_AREA;

    }
}

