/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.DebugChannelEndpointConfiguration;
import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class DebugReceiveChannelEndpoint
extends ReceiveChannelEndpoint {
    private final LossGenerator dataLossGenerator;
    private final LossGenerator controlLossGenerator;
    private final UnsafeBuffer controlBuffer = new UnsafeBuffer(ByteBuffer.allocate(0));

    public DebugReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dataPacketDispatcher, AtomicCounter atomicCounter, MediaDriver.Context context) {
        this(udpChannel, dataPacketDispatcher, atomicCounter, context, DebugChannelEndpointConfiguration.receiveDataLossGeneratorSupplier(), DebugChannelEndpointConfiguration.receiveControlLossGeneratorSupplier());
    }

    public DebugReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dataPacketDispatcher, AtomicCounter atomicCounter, MediaDriver.Context context, LossGenerator lossGenerator, LossGenerator lossGenerator2) {
        super(udpChannel, dataPacketDispatcher, atomicCounter, context);
        this.dataLossGenerator = lossGenerator;
        this.controlLossGenerator = lossGenerator2;
    }

    @Override
    public int sendTo(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        int n2 = byteBuffer.remaining();
        this.controlBuffer.wrap(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
        if (!this.controlLossGenerator.shouldDropFrame(inetSocketAddress, this.controlBuffer, byteBuffer.remaining())) {
            n2 = super.sendTo(byteBuffer, inetSocketAddress);
        }
        return n2;
    }

    @Override
    public int onDataPacket(DataHeaderFlyweight dataHeaderFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        int n4 = 0;
        if (!this.dataLossGenerator.shouldDropFrame(inetSocketAddress, unsafeBuffer, n2)) {
            n4 = super.onDataPacket(dataHeaderFlyweight, unsafeBuffer, n2, inetSocketAddress, n3);
        }
        return n4;
    }

    @Override
    public void onSetupMessage(SetupFlyweight setupFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        if (!this.dataLossGenerator.shouldDropFrame(inetSocketAddress, unsafeBuffer, setupFlyweight.frameLength())) {
            super.onSetupMessage(setupFlyweight, unsafeBuffer, n2, inetSocketAddress, n3);
        }
    }

    @Override
    public void onRttMeasurement(RttMeasurementFlyweight rttMeasurementFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        if (!this.dataLossGenerator.shouldDropFrame(inetSocketAddress, unsafeBuffer, rttMeasurementFlyweight.frameLength())) {
            super.onRttMeasurement(rttMeasurementFlyweight, unsafeBuffer, n2, inetSocketAddress, n3);
        }
    }
}

