/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.MutableDirectBuffer;

public class DestinationMessageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int REGISTRATION_CORRELATION_ID_OFFSET = 16;
    private static final int CHANNEL_OFFSET = 24;
    private static final int MINIMUM_LENGTH = 28;
    private int lengthOfChannel;

    @Override
    public DestinationMessageFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        super.wrap(mutableDirectBuffer, n2);
        return this;
    }

    public long registrationCorrelationId() {
        return this.buffer.getLong(this.offset + 16);
    }

    public DestinationMessageFlyweight registrationCorrelationId(long l2) {
        this.buffer.putLong(this.offset + 16, l2);
        return this;
    }

    public String channel() {
        return this.buffer.getStringAscii(this.offset + 24);
    }

    public void appendChannel(Appendable appendable) {
        this.buffer.getStringAscii(this.offset + 24, appendable);
    }

    public DestinationMessageFlyweight channel(String string) {
        this.lengthOfChannel = this.buffer.putStringAscii(this.offset + 24, string);
        return this;
    }

    public int length() {
        return 24 + this.lengthOfChannel;
    }

    @Override
    public void validateLength(int n2, int n3) {
        if (n3 < 28) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short: length=" + n3);
        }
        if (n3 - 28 < this.buffer.getInt(this.offset + 24)) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short for channel: length=" + n3);
        }
    }

    public static int computeLength(int n2) {
        return 28 + n2;
    }
}

