/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.controlsfx.control.SegmentedButton;

public class SegmentedButtonSkin
extends SkinBase<SegmentedButton> {
    private static final String ONLY_BUTTON = "only-button";
    private static final String LEFT_PILL = "left-pill";
    private static final String CENTER_PILL = "center-pill";
    private static final String RIGHT_PILL = "right-pill";
    private final HBox container = new HBox();

    public SegmentedButtonSkin(SegmentedButton segmentedButton) {
        super((Control)segmentedButton);
        this.getChildren().add((Object)this.container);
        this.updateButtons();
        this.getButtons().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SegmentedButtonSkin.this.updateButtons();
            }
        });
        segmentedButton.toggleGroupProperty().addListener((observableValue, toggleGroup, toggleGroup2) -> this.getButtons().forEach(toggleButton -> toggleButton.setToggleGroup(toggleGroup2)));
    }

    private ObservableList<ToggleButton> getButtons() {
        return ((SegmentedButton)this.getSkinnable()).getButtons();
    }

    private void updateButtons() {
        ObservableList<ToggleButton> observableList = this.getButtons();
        ToggleGroup toggleGroup = ((SegmentedButton)this.getSkinnable()).getToggleGroup();
        this.container.getChildren().clear();
        for (int i2 = 0; i2 < this.getButtons().size(); ++i2) {
            ToggleButton toggleButton = (ToggleButton)observableList.get(i2);
            if (toggleGroup != null) {
                toggleButton.setToggleGroup(toggleGroup);
            }
            toggleButton.getStyleClass().removeAll((Object[])new String[]{ONLY_BUTTON, LEFT_PILL, CENTER_PILL, RIGHT_PILL});
            this.container.getChildren().add((Object)toggleButton);
            if (i2 == observableList.size() - 1) {
                if (i2 == 0) {
                    toggleButton.getStyleClass().add((Object)ONLY_BUTTON);
                    continue;
                }
                toggleButton.getStyleClass().add((Object)RIGHT_PILL);
                continue;
            }
            if (i2 == 0) {
                toggleButton.getStyleClass().add((Object)LEFT_PILL);
                continue;
            }
            toggleButton.getStyleClass().add((Object)CENTER_PILL);
        }
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((SegmentedButton)this.getSkinnable()).prefWidth(d2);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((SegmentedButton)this.getSkinnable()).prefHeight(d2);
    }
}

