/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.lang.reflect.Field;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXTextFieldSkin<T extends TextField>
extends TextFieldSkin {
    private boolean invalid = true;
    private Text promptText;
    private Pane textPane = (Pane)this.getChildren().get(0);
    private Node textNode = (Node)ReflectionHelper.getFieldContent(TextFieldSkin.class, (Object)this, "textNode");
    private ObservableDoubleValue textRight;
    private DoubleProperty textTranslateX = (DoubleProperty)ReflectionHelper.getFieldContent(TextFieldSkin.class, (Object)this, "textTranslateX");
    private ValidationPane<T> errorContainer;
    private PromptLinesWrapper<T> linesWrapper;

    public JFXTextFieldSkin(T t2) {
        super(t2);
        this.textRight = (ObservableDoubleValue)ReflectionHelper.getFieldContent(TextFieldSkin.class, (Object)this, "textRight");
        this.linesWrapper = new PromptLinesWrapper<T>(t2, (ObjectProperty<Paint>)this.promptTextFillProperty(), (ObservableValue<?>)t2.textProperty(), (ObservableValue<String>)t2.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), new Node[]{this.textPane});
        ReflectionHelper.setFieldContent(TextFieldSkin.class, (Object)this, "usePromptText", this.linesWrapper.usePromptText);
        this.errorContainer = new ValidationPane<T>(t2);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener((ObservableValue)t2.disableProperty(), observableValue -> this.linesWrapper.updateDisabled());
        this.registerChangeListener((ObservableValue)((IFXLabelFloatControl)t2).focusColorProperty(), observableValue -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener((ObservableValue)((IFXLabelFloatControl)t2).unFocusColorProperty(), observableValue -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener((ObservableValue)((IFXStaticControl)t2).disableAnimationProperty(), observableValue -> this.errorContainer.updateClip());
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        double d6 = ((TextField)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(d2, d3, d4, d5, d6, Math.floor(d5));
        this.errorContainer.layoutPane(d2, d6 + this.linesWrapper.focusedLine.getHeight(), d4, d5);
        if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
            this.updateTextPos();
        }
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(d4);
            this.linesWrapper.invalid();
        }
    }

    private void updateTextPos() {
        double d2 = this.textNode.getLayoutBounds().getWidth();
        double d3 = this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getWidth();
        switch (((TextField)this.getSkinnable()).getAlignment().getHpos()) {
            case CENTER: {
                this.linesWrapper.promptTextScale.setPivotX(d3 / 2.0);
                double d4 = this.textRight.get() / 2.0;
                double d5 = d4 - d2 / 2.0;
                if (!(d5 + d2 <= this.textRight.get())) break;
                this.textTranslateX.set(d5);
                break;
            }
            case LEFT: {
                this.linesWrapper.promptTextScale.setPivotX(0.0);
                break;
            }
            case RIGHT: {
                this.linesWrapper.promptTextScale.setPivotX(d3);
            }
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextField)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextField)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextField)this.getSkinnable()).isFocused() && ((IFXLabelFloatControl)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.textPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            Field field = ReflectionHelper.getField(TextFieldSkin.class, "promptNode");
            Object object = field.get((Object)this);
            if (object != null) {
                this.textPane.getChildren().remove(object);
            }
            field.set((Object)this, this.promptText);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

