/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.events.JFXDialogEvent;
import com.jfoenix.converters.DialogTransitionConverter;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXDialog
extends StackPane {
    private StackPane contentHolder;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private StackPane dialogContainer;
    private Region content;
    private Transition animation;
    EventHandler<? super MouseEvent> closeHandler = mouseEvent -> this.close();
    private BooleanProperty overlayClose = new SimpleBooleanProperty(true);
    private BooleanProperty cacheContainer = new SimpleBooleanProperty(false);
    private ArrayList<Node> tempContent;
    private static final String DEFAULT_STYLE_CLASS = "jfx-dialog";
    private StyleableObjectProperty<DialogTransition> transitionType = new SimpleStyleableObjectProperty(StyleableProperties.access$300(), (Object)this, "dialogTransition", (Object)DialogTransition.CENTER);
    private final ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogClosedProperty = new ObjectPropertyBase<EventHandler<? super JFXDialogEvent>>(){

        protected void invalidated() {
            JFXDialog.this.setEventHandler(JFXDialogEvent.CLOSED, (EventHandler)this.get());
        }

        public Object getBean() {
            return JFXDialog.this;
        }

        public String getName() {
            return "onClosed";
        }
    };
    private ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogOpenedProperty = new ObjectPropertyBase<EventHandler<? super JFXDialogEvent>>(){

        protected void invalidated() {
            JFXDialog.this.setEventHandler(JFXDialogEvent.OPENED, (EventHandler)this.get());
        }

        public Object getBean() {
            return JFXDialog.this;
        }

        public String getName() {
            return "onOpened";
        }
    };

    public JFXDialog() {
        this(null, null, DialogTransition.CENTER);
    }

    public JFXDialog(StackPane stackPane, Region region, DialogTransition dialogTransition) {
        this.initialize();
        this.setContent(region);
        this.setDialogContainer(stackPane);
        this.transitionType.set((Object)dialogTransition);
        this.initChangeListeners();
    }

    public JFXDialog(StackPane stackPane, Region region, DialogTransition dialogTransition, boolean bl2) {
        this.setOverlayClose(bl2);
        this.initialize();
        this.setContent(region);
        this.setDialogContainer(stackPane);
        this.transitionType.set((Object)dialogTransition);
        this.initChangeListeners();
    }

    private void initChangeListeners() {
        this.overlayCloseProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.closeHandler);
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.closeHandler);
            }
        });
    }

    private void initialize() {
        this.setVisible(false);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.transitionType.addListener((observableValue, dialogTransition, dialogTransition2) -> {
            this.animation = this.getShowAnimation((DialogTransition)((Object)((Object)this.transitionType.get())));
        });
        this.contentHolder = new StackPane();
        this.contentHolder.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(2.0), null)}));
        JFXDepthManager.setDepth((Node)this.contentHolder, 4);
        this.contentHolder.setPickOnBounds(false);
        this.contentHolder.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.getChildren().add((Object)this.contentHolder);
        this.getStyleClass().add((Object)"jfx-dialog-overlay-pane");
        StackPane.setAlignment((Node)this.contentHolder, (Pos)Pos.CENTER);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.1), null, null)}));
        if (this.overlayClose.get()) {
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.closeHandler);
        }
        this.contentHolder.addEventHandler(MouseEvent.ANY, mouseEvent -> mouseEvent.consume());
    }

    public StackPane getDialogContainer() {
        return this.dialogContainer;
    }

    public void setDialogContainer(StackPane stackPane) {
        if (stackPane != null) {
            this.dialogContainer = stackPane;
            this.offsetX = stackPane.getBoundsInLocal().getWidth();
            this.offsetY = stackPane.getBoundsInLocal().getHeight();
            this.animation = this.getShowAnimation((DialogTransition)((Object)this.transitionType.get()));
        }
    }

    public Region getContent() {
        return this.content;
    }

    public void setContent(Region region) {
        if (region != null) {
            this.content = region;
            this.content.setPickOnBounds(false);
            this.contentHolder.getChildren().setAll((Object[])new Node[]{region});
        }
    }

    public final BooleanProperty overlayCloseProperty() {
        return this.overlayClose;
    }

    public final boolean isOverlayClose() {
        return this.overlayCloseProperty().get();
    }

    public final void setOverlayClose(boolean bl2) {
        this.overlayCloseProperty().set(bl2);
    }

    public boolean isCacheContainer() {
        return this.cacheContainer.get();
    }

    public BooleanProperty cacheContainerProperty() {
        return this.cacheContainer;
    }

    public void setCacheContainer(boolean bl2) {
        this.cacheContainer.set(bl2);
    }

    public void show(StackPane stackPane) {
        this.setDialogContainer(stackPane);
        this.showDialog();
    }

    public void show() {
        this.setDialogContainer(this.dialogContainer);
        this.showDialog();
    }

    private void showDialog() {
        if (this.dialogContainer == null) {
            throw new RuntimeException("ERROR: JFXDialog container is not set!");
        }
        if (this.isCacheContainer()) {
            this.tempContent = new ArrayList(this.dialogContainer.getChildren());
            SnapshotParameters snapshotParameters = new SnapshotParameters();
            snapshotParameters.setFill((Paint)Color.TRANSPARENT);
            WritableImage writableImage = this.dialogContainer.snapshot(snapshotParameters, new WritableImage((int)this.dialogContainer.getWidth(), (int)this.dialogContainer.getHeight()));
            ImageView imageView = new ImageView((Image)writableImage);
            imageView.setCache(true);
            imageView.setCacheHint(CacheHint.SPEED);
            this.dialogContainer.getChildren().setAll((Object[])new Node[]{imageView, this});
        } else {
            this.dialogContainer.getChildren().remove((Object)this);
            this.tempContent = null;
            this.dialogContainer.getChildren().add((Object)this);
        }
        if (this.animation != null) {
            this.animation.play();
        } else {
            this.setVisible(true);
            this.setOpacity(1.0);
            Event.fireEvent((EventTarget)this, (Event)new JFXDialogEvent(JFXDialogEvent.OPENED));
        }
    }

    public void close() {
        if (this.animation != null) {
            this.animation.setRate(-1.0);
            this.animation.play();
            this.animation.setOnFinished(actionEvent -> this.closeDialog());
        } else {
            this.setOpacity(0.0);
            this.setVisible(false);
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.resetProperties();
        Event.fireEvent((EventTarget)this, (Event)new JFXDialogEvent(JFXDialogEvent.CLOSED));
        if (this.tempContent == null) {
            this.dialogContainer.getChildren().remove((Object)this);
        } else {
            this.dialogContainer.getChildren().setAll(this.tempContent);
        }
    }

    private Transition getShowAnimation(DialogTransition dialogTransition) {
        CachedTransition cachedTransition = null;
        if (this.contentHolder != null) {
            switch (dialogTransition) {
                case LEFT: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateX(-this.offsetX);
                    cachedTransition = new LeftTransition();
                    break;
                }
                case RIGHT: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateX(this.offsetX);
                    cachedTransition = new RightTransition();
                    break;
                }
                case TOP: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateY(-this.offsetY);
                    cachedTransition = new TopTransition();
                    break;
                }
                case BOTTOM: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateY(this.offsetY);
                    cachedTransition = new BottomTransition();
                    break;
                }
                case CENTER: {
                    this.contentHolder.setScaleX(0.0);
                    this.contentHolder.setScaleY(0.0);
                    cachedTransition = new CenterTransition();
                    break;
                }
                default: {
                    cachedTransition = null;
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateX(0.0);
                    this.contentHolder.setTranslateY(0.0);
                }
            }
        }
        if (cachedTransition != null) {
            cachedTransition.setOnFinished(actionEvent -> Event.fireEvent((EventTarget)this, (Event)new JFXDialogEvent(JFXDialogEvent.OPENED)));
        }
        return cachedTransition;
    }

    private void resetProperties() {
        this.setVisible(false);
        this.contentHolder.setTranslateX(0.0);
        this.contentHolder.setTranslateY(0.0);
        this.contentHolder.setScaleX(1.0);
        this.contentHolder.setScaleY(1.0);
    }

    public DialogTransition getTransitionType() {
        return this.transitionType == null ? DialogTransition.CENTER : (DialogTransition)((Object)this.transitionType.get());
    }

    public StyleableObjectProperty<DialogTransition> transitionTypeProperty() {
        return this.transitionType;
    }

    public void setTransitionType(DialogTransition dialogTransition) {
        this.transitionType.set((Object)dialogTransition);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    public ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogClosedProperty() {
        return this.onDialogClosedProperty;
    }

    public void setOnDialogClosed(EventHandler<? super JFXDialogEvent> eventHandler) {
        this.onDialogClosedProperty().set(eventHandler);
    }

    public EventHandler<? super JFXDialogEvent> getOnDialogClosed() {
        return (EventHandler)this.onDialogClosedProperty().get();
    }

    public ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogOpenedProperty() {
        return this.onDialogOpenedProperty;
    }

    public void setOnDialogOpened(EventHandler<? super JFXDialogEvent> eventHandler) {
        this.onDialogOpenedProperty().set(eventHandler);
    }

    public EventHandler<? super JFXDialogEvent> getOnDialogOpened() {
        return (EventHandler)this.onDialogOpenedProperty().get();
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXDialog, DialogTransition> DIALOG_TRANSITION = new CssMetaData<JFXDialog, DialogTransition>("-jfx-dialog-transition", DialogTransitionConverter.getInstance(), DialogTransition.CENTER){

            public boolean isSettable(JFXDialog jFXDialog) {
                return jFXDialog.transitionType == null || !jFXDialog.transitionType.isBound();
            }

            public StyleableProperty<DialogTransition> getStyleableProperty(JFXDialog jFXDialog) {
                return jFXDialog.transitionTypeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$300() {
            return DIALOG_TRANSITION;
        }

        static {
            ArrayList arrayList = new ArrayList(StackPane.getClassCssMetaData());
            Collections.addAll(arrayList, DIALOG_TRANSITION);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private class CenterTransition
    extends CachedTransition {
        CenterTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class BottomTransition
    extends CachedTransition {
        BottomTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)JFXDialog.this.offsetY, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class TopTransition
    extends CachedTransition {
        TopTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)(-JFXDialog.this.offsetY), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class RightTransition
    extends CachedTransition {
        RightTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)JFXDialog.this.offsetX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class LeftTransition
    extends CachedTransition {
        LeftTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)(-JFXDialog.this.offsetX), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    public static enum DialogTransition {
        CENTER,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        NONE;

    }
}

