/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.pkce;

import com.github.scribejava.core.java8.Base64;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCECodeChallengeMethod;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PKCEService {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final int numberOFOctets;

    public PKCEService(int n2) {
        this.numberOFOctets = n2;
    }

    public PKCEService() {
        this(32);
    }

    public PKCE generatePKCE() {
        byte[] byArray = new byte[this.numberOFOctets];
        RANDOM.nextBytes(byArray);
        return this.generatePKCE(byArray);
    }

    public PKCE generatePKCE(byte[] byArray) {
        String string = BASE_64_ENCODER.encodeToString(byArray);
        PKCE pKCE = new PKCE();
        pKCE.setCodeVerifier(string);
        try {
            pKCE.setCodeChallenge(pKCE.getCodeChallengeMethod().transform2CodeChallenge(string));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            pKCE.setCodeChallengeMethod(PKCECodeChallengeMethod.plain);
            try {
                pKCE.setCodeChallenge(PKCECodeChallengeMethod.plain.transform2CodeChallenge(string));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new IllegalStateException("It's just cannot be", noSuchAlgorithmException2);
            }
        }
        return pKCE;
    }
}

