/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.RingProgressIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

public class RingProgressIndicatorSkin
extends SkinBase<RingProgressIndicator> {
    protected static final double DEFAULT_ANIMATION_TIME = 3.0;
    protected final StackPane container = new StackPane();
    protected final Circle trackCircle = new Circle();
    protected final Arc progressArc = new Arc();
    protected final Label progressLabel = new Label();
    protected final RotateTransition transition = new RotateTransition(Duration.seconds((double)3.0), (Node)this.progressArc);
    protected DoubleProperty indeterminateAnimationTime = null;

    public RingProgressIndicatorSkin(RingProgressIndicator ringProgressIndicator) {
        super((Control)ringProgressIndicator);
        this.trackCircle.getStyleClass().add((Object)"track");
        this.trackCircle.setManaged(false);
        this.trackCircle.setFill((Paint)Color.TRANSPARENT);
        this.progressArc.getStyleClass().add((Object)"ring");
        this.progressArc.setManaged(false);
        this.progressArc.setStartAngle(90.0);
        this.progressArc.setLength(this.calcProgressArcLength());
        this.progressArc.setCache(true);
        this.progressArc.setCacheHint(CacheHint.ROTATE);
        this.progressArc.setFill((Paint)Color.TRANSPARENT);
        this.transition.setAutoReverse(false);
        this.transition.setByAngle((double)(-this.getMaxAngle()));
        this.transition.setCycleCount(-1);
        this.transition.setDelay(Duration.ZERO);
        this.transition.setInterpolator(Interpolator.LINEAR);
        this.progressLabel.getStyleClass().add((Object)"progress");
        this.container.getStyleClass().addAll((Object[])new String[]{"container"});
        this.container.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.container.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.container.getChildren().addAll((Object[])new Node[]{this.trackCircle, this.progressArc});
        this.container.getChildren().add(ringProgressIndicator.getGraphic() != null ? ringProgressIndicator.getGraphic() : this.progressLabel);
        ringProgressIndicator.getStyleClass().add((Object)"ring-progress-indicator");
        ringProgressIndicator.setMaxHeight(Double.NEGATIVE_INFINITY);
        ringProgressIndicator.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.getChildren().add((Object)this.container);
        this.updateProgressLabel();
        this.toggleIndeterminate();
        this.registerChangeListener((ObservableValue)ringProgressIndicator.progressProperty(), observableValue -> {
            this.updateProgressLabel();
            this.progressArc.setLength(this.calcProgressArcLength());
        });
        this.registerChangeListener((ObservableValue)ringProgressIndicator.indeterminateProperty(), observableValue -> this.toggleIndeterminate());
        this.registerChangeListener((ObservableValue)ringProgressIndicator.visibleProperty(), observableValue -> {
            if (ringProgressIndicator.isVisible() && ringProgressIndicator.isIndeterminate()) {
                this.transition.play();
            } else {
                this.transition.pause();
            }
        });
        this.registerChangeListener((ObservableValue)this.indeterminateAnimationTimeProperty(), observableValue -> {
            this.transition.setDuration(Duration.seconds((double)this.getIndeterminateAnimationTime()));
            if (ringProgressIndicator.isIndeterminate()) {
                this.transition.playFromStart();
            }
        });
        this.registerChangeListener((ObservableValue)ringProgressIndicator.graphicProperty(), observableValue -> {
            if (ringProgressIndicator.getGraphic() != null) {
                this.container.getChildren().remove((Object)this.progressLabel);
                this.container.getChildren().add((Object)ringProgressIndicator.getGraphic());
            } else if (this.container.getChildren().size() > 1) {
                this.container.getChildren().remove(1);
                this.container.getChildren().add((Object)this.progressLabel);
                this.updateProgressLabel();
            }
        });
    }

    private int getMaxAngle() {
        return ((RingProgressIndicator)this.getSkinnable()).isReverse() ? 360 : -360;
    }

    private double calcProgressArcLength() {
        double d2 = ((RingProgressIndicator)this.getSkinnable()).getProgress();
        return ((RingProgressIndicator)this.getSkinnable()).isReverse() ? (1.0 - d2) * (double)this.getMaxAngle() : d2 * (double)this.getMaxAngle();
    }

    protected void updateProgressLabel() {
        double d2 = ((RingProgressIndicator)this.getSkinnable()).getProgress();
        if (((RingProgressIndicator)this.getSkinnable()).getStringConverter() != null) {
            this.progressLabel.setText(((RingProgressIndicator)this.getSkinnable()).getStringConverter().toString((Object)d2));
            return;
        }
        if (d2 >= 0.0) {
            this.progressLabel.setText((int)Math.ceil(d2 * 100.0) + "%");
        }
    }

    protected void toggleIndeterminate() {
        boolean bl2 = ((RingProgressIndicator)this.getSkinnable()).isIndeterminate();
        this.progressLabel.setManaged(!bl2);
        this.progressLabel.setVisible(!bl2);
        if (bl2) {
            if (((RingProgressIndicator)this.getSkinnable()).isVisible()) {
                this.transition.play();
            }
        } else {
            this.progressArc.setRotate(0.0);
            this.transition.stop();
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = Math.max(d4, d5);
        double d7 = d6 / 2.0 - this.progressArc.getStrokeWidth() / 2.0;
        this.trackCircle.setCenterX(d6 / 2.0);
        this.trackCircle.setCenterY(d6 / 2.0);
        this.trackCircle.setRadius(d7);
        this.progressArc.setCenterX(d6 / 2.0);
        this.progressArc.setCenterY(d6 / 2.0);
        this.progressArc.setRadiusX(d7);
        this.progressArc.setRadiusY(d7);
        this.container.resizeRelocate(d2, d3, d6, d6);
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computeMinWidth(0.0, d3, d4, d5, d6);
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(0.0, d3, d4, d5, d6);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computeMaxWidth(0.0, d3, d4, d5, d6);
    }

    public void dispose() {
        this.transition.stop();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RingProgressIndicatorSkin.getClassCssMetaData();
    }

    private DoubleProperty indeterminateAnimationTimeProperty() {
        if (this.indeterminateAnimationTime == null) {
            this.indeterminateAnimationTime = new StyleableDoubleProperty(3.0){

                public Object getBean() {
                    return RingProgressIndicatorSkin.this;
                }

                public String getName() {
                    return "indeterminateAnimationTime";
                }

                public CssMetaData<RingProgressIndicator, Number> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_ANIMATION_TIME;
                }
            };
        }
        return this.indeterminateAnimationTime;
    }

    public double getIndeterminateAnimationTime() {
        return this.indeterminateAnimationTime == null ? 3.0 : this.indeterminateAnimationTime.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<RingProgressIndicator, Number> INDETERMINATE_ANIMATION_TIME = new CssMetaData<RingProgressIndicator, Number>("-fx-indeterminate-animation-time", SizeConverter.getInstance(), (Number)3.0){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isSettable(RingProgressIndicator ringProgressIndicator) {
                Skin skin = ringProgressIndicator.getSkin();
                if (!(skin instanceof RingProgressIndicatorSkin)) return false;
                RingProgressIndicatorSkin ringProgressIndicatorSkin = (RingProgressIndicatorSkin)skin;
                if (ringProgressIndicatorSkin.indeterminateAnimationTime == null) return true;
                if (ringProgressIndicatorSkin.indeterminateAnimationTime.isBound()) return false;
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(RingProgressIndicator ringProgressIndicator) {
                RingProgressIndicatorSkin ringProgressIndicatorSkin = (RingProgressIndicatorSkin)ringProgressIndicator.getSkin();
                return (StyleableProperty)ringProgressIndicatorSkin.indeterminateAnimationTimeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<RingProgressIndicator, Number>> arrayList = new ArrayList<CssMetaData<RingProgressIndicator, Number>>(SkinBase.getClassCssMetaData());
            arrayList.add(INDETERMINATE_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

