/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineArray;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;

public class ImageLineHelper {
    static int[] DEPTH_UNPACK_1;
    static int[] DEPTH_UNPACK_2;
    static int[] DEPTH_UNPACK_4;
    static int[][] DEPTH_UNPACK;

    private static void initDepthScale() {
        int n2;
        DEPTH_UNPACK_1 = new int[2];
        for (n2 = 0; n2 < 2; ++n2) {
            ImageLineHelper.DEPTH_UNPACK_1[n2] = n2 * 255;
        }
        DEPTH_UNPACK_2 = new int[4];
        for (n2 = 0; n2 < 4; ++n2) {
            ImageLineHelper.DEPTH_UNPACK_2[n2] = n2 * 255 / 3;
        }
        DEPTH_UNPACK_4 = new int[16];
        for (n2 = 0; n2 < 16; ++n2) {
            ImageLineHelper.DEPTH_UNPACK_4[n2] = n2 * 255 / 15;
        }
        DEPTH_UNPACK = new int[][]{null, DEPTH_UNPACK_1, DEPTH_UNPACK_2, null, DEPTH_UNPACK_4};
    }

    public static void scaleUp(IImageLineArray iImageLineArray) {
        if (iImageLineArray.getImageInfo().indexed || iImageLineArray.getImageInfo().bitDepth >= 8) {
            return;
        }
        if (DEPTH_UNPACK_1 == null || DEPTH_UNPACK == null) {
            ImageLineHelper.initDepthScale();
        }
        int[] nArray = DEPTH_UNPACK[iImageLineArray.getImageInfo().bitDepth];
        if (iImageLineArray instanceof ImageLineInt) {
            ImageLineInt imageLineInt = (ImageLineInt)iImageLineArray;
            for (int i2 = 0; i2 < imageLineInt.getSize(); ++i2) {
                imageLineInt.scanline[i2] = nArray[imageLineInt.scanline[i2]];
            }
        } else if (iImageLineArray instanceof ImageLineByte) {
            ImageLineByte imageLineByte = (ImageLineByte)iImageLineArray;
            for (int i3 = 0; i3 < imageLineByte.getSize(); ++i3) {
                imageLineByte.scanline[i3] = (byte)nArray[imageLineByte.scanline[i3]];
            }
        } else {
            throw new PngjException("not implemented");
        }
    }

    public static void scaleDown(IImageLineArray iImageLineArray) {
        if (iImageLineArray.getImageInfo().indexed || iImageLineArray.getImageInfo().bitDepth >= 8) {
            return;
        }
        if (iImageLineArray instanceof ImageLineInt) {
            int n2 = 8 - iImageLineArray.getImageInfo().bitDepth;
            if (iImageLineArray instanceof ImageLineInt) {
                ImageLineInt imageLineInt = (ImageLineInt)iImageLineArray;
                for (int i2 = 0; i2 < iImageLineArray.getSize(); ++i2) {
                    imageLineInt.scanline[i2] = imageLineInt.scanline[i2] >> n2;
                }
            } else if (iImageLineArray instanceof ImageLineByte) {
                ImageLineByte imageLineByte = (ImageLineByte)iImageLineArray;
                for (int i3 = 0; i3 < iImageLineArray.getSize(); ++i3) {
                    imageLineByte.scanline[i3] = (byte)((imageLineByte.scanline[i3] & 0xFF) >> n2);
                }
            }
        } else {
            throw new PngjException("not implemented");
        }
    }

    public static byte scaleUp(int n2, byte by2) {
        return n2 < 8 ? (byte)DEPTH_UNPACK[n2][by2] : by2;
    }

    public static byte scaleDown(int n2, byte by2) {
        return n2 < 8 ? (byte)(by2 >> 8 - n2) : by2;
    }

    public static int[] palette2rgb(ImageLineInt imageLineInt, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLineInt, pngChunkPLTE, pngChunkTRNS, nArray, false);
    }

    static int[] lineToARGB32(ImageLineByte imageLineByte, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        boolean bl2 = imageLineByte.imgInfo.alpha;
        int n2 = imageLineByte.getImageInfo().cols;
        if (nArray == null || nArray.length < n2) {
            nArray = new int[n2];
        }
        if (imageLineByte.getImageInfo().indexed) {
            int n3 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = imageLineByte.scanline[i2] & 0xFF;
                int n5 = pngChunkPLTE.getEntry(n4);
                int n6 = n4 < n3 ? pngChunkTRNS.getPalletteAlpha()[n4] : 255;
                nArray[i2] = n6 << 24 | n5;
            }
        } else if (imageLineByte.imgInfo.greyscale) {
            int n7 = pngChunkTRNS != null ? pngChunkTRNS.getGray() : -1;
            int n8 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n9 = imageLineByte.scanline[n8++] & 0xFF;
                int n10 = bl2 ? imageLineByte.scanline[n8++] & 0xFF : (n9 != n7 ? 255 : 0);
                nArray[i3] = n10 << 24 | n9 | n9 << 8 | n9 << 16;
            }
        } else {
            int n11 = pngChunkTRNS != null ? pngChunkTRNS.getRGB888() : -1;
            int n12 = 0;
            for (int i4 = 0; i4 < n2; ++i4) {
                int n13 = (imageLineByte.scanline[n12++] & 0xFF) << 16 | (imageLineByte.scanline[n12++] & 0xFF) << 8 | imageLineByte.scanline[n12++] & 0xFF;
                int n14 = bl2 ? imageLineByte.scanline[n12++] & 0xFF : (n13 != n11 ? 255 : 0);
                nArray[i4] = n14 << 24 | n13;
            }
        }
        return nArray;
    }

    static byte[] lineToRGBA8888(ImageLineByte imageLineByte, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, byte[] byArray) {
        boolean bl2 = imageLineByte.imgInfo.alpha;
        int n2 = imageLineByte.imgInfo.cols;
        int n3 = n2 * 4;
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        if (imageLineByte.imgInfo.indexed) {
            int n4 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
            int n5 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n6 = imageLineByte.scanline[i2] & 0xFF;
                int n7 = pngChunkPLTE.getEntry(n6);
                byArray[n5++] = (byte)(n7 >> 16 & 0xFF);
                byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
                byArray[n5++] = (byte)(n7 & 0xFF);
                byArray[n5++] = (byte)(n6 < n4 ? pngChunkTRNS.getPalletteAlpha()[n6] : 255);
            }
        } else if (imageLineByte.imgInfo.greyscale) {
            int n8 = pngChunkTRNS != null ? pngChunkTRNS.getGray() : -1;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byte by2 = imageLineByte.scanline[n9++];
                byArray[n10++] = by2;
                byArray[n10++] = by2;
                byArray[n10++] = by2;
                byArray[n10++] = bl2 ? imageLineByte.scanline[n9++] : ((by2 & 0xFF) == n8 ? 0 : -1);
            }
        } else if (bl2) {
            System.arraycopy(imageLineByte.scanline, 0, byArray, 0, n3);
        } else {
            int n11 = 0;
            int n12 = 0;
            while (n12 < n3) {
                byArray[n12++] = imageLineByte.scanline[n11++];
                byArray[n12++] = imageLineByte.scanline[n11++];
                byArray[n12++] = imageLineByte.scanline[n11++];
                byArray[n12++] = -1;
                if (pngChunkTRNS == null || byArray[n12 - 3] != (byte)pngChunkTRNS.getRGB()[0] || byArray[n12 - 2] != (byte)pngChunkTRNS.getRGB()[1] || byArray[n12 - 1] != (byte)pngChunkTRNS.getRGB()[2]) continue;
                byArray[n12 - 1] = 0;
            }
        }
        return byArray;
    }

    static byte[] lineToRGB888(ImageLineByte imageLineByte, PngChunkPLTE pngChunkPLTE, byte[] byArray) {
        boolean bl2 = imageLineByte.imgInfo.alpha;
        int n2 = imageLineByte.imgInfo.cols;
        int n3 = n2 * 3;
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        int[] nArray = new int[3];
        if (imageLineByte.imgInfo.indexed) {
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                pngChunkPLTE.getEntryRgb(imageLineByte.scanline[i2] & 0xFF, nArray);
                byArray[n4++] = (byte)nArray[0];
                byArray[n4++] = (byte)nArray[1];
                byArray[n4++] = (byte)nArray[2];
            }
        } else if (imageLineByte.imgInfo.greyscale) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                byte by2 = imageLineByte.scanline[n5++];
                byArray[n6++] = by2;
                byArray[n6++] = by2;
                byArray[n6++] = by2;
                if (!bl2) continue;
                ++n5;
            }
        } else if (!bl2) {
            System.arraycopy(imageLineByte.scanline, 0, byArray, 0, n3);
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                byArray[n8++] = imageLineByte.scanline[n7++];
                byArray[n8++] = imageLineByte.scanline[n7++];
                byArray[n8++] = imageLineByte.scanline[n7++];
                ++n7;
            }
        }
        return byArray;
    }

    public static int[] palette2rgba(ImageLineInt imageLineInt, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLineInt, pngChunkPLTE, pngChunkTRNS, nArray, true);
    }

    public static int[] palette2rgb(ImageLineInt imageLineInt, PngChunkPLTE pngChunkPLTE, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLineInt, pngChunkPLTE, null, nArray, false);
    }

    private static int[] palette2rgb(IImageLine iImageLine, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray, boolean bl2) {
        boolean bl3 = pngChunkTRNS != null;
        int n2 = bl3 ? 4 : 3;
        ImageLineInt imageLineInt = (ImageLineInt)(iImageLine instanceof ImageLineInt ? iImageLine : null);
        ImageLineByte imageLineByte = (ImageLineByte)(iImageLine instanceof ImageLineByte ? iImageLine : null);
        boolean bl4 = imageLineByte != null;
        int n3 = imageLineInt != null ? imageLineInt.imgInfo.cols : imageLineByte.imgInfo.cols;
        int n4 = n3 * n2;
        if (nArray == null || nArray.length < n4) {
            nArray = new int[n4];
        }
        int n5 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6;
            int n7 = bl4 ? imageLineByte.scanline[i2] & 0xFF : imageLineInt.scanline[i2];
            pngChunkPLTE.getEntryRgb(n7, nArray, i2 * n2);
            if (!bl3) continue;
            nArray[i2 * n2 + 3] = n6 = n7 < n5 ? pngChunkTRNS.getPalletteAlpha()[n7] : 255;
        }
        return nArray;
    }

    public static String infoFirstLastPixels(ImageLineInt imageLineInt) {
        return imageLineInt.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", imageLineInt.scanline[0], imageLineInt.scanline[imageLineInt.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", imageLineInt.scanline[0], imageLineInt.scanline[1], imageLineInt.scanline[2], imageLineInt.scanline[imageLineInt.scanline.length - imageLineInt.imgInfo.channels], imageLineInt.scanline[imageLineInt.scanline.length - imageLineInt.imgInfo.channels + 1], imageLineInt.scanline[imageLineInt.scanline.length - imageLineInt.imgInfo.channels + 2]);
    }

    public static int getPixelRGB8(IImageLine iImageLine, int n2) {
        if (iImageLine instanceof ImageLineInt) {
            int n3 = n2 * ((ImageLineInt)iImageLine).imgInfo.channels;
            int[] nArray = ((ImageLineInt)iImageLine).getScanline();
            return nArray[n3] << 16 | nArray[n3 + 1] << 8 | nArray[n3 + 2];
        }
        if (iImageLine instanceof ImageLineByte) {
            int n4 = n2 * ((ImageLineByte)iImageLine).imgInfo.channels;
            byte[] byArray = ((ImageLineByte)iImageLine).getScanline();
            return (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
        }
        throw new PngjException("Not supported " + iImageLine.getClass());
    }

    public static int getPixelARGB8(IImageLine iImageLine, int n2) {
        if (iImageLine instanceof ImageLineInt) {
            int n3 = n2 * ((ImageLineInt)iImageLine).imgInfo.channels;
            int[] nArray = ((ImageLineInt)iImageLine).getScanline();
            return nArray[n3 + 3] << 24 | nArray[n3] << 16 | nArray[n3 + 1] << 8 | nArray[n3 + 2];
        }
        if (iImageLine instanceof ImageLineByte) {
            int n4 = n2 * ((ImageLineByte)iImageLine).imgInfo.channels;
            byte[] byArray = ((ImageLineByte)iImageLine).getScanline();
            return (byArray[n4 + 3] & 0xFF) << 24 | (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
        }
        throw new PngjException("Not supported " + iImageLine.getClass());
    }

    public static void setPixelsRGB8(ImageLineInt imageLineInt, int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < imageLineInt.imgInfo.cols; ++i2) {
            imageLineInt.scanline[n2++] = nArray[i2] >> 16 & 0xFF;
            imageLineInt.scanline[n2++] = nArray[i2] >> 8 & 0xFF;
            imageLineInt.scanline[n2++] = nArray[i2] & 0xFF;
        }
    }

    public static void setPixelRGB8(ImageLineInt imageLineInt, int n2, int n3, int n4, int n5) {
        n2 *= imageLineInt.imgInfo.channels;
        imageLineInt.scanline[n2++] = n3;
        imageLineInt.scanline[n2++] = n4;
        imageLineInt.scanline[n2] = n5;
    }

    public static void setPixelRGB8(ImageLineInt imageLineInt, int n2, int n3) {
        ImageLineHelper.setPixelRGB8(imageLineInt, n2, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
    }

    public static void setPixelsRGBA8(ImageLineInt imageLineInt, int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < imageLineInt.imgInfo.cols; ++i2) {
            imageLineInt.scanline[n2++] = nArray[i2] >> 16 & 0xFF;
            imageLineInt.scanline[n2++] = nArray[i2] >> 8 & 0xFF;
            imageLineInt.scanline[n2++] = nArray[i2] & 0xFF;
            imageLineInt.scanline[n2++] = nArray[i2] >> 24 & 0xFF;
        }
    }

    public static void setPixelRGBA8(ImageLineInt imageLineInt, int n2, int n3, int n4, int n5, int n6) {
        n2 *= imageLineInt.imgInfo.channels;
        imageLineInt.scanline[n2++] = n3;
        imageLineInt.scanline[n2++] = n4;
        imageLineInt.scanline[n2++] = n5;
        imageLineInt.scanline[n2] = n6;
    }

    public static void setPixelRGBA8(ImageLineInt imageLineInt, int n2, int n3) {
        ImageLineHelper.setPixelRGBA8(imageLineInt, n2, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF, n3 >> 24 & 0xFF);
    }

    public static void setValD(ImageLineInt imageLineInt, int n2, double d2) {
        imageLineInt.scanline[n2] = ImageLineHelper.double2int(imageLineInt, d2);
    }

    public static int interpol(int n2, int n3, int n4, int n5, double d2, double d3) {
        double d4 = (double)n2 * (1.0 - d2) + (double)n3 * d2;
        double d5 = (double)n4 * (1.0 - d2) + (double)n5 * d2;
        return (int)(d4 * (1.0 - d3) + d5 * d3 + 0.5);
    }

    public static double int2double(ImageLineInt imageLineInt, int n2) {
        return imageLineInt.imgInfo.bitDepth == 16 ? (double)n2 / 65535.0 : (double)n2 / 255.0;
    }

    public static double int2doubleClamped(ImageLineInt imageLineInt, int n2) {
        double d2;
        double d3 = d2 = imageLineInt.imgInfo.bitDepth == 16 ? (double)n2 / 65535.0 : (double)n2 / 255.0;
        return d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
    }

    public static int double2int(ImageLineInt imageLineInt, double d2) {
        d2 = d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
        return imageLineInt.imgInfo.bitDepth == 16 ? (int)(d2 * 65535.0 + 0.5) : (int)(d2 * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLineInt imageLineInt, double d2) {
        d2 = d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
        return imageLineInt.imgInfo.bitDepth == 16 ? (int)(d2 * 65535.0 + 0.5) : (int)(d2 * 255.0 + 0.5);
    }

    public static int clampTo_0_255(int n2) {
        return n2 > 255 ? 255 : (n2 < 0 ? 0 : n2);
    }

    public static int clampTo_0_65535(int n2) {
        return n2 > 65535 ? 65535 : (n2 < 0 ? 0 : n2);
    }

    public static int clampTo_128_127(int n2) {
        return n2 > 127 ? 127 : (n2 < -128 ? -128 : n2);
    }

    static int getMaskForPackedFormats(int n2) {
        if (n2 == 4) {
            return 240;
        }
        if (n2 == 2) {
            return 192;
        }
        return 128;
    }

    static int getMaskForPackedFormatsLs(int n2) {
        if (n2 == 4) {
            return 15;
        }
        if (n2 == 2) {
            return 3;
        }
        return 1;
    }
}

