/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.chunks.ChunkRaw;

public abstract class ChunkReader {
    public final ChunkReaderMode mode;
    private final ChunkRaw chunkRaw;
    private boolean crcCheck;
    protected int read = 0;
    private int crcn = 0;

    public ChunkReader(int n2, String string, long l2, ChunkReaderMode chunkReaderMode) {
        if (chunkReaderMode == null || string.length() != 4 || n2 < 0) {
            throw new PngjExceptionInternal("Bad chunk paramenters: " + (Object)((Object)chunkReaderMode));
        }
        this.mode = chunkReaderMode;
        this.chunkRaw = new ChunkRaw(n2, string, chunkReaderMode == ChunkReaderMode.BUFFER);
        this.chunkRaw.setOffset(l2);
        this.crcCheck = chunkReaderMode != ChunkReaderMode.SKIP;
    }

    public ChunkRaw getChunkRaw() {
        return this.chunkRaw;
    }

    public final int feedBytes(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        if (n3 < 0) {
            throw new PngjException("negative length??");
        }
        if (this.read == 0 && this.crcn == 0 && this.crcCheck) {
            this.chunkRaw.updateCrc(this.chunkRaw.idbytes, 0, 4);
        }
        if ((n4 = this.chunkRaw.len - this.read) > n3) {
            n4 = n3;
        }
        if (n4 > 0 || this.crcn == 0) {
            if (this.crcCheck && this.mode != ChunkReaderMode.BUFFER && n4 > 0) {
                this.chunkRaw.updateCrc(byArray, n2, n4);
            }
            if (this.mode == ChunkReaderMode.BUFFER) {
                if (this.chunkRaw.data != byArray && n4 > 0) {
                    System.arraycopy(byArray, n2, this.chunkRaw.data, this.read, n4);
                }
            } else if (this.mode == ChunkReaderMode.PROCESS) {
                this.processData(this.read, byArray, n2, n4);
            }
            this.read += n4;
            n2 += n4;
            n3 -= n4;
        }
        int n5 = 0;
        if (this.read == this.chunkRaw.len) {
            n5 = 4 - this.crcn;
            if (n5 > n3) {
                n5 = n3;
            }
            if (n5 > 0) {
                if (byArray != this.chunkRaw.crcval) {
                    System.arraycopy(byArray, n2, this.chunkRaw.crcval, this.crcn, n5);
                }
                this.crcn += n5;
                if (this.crcn == 4) {
                    if (this.crcCheck) {
                        if (this.mode == ChunkReaderMode.BUFFER) {
                            this.chunkRaw.updateCrc(this.chunkRaw.data, 0, this.chunkRaw.len);
                        }
                        this.chunkRaw.checkCrc();
                    }
                    this.chunkDone();
                }
            }
        }
        return n4 + n5;
    }

    public final boolean isDone() {
        return this.crcn == 4;
    }

    public void setCrcCheck(boolean bl2) {
        if (this.read != 0 && bl2 && !this.crcCheck) {
            throw new PngjException("too late!");
        }
        this.crcCheck = bl2;
    }

    protected abstract void processData(int var1, byte[] var2, int var3, int var4);

    protected abstract void chunkDone();

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.chunkRaw == null ? 0 : this.chunkRaw.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChunkReader chunkReader = (ChunkReader)object;
        return !(this.chunkRaw == null ? chunkReader.chunkRaw != null : !this.chunkRaw.equals(chunkReader.chunkRaw));
    }

    public String toString() {
        return this.chunkRaw.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChunkReaderMode {
        BUFFER,
        PROCESS,
        SKIP;

    }
}

