/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import java.util.Collections;
import java.util.List;
import us.hebi.gui.lib.bdh;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bjb;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.views.teachrepeat.state.UpdatableGroupTrajectory;
import us.hebi.gui.views.teachrepeat.state.UpdatableGroupTrajectory$GroupTrajectoryState;
import us.hebi.gui.views.teachrepeat.state.Waypoint;

public abstract class WaypointDataSet
extends bdh<WaypointDataSet>
implements EditableDataSet {
    final int jointIndex;
    private List<Waypoint> waypoints = Collections.emptyList();
    private UpdatableGroupTrajectory trajectory;

    protected boolean setX(Waypoint waypoint, double d2) {
        if (waypoint.getTime() != d2) {
            waypoint.setTime(d2);
            return true;
        }
        return false;
    }

    protected abstract boolean setY(Waypoint var1, double var2);

    protected abstract double getY(UpdatableGroupTrajectory$GroupTrajectoryState var1);

    protected abstract double getY(Waypoint var1);

    protected WaypointDataSet(int n2) {
        super("joint " + (n2 + 1));
        this.jointIndex = n2;
        this.addStyleClasses(new String[]{bek.c.D()});
        this.setEditConstraints(new bjb(this));
    }

    @Override
    public EditableDataSet add(int n2, double ... dArray) {
        throw new AssertionError((Object)"not implemented");
    }

    @Override
    public EditableDataSet remove(int n2) {
        return this.set(n2, ((bdh)this).getX(n2), Double.NaN);
    }

    @Override
    public EditableDataSet set(int n2, double ... dArray) {
        if (n2 < 0) {
            return (EditableDataSet)this.getThis();
        }
        double d2 = dArray[0];
        double d3 = dArray[1];
        Waypoint waypoint = this.waypoints.get(n2);
        boolean bl2 = this.setX(waypoint, d2);
        boolean bl3 = this.setY(waypoint, d3);
        if (bl2 || bl3) {
            this.postWaypointUpdate(waypoint);
            this.fireInvalidated(ChartBits.DataSetData);
        }
        return (EditableDataSet)this.getThis();
    }

    protected void postWaypointUpdate(Waypoint waypoint) {
    }

    @Override
    public double getX(int n2) {
        return this.waypoints.get((int)n2).time;
    }

    public boolean isFree(int n2) {
        WaypointDataSet waypointDataSet = this;
        return Double.isNaN(waypointDataSet.getY(waypointDataSet.waypoints.get(n2)));
    }

    @Override
    public double getY(int n2) {
        WaypointDataSet waypointDataSet = this;
        double d2 = waypointDataSet.getY(waypointDataSet.waypoints.get(n2));
        if (Double.isNaN(d2) && this.trajectory != null && this.trajectory.isValid()) {
            WaypointDataSet waypointDataSet2 = this;
            d2 = waypointDataSet2.getY(waypointDataSet2.trajectory.getState(((bdh)this).getX(n2)));
        }
        return d2;
    }

    @Override
    public int getDataCount() {
        return this.waypoints.size();
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new AssertionError((Object)"not implemented");
    }

    public void setWaypoints(List<Waypoint> list, UpdatableGroupTrajectory updatableGroupTrajectory) {
        this.waypoints = bpd.b(list);
        this.trajectory = updatableGroupTrajectory;
        this.fireInvalidated(ChartBits.DataSetData);
    }
}

