/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HBlock;
import us.hebi.gui.controls.HBlockSection;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.lib.afp;
import us.hebi.gui.lib.afq;
import us.hebi.gui.lib.afr;
import us.hebi.gui.lib.ais;
import us.hebi.gui.lib.amk;
import us.hebi.gui.lib.aml;
import us.hebi.gui.lib.axn;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.bbh;
import us.hebi.gui.lib.bgh;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.views.scope.components.ParseUtils;

public class PidController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private HBlock block;
    @FXML
    private HDoubleInputField kp;
    @FXML
    private HDoubleInputField ki;
    @FXML
    private HDoubleInputField kd;
    @FXML
    private HDoubleInputField ff;
    @FXML
    private HDoubleInputField deadZone;
    @FXML
    private HDoubleInputField iClamp;
    @FXML
    private HDoubleInputField punch;
    @FXML
    private HBlockSection targetSection;
    @FXML
    private HDoubleInputField targetMin;
    @FXML
    private HDoubleInputField targetMax;
    @FXML
    private HDoubleInputField targetLp;
    @FXML
    private HBlockSection outputSection;
    @FXML
    private HDoubleInputField outMin;
    @FXML
    private HDoubleInputField outMax;
    @FXML
    private HDoubleInputField outLp;
    @FXML
    private HBlockSection variousSection;
    @FXML
    private HDoubleInputField dOnError;
    private List<Node> advancedNodes = new ArrayList<Node>();
    @Inject
    bbh module;
    private afq category;
    private ReadOnlyBooleanProperty advancedView;

    private static String uppercaseFirstLetter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public void initialize(afq afq2, ReadOnlyBooleanProperty readOnlyBooleanProperty, ValidationSupport validationSupport, ValidationSupport validationSupport2) {
        this.block.setTitle(PidController.uppercaseFirstLetter(afq2.name()));
        this.category = afq2;
        this.advancedView = readOnlyBooleanProperty;
        CustomTextField customTextField = this.getControl(afr.n).getTextInput();
        bgt.a(customTextField.visibleProperty(), Boolean.FALSE);
        bgt.a(customTextField.disableProperty(), Boolean.TRUE);
        this.setAdvanced(new Node[]{this.punch, this.targetSection, this.outputSection, this.variousSection});
        switch (afq2) {
            case a: {
                this.setAdvanced(new Node[]{this.ff});
                break;
            }
            case b: {
                this.setAdvanced(new Node[]{this.kd, this.ki, this.iClamp});
            }
        }
        for (afr afr2 : afr.values()) {
            this.setupControl(afr2, validationSupport, validationSupport2);
        }
        this.advancedNodes.clear();
    }

    private void setAdvanced(Node ... nodeArray) {
        Node[] nodeArray2 = nodeArray;
        int n2 = nodeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeArray2[i2];
            bgt.a(node, (ObservableBooleanValue)this.advancedView);
            this.advancedNodes.add(node);
        }
    }

    public void addGainsToMessage(amk amk2) {
        for (afr afr2 : afr.values()) {
            this.getControl(afr2);
            CustomTextField customTextField = this.getControl(afr2).getTextInput();
            Double d2 = afr2.ad ? ParseUtils.tryParseNonNanDouble(customTextField) : ParseUtils.tryParseFiniteDouble(customTextField);
            if (d2 == null) continue;
            afp.a(amk2, this.category, afr2, d2);
        }
    }

    public void setTextFields(aml aml2) {
        for (afr afr2 : afr.values()) {
            CustomTextField customTextField = this.getControl(afr2).getTextInput();
            double d2 = afp.a(aml2, this.category, afr2);
            if (Double.isNaN(d2)) {
                customTextField.setText("");
                continue;
            }
            customTextField.setText(ais.b(d2));
        }
    }

    public void clearAllTextFields() {
        for (afr afr2 : afr.values()) {
            this.getControl(afr2).getTextInput().setText("");
        }
    }

    private void setupControl(afr afr2, ValidationSupport validationSupport, ValidationSupport validationSupport2) {
        HDoubleInputField hDoubleInputField = this.getControl(afr2);
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.getProperty(afr2);
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        boolean bl2 = afr2 == afr.c;
        hDoubleInputField.setFormat(bl2 ? "#0.000##" : "#0.###");
        Validator<String> validator = afr2.ad ? ParseUtils.NON_NAN_DOUBLE_VALIDATOR : ParseUtils.FINITE_DOUBLE_VALIDATOR;
        hDoubleInputField.setAllowInf(afr2.ad);
        Validator<String> validator2 = bgh.a(hDoubleInputField.getTextInput(), validator, readOnlyDoubleProperty, bl2 ? 1.0E-5 : 0.001);
        (this.advancedNodes.contains((Object)hDoubleInputField) ? validationSupport2 : validationSupport).registerValidator((Control)hDoubleInputField.getTextInput(), false, validator2);
    }

    private ReadOnlyDoubleProperty getProperty(afr afr2) {
        Object object = this.module.getInfo();
        axn axn2 = ((axs)object).a;
        switch (this.category) {
            case a: {
                switch (afr2) {
                    case a: {
                        axn axn3 = axn2;
                        return axn3.aZ;
                    }
                    case b: {
                        axn axn4 = axn2;
                        return axn4.aY;
                    }
                    case c: {
                        axn axn5 = axn2;
                        return axn5.aX;
                    }
                    case d: {
                        axn axn6 = axn2;
                        return axn6.aV;
                    }
                    case e: {
                        axn axn7 = axn2;
                        return axn7.aU;
                    }
                    case f: {
                        axn axn8 = axn2;
                        return axn8.aW;
                    }
                    case g: {
                        axn axn9 = axn2;
                        return axn9.bf;
                    }
                    case h: {
                        object = axn2;
                        return ((axn)object).bd;
                    }
                    case i: {
                        object = axn2;
                        return ((axn)object).bb;
                    }
                    case j: {
                        axn axn10 = axn2;
                        return axn10.bg;
                    }
                    case k: {
                        axn axn11 = axn2;
                        return axn11.bc;
                    }
                    case l: {
                        axn axn12 = axn2;
                        return axn12.ba;
                    }
                    case m: {
                        axn axn13 = axn2;
                        return axn13.be;
                    }
                    case n: {
                        axn axn14 = axn2;
                        return axn14.aT;
                    }
                }
            }
            case b: {
                switch (afr2) {
                    case a: {
                        axn axn15 = axn2;
                        return axn15.bn;
                    }
                    case b: {
                        axn axn16 = axn2;
                        return axn16.bm;
                    }
                    case c: {
                        axn axn17 = axn2;
                        return axn17.bl;
                    }
                    case d: {
                        axn axn18 = axn2;
                        return axn18.bj;
                    }
                    case e: {
                        axn axn19 = axn2;
                        return axn19.bi;
                    }
                    case f: {
                        axn axn20 = axn2;
                        return axn20.bk;
                    }
                    case g: {
                        axn axn21 = axn2;
                        return axn21.bt;
                    }
                    case h: {
                        object = axn2;
                        return ((axn)object).br;
                    }
                    case i: {
                        object = axn2;
                        return ((axn)object).bp;
                    }
                    case j: {
                        axn axn22 = axn2;
                        return axn22.bu;
                    }
                    case k: {
                        axn axn23 = axn2;
                        return axn23.bq;
                    }
                    case l: {
                        axn axn24 = axn2;
                        return axn24.bo;
                    }
                    case m: {
                        axn axn25 = axn2;
                        return axn25.bs;
                    }
                    case n: {
                        axn axn26 = axn2;
                        return axn26.bh;
                    }
                }
            }
            case c: {
                switch (afr2) {
                    case a: {
                        axn axn27 = axn2;
                        return axn27.aL;
                    }
                    case b: {
                        axn axn28 = axn2;
                        return axn28.aK;
                    }
                    case c: {
                        axn axn29 = axn2;
                        return axn29.aJ;
                    }
                    case d: {
                        axn axn30 = axn2;
                        return axn30.aH;
                    }
                    case e: {
                        axn axn31 = axn2;
                        return axn31.aG;
                    }
                    case f: {
                        axn axn32 = axn2;
                        return axn32.aI;
                    }
                    case g: {
                        axn axn33 = axn2;
                        return axn33.aR;
                    }
                    case h: {
                        object = axn2;
                        return ((axn)object).aP;
                    }
                    case i: {
                        object = axn2;
                        return ((axn)object).aN;
                    }
                    case j: {
                        axn axn34 = axn2;
                        return axn34.aS;
                    }
                    case k: {
                        axn axn35 = axn2;
                        return axn35.aO;
                    }
                    case l: {
                        axn axn36 = axn2;
                        return axn36.aM;
                    }
                    case m: {
                        axn axn37 = axn2;
                        return axn37.aQ;
                    }
                    case n: {
                        axn axn38 = axn2;
                        return axn38.aF;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown property: " + String.valueOf((Object)this.category) + " > " + String.valueOf((Object)afr2));
    }

    private HDoubleInputField getControl(afr afr2) {
        switch (afr2) {
            case a: {
                return this.kp;
            }
            case b: {
                return this.ki;
            }
            case c: {
                return this.kd;
            }
            case d: {
                return this.ff;
            }
            case e: {
                return this.deadZone;
            }
            case f: {
                return this.iClamp;
            }
            case g: {
                return this.punch;
            }
            case h: {
                return this.targetMin;
            }
            case i: {
                return this.targetMax;
            }
            case j: {
                return this.targetLp;
            }
            case k: {
                return this.outMin;
            }
            case l: {
                return this.outMax;
            }
            case m: {
                return this.outLp;
            }
            case n: {
                return this.dOnError;
            }
        }
        throw new IllegalStateException("Unknown field: " + String.valueOf((Object)afr2));
    }
}

