/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import io.fair_acc.chartfx.utils.PropUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.xml.transform.sax.SAXSource;
import lombok.Generated;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.ahb;
import us.hebi.gui.lib.ahh;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.aid;
import us.hebi.gui.lib.aif;
import us.hebi.gui.lib.aja;
import us.hebi.gui.lib.anl;
import us.hebi.gui.lib.anm;
import us.hebi.gui.lib.ann;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.anp;
import us.hebi.gui.lib.anq;
import us.hebi.gui.lib.anr;
import us.hebi.gui.lib.ans;
import us.hebi.gui.lib.ant;
import us.hebi.gui.lib.anu;
import us.hebi.gui.lib.anv;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.atn;
import us.hebi.gui.lib.auj;
import us.hebi.gui.lib.avv;
import us.hebi.gui.lib.axf;
import us.hebi.gui.lib.axg;
import us.hebi.gui.lib.axh;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.axm;
import us.hebi.gui.lib.axo;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.axz;
import us.hebi.gui.lib.ayd;
import us.hebi.gui.lib.ayh;
import us.hebi.gui.lib.azt;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bbc;
import us.hebi.gui.lib.bbh;
import us.hebi.gui.lib.bbv;
import us.hebi.gui.lib.bcf;
import us.hebi.gui.lib.bge;
import us.hebi.gui.lib.bgh;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.views.scope.components.EncoderConfigController;
import us.hebi.gui.views.scope.components.MotorDriverCommand;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.dialogs.calibrate.AdcCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.MotorEncoderCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.motordriver.SaveMotorDriverXmlDialog;

public class MotorDriverController
extends bge {
    @FXML
    private Button calibrateAdcBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private ToggleButton showAdvancedToggle;
    @FXML
    private ToggleButton showEncoderToggle;
    @FXML
    private HEnumInputField<ans> controlMode;
    @FXML
    private HEnumInputField<ano> outputEncoder;
    @FXML
    private HEnumInputField<ano> deflectionEncoder;
    @FXML
    private HEnumInputField<ano> motorEncoder;
    @FXML
    private Pane encoderA1;
    @FXML
    private EncoderConfigController encoderA1Controller;
    @FXML
    private Pane encoderA2;
    @FXML
    private EncoderConfigController encoderA2Controller;
    @FXML
    private Pane encoderB1;
    @FXML
    private EncoderConfigController encoderB1Controller;
    @FXML
    private Pane encoderB2;
    @FXML
    private EncoderConfigController encoderB2Controller;
    @FXML
    private Pane encoderHalls;
    @FXML
    private EncoderConfigController encoderHallsController;
    @FXML
    private HEnumInputField<anv> windingOrder;
    @FXML
    private HEnumInputField<anr> hallOrder;
    @FXML
    private HEnumInputField<anq> hallOffset;
    @FXML
    private VBox focContainer;
    @FXML
    private HDoubleInputField focIdIClamp;
    @FXML
    private HDoubleInputField focIdKi;
    @FXML
    private HDoubleInputField focIdKp;
    @FXML
    private HDoubleInputField focIqIClamp;
    @FXML
    private HDoubleInputField focIqKi;
    @FXML
    private HDoubleInputField focIqKp;
    @FXML
    private HDoubleInputField gearEfficiency;
    @FXML
    private HDoubleInputField maxOutputTorque;
    @FXML
    private HDoubleInputField gearRatioNumerator;
    @FXML
    private HDoubleInputField gearRatioDenominator;
    @FXML
    private HDoubleInputField calibOffsetIa;
    @FXML
    private HDoubleInputField calibOffsetIb;
    @FXML
    private HDoubleInputField calibOffsetIc;
    @FXML
    private HDoubleInputField calibOffsetIBus;
    @FXML
    private HDoubleInputField calibOffsetVa;
    @FXML
    private HDoubleInputField calibOffsetVb;
    @FXML
    private HDoubleInputField calibOffsetVc;
    @FXML
    private HDoubleInputField housingThermalResistance;
    @FXML
    private HDoubleInputField housingThermalTimeConstant;
    @FXML
    private HDoubleInputField thermalModelStartPercentage;
    @FXML
    private HDoubleInputField slewRateVoltage;
    @FXML
    private HDoubleInputField slewRateCurrent;
    @FXML
    private HDoubleInputField motorElectricalPowerLimit;
    @FXML
    private HDoubleInputField motorMechanicalPowerLimit;
    @FXML
    private Button loadFileBtn;
    @FXML
    private HDoubleInputField maxBoardCurrent;
    @FXML
    private HDoubleInputField maxDutyCycle;
    @FXML
    private HDoubleInputField maxMotorSpeed;
    @FXML
    private HDoubleInputField minDutyCycle;
    @FXML
    private HDoubleInputField switchingFreq;
    @FXML
    private HDoubleInputField controlDivider;
    @FXML
    private HDoubleInputField currentSenseThresholdVds;
    @FXML
    private HDoubleInputField currentSenseThresholdWinding;
    @FXML
    private HDoubleInputField currentFilterSize;
    @FXML
    private HDoubleInputField currentSenseGain;
    @FXML
    private HEnumInputField<anu> torqueSource;
    @FXML
    private HEnumInputField<ant> temperatureSource;
    @FXML
    private HDoubleInputField temperatureSourceUserValue;
    @FXML
    private HDoubleInputField polePairs;
    @FXML
    private Button resetBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private HDoubleInputField speedConstant;
    @FXML
    private HDoubleInputField torqueConstant;
    @FXML
    private HDoubleInputField windingInductance;
    @FXML
    private HDoubleInputField windingMaxCurrent;
    @FXML
    private HDoubleInputField windingMaxTemp;
    @FXML
    private HDoubleInputField motorTorqueTempConstant;
    @FXML
    private HDoubleInputField motorVelocityTempConstant;
    @FXML
    private HDoubleInputField motorRotorInertia;
    @FXML
    private HDoubleInputField windingResistance;
    @FXML
    private HDoubleInputField windingThermalResistance;
    @FXML
    private HDoubleInputField windingThermalTimeConstant;
    @FXML
    private Button suggestFocGainsButton;
    @FXML
    private Button calibrateMotorEncoderBtn;
    List<Runnable> addInputList = new ArrayList<Runnable>();
    List<Runnable> onClear = new ArrayList<Runnable>();
    ValidationSupport validation;
    @Inject
    ayh properties;
    @Inject
    bat commandService;
    @Inject
    bbh device;
    @Inject
    bbc selector;
    @Inject
    bcf fileChooser;
    @Inject
    azz notificationService;
    @Inject
    SaveMotorDriverXmlDialog saveMotorDriverXmlDialog;
    @Inject
    MotorEncoderCalibrationDialog motorEncoderCalibrationDialog;
    @Inject
    AdcCalibrationDialog adcCalibrationDialog;
    @Inject
    azt dialogService;

    @Override
    public void initializeFx() {
        this.validation = bgh.a();
        MotorDriverCommand motorDriverCommand = new MotorDriverCommand();
        this.setupInputFields(motorDriverCommand);
        BooleanBinding booleanBinding = this.selector.selectionSingle().not();
        this.clearBtn.setOnAction(actionEvent -> this.onClear.forEach(Runnable::run));
        avv.a((Node)this.sendBtn, bgh.b(this.validation));
        this.sendBtn.disableProperty().bind((ObservableValue)booleanBinding.or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.sendBtn.setOnAction(actionEvent -> {
            ((aqt)motorDriverCommand).clear();
            this.addInputList.forEach(Runnable::run);
            if (this.persistToggle.isSelected()) {
                motorDriverCommand.setPersistAllFlag();
            }
            this.commandService.a(this.selector.getSelectedAddresses(), motorDriverCommand);
        });
        this.resetBtn.disableProperty().bind((ObservableValue)this.selector.selectionEmpty());
        this.resetBtn.setOnAction(actionEvent -> {
            ((aqt)motorDriverCommand).clear();
            this.commandService.a(this.selector.getSelectedAddresses(), motorDriverCommand.setResetFlag());
        });
        avv.a((Node)this.resetBtn, new ObservableBooleanValue[]{this.device.needsResetProperty()});
        this.persistToggle.selectedProperty().bindBidirectional((Property)this.properties.g);
        this.showAdvancedToggle.selectedProperty().bindBidirectional((Property)this.properties.h);
        this.saveFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.loadFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.saveFileBtn.setOnAction(this::saveToFile);
        this.loadFileBtn.setOnAction(this::loadFromFile);
    }

    void saveToFile(ActionEvent actionEvent) {
        this.saveMotorDriverXmlDialog.setContent(aib.fromInfo(this.device.getInfo()));
        this.dialogService.a(this.saveMotorDriverXmlDialog);
    }

    void loadFromFile(ActionEvent actionEvent) {
        Window window = bgt.a(actionEvent);
        bcf bcf2 = this.fileChooser;
        bcf2.a(bcf2.c, "lastDriverConfigChoiceDirectory");
        bcf bcf3 = bcf2;
        File file = bcf3.b(bcf3.c.showOpenDialog(window), "lastDriverConfigChoiceDirectory");
        if (file == null) {
            return;
        }
        try {
            SAXSource sAXSource = aja.getSourceWithIncludes(file);
            aib aib2 = (aib)new ahb().readXml(sAXSource);
            this.setFieldsFromXml(aib2);
            return;
        }
        catch (Exception exception) {
            this.notificationService.f(exception);
            return;
        }
    }

    private void setFieldsFromXml(aib aib2) {
        ahh ahh2;
        aif aif2;
        aid aid2 = aib2.getMotor();
        if (aid2 != null) {
            this.polePairs.setTextNullable(aid2.getPolePairs());
            this.speedConstant.setTextNullable(aid2.getSpeedConstant());
            this.torqueConstant.setTextNullable(aid2.getTorqueConstant());
            this.maxMotorSpeed.setTextNullable(aid2.getMaxMotorSpeed());
            this.windingResistance.setTextNullable(aid2.getWindingResistance());
            this.windingInductance.setTextNullable(aid2.getWindingInductance());
            this.windingMaxCurrent.setTextNullable(aid2.getMaxWindingCurrent());
            this.windingMaxTemp.setTextNullable(aid2.getMaxWindingTemperature());
            this.motorTorqueTempConstant.setTextNullable(aid2.getTorqueTempConstant());
            this.motorVelocityTempConstant.setTextNullable(aid2.getVelocityTempConstant());
            this.motorRotorInertia.setTextNullable(aid2.getRotorInertia());
        }
        if ((aif2 = aib2.getThermalModel()) != null) {
            this.windingThermalResistance.setTextNullable(aif2.getWindingThermalResistance());
            this.windingThermalTimeConstant.setTextNullable(aif2.getWindingThermalTimeConst());
            this.housingThermalResistance.setTextNullable(aif2.getHousingThermalResistance());
            this.housingThermalTimeConstant.setTextNullable(aif2.getHousingThermalTimeConst());
            Optional.ofNullable(aif2.getTemperatureSource()).map(ant::a).ifPresent(this.temperatureSource::setValue);
            this.temperatureSourceUserValue.setTextNullable(aif2.getUserValue());
            this.thermalModelStartPercentage.setTextNullable(aif2.getModelStartPercentage());
        }
        if ((ahh2 = aib2.getController()) != null) {
            Optional.ofNullable(ahh2.getIqGains()).ifPresent(ahx2 -> {
                this.focIqKp.setTextNullable(ahx2.getK());
                this.focIqKi.setTextNullable(ahx2.getKi());
                this.focIqIClamp.setTextNullable(ahx2.getIClamp());
            });
            Optional.ofNullable(ahh2.getIdGains()).ifPresent(ahx2 -> {
                this.focIdKp.setTextNullable(ahx2.getK());
                this.focIdKi.setTextNullable(ahx2.getKi());
                this.focIdIClamp.setTextNullable(ahx2.getIClamp());
            });
            this.slewRateCurrent.setTextNullable(ahh2.getSlewRateCurrent());
            this.slewRateVoltage.setTextNullable(ahh2.getSlewRateVoltage());
            this.motorElectricalPowerLimit.setTextNullable(ahh2.getMotorElectricalPowerLimit());
            this.motorMechanicalPowerLimit.setTextNullable(ahh2.getMotorMechanicalPowerLimit());
        }
        Optional.ofNullable(aib2.getEncoders()).ifPresent(ahl2 -> {
            Optional.ofNullable(ahl2.getMotorEncoderPort()).map(ano::a).ifPresent(this.motorEncoder::setValue);
            Optional.ofNullable(ahl2.getOutputEncoderPort()).map(ano::a).ifPresent(this.outputEncoder::setValue);
            Optional.ofNullable(ahl2.getDeflectionEncoderPort()).map(ano::a).ifPresent(this.deflectionEncoder::setValue);
            Optional.ofNullable(ahl2.getTorqueSource()).map(anu::a).ifPresent(this.torqueSource::setValue);
            Optional.ofNullable(ahl2.getHallSwitches()).ifPresent(this.encoderHallsController::setFromXml);
            Optional.ofNullable(ahl2.getEncoderA1()).ifPresent(this.encoderA1Controller::setFromXml);
            Optional.ofNullable(ahl2.getEncoderA2()).ifPresent(this.encoderA2Controller::setFromXml);
            Optional.ofNullable(ahl2.getEncoderB1()).ifPresent(this.encoderB1Controller::setFromXml);
            Optional.ofNullable(ahl2.getEncoderB2()).ifPresent(this.encoderB2Controller::setFromXml);
        });
        Optional.ofNullable(aib2.getBoard()).ifPresent(ahf2 -> {
            this.minDutyCycle.setTextNullable(ahf2.getMinDutyCycle());
            this.maxDutyCycle.setTextNullable(ahf2.getMaxDutyCycle());
            this.maxBoardCurrent.setTextNullable(ahf2.getMaxBoardCurrent());
            this.switchingFreq.setTextNullable(ahf2.getSwitchingFrequency());
            this.currentSenseThresholdVds.setTextNullable(ahf2.getCurrentSenseThresholdVds());
            this.currentSenseThresholdWinding.setTextNullable(ahf2.getCurrentSenseThresholdWinding());
            this.currentSenseGain.setTextNullable(ahf2.getCurrentSenseGain());
            this.currentFilterSize.setTextNullable(ahf2.getCurrentFilterSize());
            this.controlDivider.setTextNullable(ahf2.getControlDivider());
            Optional.ofNullable(ahf2.getWindingOrder()).map(anv::a).ifPresent(this.windingOrder::setValue);
            Optional.ofNullable(ahf2.getHallOrder()).map(anr::a).ifPresent(this.hallOrder::setValue);
            Optional.ofNullable(ahf2.getHallOffset()).map(anq::a).ifPresent(this.hallOffset::setValue);
        });
        Optional.ofNullable(aib2.getBoardCalibration()).ifPresent(ahd2 -> {
            this.calibOffsetIa.setTextNullable(ahd2.getOffsetIa());
            this.calibOffsetIb.setTextNullable(ahd2.getOffsetIb());
            this.calibOffsetIc.setTextNullable(ahd2.getOffsetIc());
            this.calibOffsetIBus.setTextNullable(ahd2.getOffsetIBus());
            this.calibOffsetVa.setTextNullable(ahd2.getOffsetVa());
            this.calibOffsetVb.setTextNullable(ahd2.getOffsetVb());
            this.calibOffsetVc.setTextNullable(ahd2.getOffsetVc());
        });
        Optional.ofNullable(aib2.getGearTrain()).ifPresent(ahz2 -> {
            this.gearRatioNumerator.setTextNullable(aib2.getGearTrain().getGearRatioNumerator());
            this.gearRatioDenominator.setTextNullable(aib2.getGearTrain().getGearRatioDenominator());
            this.gearEfficiency.setTextNullable(aib2.getGearTrain().getEfficiency());
            this.maxOutputTorque.setTextNullable(ahz2.getMaxOutputTorque());
        });
    }

    private void setupInputFields(MotorDriverCommand motorDriverCommand) {
        Object object2 = this.device.getInfo();
        axy axy2 = ((axs)object2).a;
        object2 = axy2;
        axz axz2 = axy2.a;
        object2 = axy2;
        ayd ayd2 = ((axy)object2).a;
        object2 = axy2;
        axo axo2 = ((axy)object2).a;
        object2 = axy2;
        axk axk2 = ((axy)object2).a;
        Object object3 = axy2;
        axg axg2 = ((axy)object3).a;
        object3 = axy2;
        axh axh2 = ((axy)object3).a;
        object3 = axy2;
        axf axf2 = ((axy)object3).a;
        MotorDriverController motorDriverController = this;
        object3 = axo2;
        motorDriverController.bindIntField(motorDriverController.gearRatioNumerator, (ReadOnlyDoubleProperty)((axo)object3).bx, n2 -> motorDriverCommand.gearTrain().a(n2));
        MotorDriverController motorDriverController2 = this;
        object3 = axo2;
        motorDriverController2.bindIntField(motorDriverController2.gearRatioDenominator, (ReadOnlyDoubleProperty)((axo)object3).bw, n2 -> motorDriverCommand.gearTrain().b(n2));
        MotorDriverController motorDriverController3 = this;
        object3 = axo2;
        motorDriverController3.bindField(motorDriverController3.gearEfficiency, (ReadOnlyDoubleProperty)((axo)object3).bv, f2 -> motorDriverCommand.gearTrain().a(f2));
        MotorDriverController motorDriverController4 = this;
        object3 = axo2;
        motorDriverController4.bindField(motorDriverController4.maxOutputTorque, (ReadOnlyDoubleProperty)((axo)object3).by, f2 -> motorDriverCommand.gearTrain().b(f2));
        for (CustomTextField customTextField : List.of(this.gearRatioNumerator.getTextInput(), this.gearRatioDenominator.getTextInput())) {
            this.validation.registerValidator((Control)customTextField, (control, object) -> {
                boolean bl2 = (!this.gearRatioNumerator.getText().isBlank() || !this.gearRatioDenominator.getText().isBlank()) && !ParseUtils.isInteger(customTextField.getText());
                return ValidationResult.fromErrorIf((Control)customTextField, "Numerator and denominator must be set together.", bl2);
            });
            PropUtil.runOnChange(this.validation::revalidate, new ObservableValue[]{customTextField.textProperty()});
        }
        MotorDriverController motorDriverController5 = this;
        object2 = axk2;
        motorDriverController5.bindEnumField(motorDriverController5.outputEncoder, (ReadOnlyObjectProperty)((axk)object2).s, (Consumer)ano2 -> motorDriverCommand.encoders().b(ano2.a));
        MotorDriverController motorDriverController6 = this;
        object2 = axk2;
        motorDriverController6.bindEnumField(motorDriverController6.deflectionEncoder, (ReadOnlyObjectProperty)((axk)object2).q, (Consumer)ano2 -> motorDriverCommand.encoders().c(ano2.a));
        MotorDriverController motorDriverController7 = this;
        object2 = axk2;
        motorDriverController7.bindEnumField(motorDriverController7.motorEncoder, (ReadOnlyObjectProperty)((axk)object2).r, (Consumer)ano2 -> motorDriverCommand.encoders().a(ano2.a));
        MotorDriverController motorDriverController8 = this;
        object3 = axk2;
        motorDriverController8.bindEnumField(motorDriverController8.torqueSource, (ReadOnlyObjectProperty)((axk)object3).t, (Consumer)anu2 -> motorDriverCommand.encoders().a(anu2.a));
        this.encoderA1Controller.bindFields(this, ano.c, motorDriverCommand);
        this.encoderA2Controller.bindFields(this, ano.d, motorDriverCommand);
        this.encoderB1Controller.bindFields(this, ano.e, motorDriverCommand);
        this.encoderB2Controller.bindFields(this, ano.f, motorDriverCommand);
        this.encoderHallsController.bindFields(this, ano.g, motorDriverCommand);
        MotorDriverController motorDriverController9 = this;
        object3 = axg2;
        motorDriverController9.bindField(motorDriverController9.minDutyCycle, (ReadOnlyDoubleProperty)((axg)object3).aj, f2 -> motorDriverCommand.board().a(f2));
        MotorDriverController motorDriverController10 = this;
        object3 = axg2;
        motorDriverController10.bindField(motorDriverController10.maxDutyCycle, (ReadOnlyDoubleProperty)((axg)object3).ai, f2 -> motorDriverCommand.board().b(f2));
        MotorDriverController motorDriverController11 = this;
        object3 = axg2;
        motorDriverController11.bindField(motorDriverController11.maxBoardCurrent, (ReadOnlyDoubleProperty)((axg)object3).ah, f2 -> motorDriverCommand.board().c(f2));
        MotorDriverController motorDriverController12 = this;
        object3 = axg2;
        motorDriverController12.bindField(motorDriverController12.switchingFreq, (ReadOnlyDoubleProperty)((axg)object3).ac, f2 -> motorDriverCommand.board().d(f2));
        MotorDriverController motorDriverController13 = this;
        object3 = axg2;
        motorDriverController13.bindField(motorDriverController13.controlDivider, (ReadOnlyDoubleProperty)((axg)object3).ab, f2 -> motorDriverCommand.board().e((int)f2));
        MotorDriverController motorDriverController14 = this;
        object3 = axg2;
        motorDriverController14.bindField(motorDriverController14.currentSenseThresholdVds, (ReadOnlyDoubleProperty)((axg)object3).af, f2 -> motorDriverCommand.board().a((int)f2));
        MotorDriverController motorDriverController15 = this;
        object3 = axg2;
        motorDriverController15.bindField(motorDriverController15.currentSenseThresholdWinding, (ReadOnlyDoubleProperty)((axg)object3).ag, f2 -> motorDriverCommand.board().b((int)f2));
        MotorDriverController motorDriverController16 = this;
        object3 = axg2;
        motorDriverController16.bindField(motorDriverController16.currentFilterSize, (ReadOnlyDoubleProperty)((axg)object3).ad, f2 -> motorDriverCommand.board().d((int)f2));
        MotorDriverController motorDriverController17 = this;
        object3 = axg2;
        motorDriverController17.bindField(motorDriverController17.currentSenseGain, (ReadOnlyDoubleProperty)((axg)object3).ae, f2 -> motorDriverCommand.board().c((int)f2));
        MotorDriverController motorDriverController18 = this;
        object3 = axg2;
        motorDriverController18.bindEnumField(motorDriverController18.windingOrder, (ReadOnlyObjectProperty)((axg)object3).k, (Consumer)anv2 -> motorDriverCommand.board().a(anv2.a));
        MotorDriverController motorDriverController19 = this;
        object3 = axg2;
        motorDriverController19.bindEnumField(motorDriverController19.hallOrder, (ReadOnlyObjectProperty)((axg)object3).j, (Consumer)anr2 -> motorDriverCommand.board().a(anr2.a));
        MotorDriverController motorDriverController20 = this;
        object3 = axg2;
        motorDriverController20.bindEnumField(motorDriverController20.hallOffset, (ReadOnlyObjectProperty)((axg)object3).i, (Consumer)anq2 -> motorDriverCommand.board().a(anq2.a));
        MotorDriverController motorDriverController21 = this;
        object3 = axf2;
        motorDriverController21.bindField(motorDriverController21.calibOffsetIa, (ReadOnlyDoubleProperty)((axf)object3).V, f2 -> motorDriverCommand.boardCalibration().a(f2));
        MotorDriverController motorDriverController22 = this;
        object3 = axf2;
        motorDriverController22.bindField(motorDriverController22.calibOffsetIb, (ReadOnlyDoubleProperty)((axf)object3).W, f2 -> motorDriverCommand.boardCalibration().b(f2));
        MotorDriverController motorDriverController23 = this;
        object3 = axf2;
        motorDriverController23.bindField(motorDriverController23.calibOffsetIc, (ReadOnlyDoubleProperty)((axf)object3).X, f2 -> motorDriverCommand.boardCalibration().c(f2));
        MotorDriverController motorDriverController24 = this;
        object3 = axf2;
        motorDriverController24.bindField(motorDriverController24.calibOffsetIBus, (ReadOnlyDoubleProperty)((axf)object3).U, f2 -> motorDriverCommand.boardCalibration().d(f2));
        MotorDriverController motorDriverController25 = this;
        object3 = axf2;
        motorDriverController25.bindField(motorDriverController25.calibOffsetVa, (ReadOnlyDoubleProperty)((axf)object3).Y, f2 -> motorDriverCommand.boardCalibration().e(f2));
        MotorDriverController motorDriverController26 = this;
        object3 = axf2;
        motorDriverController26.bindField(motorDriverController26.calibOffsetVb, (ReadOnlyDoubleProperty)((axf)object3).Z, f2 -> motorDriverCommand.boardCalibration().f(f2));
        MotorDriverController motorDriverController27 = this;
        object3 = axf2;
        motorDriverController27.bindField(motorDriverController27.calibOffsetVc, (ReadOnlyDoubleProperty)((axf)object3).aa, f2 -> motorDriverCommand.boardCalibration().g(f2));
        MotorDriverController motorDriverController28 = this;
        object3 = ayd2;
        motorDriverController28.bindField(motorDriverController28.windingThermalResistance, (ReadOnlyDoubleProperty)((ayd)object3).cN, f2 -> motorDriverCommand.thermalModel().a(f2));
        MotorDriverController motorDriverController29 = this;
        object3 = ayd2;
        motorDriverController29.bindField(motorDriverController29.windingThermalTimeConstant, (ReadOnlyDoubleProperty)((ayd)object3).cO, f2 -> motorDriverCommand.thermalModel().c(f2));
        MotorDriverController motorDriverController30 = this;
        object3 = ayd2;
        motorDriverController30.bindField(motorDriverController30.housingThermalResistance, (ReadOnlyDoubleProperty)((ayd)object3).cK, f2 -> motorDriverCommand.thermalModel().b(f2));
        MotorDriverController motorDriverController31 = this;
        object3 = ayd2;
        motorDriverController31.bindField(motorDriverController31.housingThermalTimeConstant, (ReadOnlyDoubleProperty)((ayd)object3).cL, f2 -> motorDriverCommand.thermalModel().d(f2));
        MotorDriverController motorDriverController32 = this;
        object3 = ayd2;
        motorDriverController32.bindField(motorDriverController32.thermalModelStartPercentage, (ReadOnlyDoubleProperty)((ayd)object3).cM, f2 -> motorDriverCommand.thermalModel().f(f2));
        MotorDriverController motorDriverController33 = this;
        object3 = ayd2;
        motorDriverController33.bindField(motorDriverController33.temperatureSourceUserValue, (ReadOnlyDoubleProperty)((ayd)object3).cJ, f2 -> motorDriverCommand.thermalModel().e(f2));
        MotorDriverController motorDriverController34 = this;
        object3 = ayd2;
        motorDriverController34.bindEnumField(motorDriverController34.temperatureSource, (ReadOnlyObjectProperty)((ayd)object3).H, (Consumer)ant2 -> motorDriverCommand.thermalModel().a(ant2.a));
        MotorDriverController motorDriverController35 = this;
        object3 = axh2;
        motorDriverController35.bindField(motorDriverController35.slewRateVoltage, (ReadOnlyDoubleProperty)((axh)object3).ao, f2 -> motorDriverCommand.controller().b(f2));
        MotorDriverController motorDriverController36 = this;
        object3 = axh2;
        motorDriverController36.bindField(motorDriverController36.slewRateCurrent, (ReadOnlyDoubleProperty)((axh)object3).an, f2 -> motorDriverCommand.controller().c(f2));
        MotorDriverController motorDriverController37 = this;
        object3 = axh2;
        motorDriverController37.bindField(motorDriverController37.motorElectricalPowerLimit, (ReadOnlyDoubleProperty)((axh)object3).ak, f2 -> motorDriverCommand.controller().d(f2));
        MotorDriverController motorDriverController38 = this;
        object3 = axh2;
        motorDriverController38.bindField(motorDriverController38.motorMechanicalPowerLimit, (ReadOnlyDoubleProperty)((axh)object3).al, f2 -> motorDriverCommand.controller().e(f2));
        MotorDriverController motorDriverController39 = this;
        object2 = axz2;
        motorDriverController39.bindField(motorDriverController39.polePairs, (ReadOnlyDoubleProperty)((axz)object2).cv, f2 -> motorDriverCommand.motor().a((int)f2));
        MotorDriverController motorDriverController40 = this;
        object3 = axz2;
        motorDriverController40.bindField(motorDriverController40.speedConstant, (ReadOnlyDoubleProperty)((axz)object3).cx, f2 -> motorDriverCommand.motor().f(f2));
        MotorDriverController motorDriverController41 = this;
        object3 = axz2;
        motorDriverController41.bindField(motorDriverController41.torqueConstant, (ReadOnlyDoubleProperty)((axz)object3).cy, f2 -> motorDriverCommand.motor().g(f2));
        MotorDriverController motorDriverController42 = this;
        object3 = axz2;
        motorDriverController42.bindField(motorDriverController42.maxMotorSpeed, (ReadOnlyDoubleProperty)((axz)object3).cs, f2 -> motorDriverCommand.motor().c(f2));
        MotorDriverController motorDriverController43 = this;
        object3 = axz2;
        motorDriverController43.bindField(motorDriverController43.windingResistance, (ReadOnlyDoubleProperty)((axz)object3).cC, f2 -> motorDriverCommand.motor().e(f2));
        MotorDriverController motorDriverController44 = this;
        object3 = axz2;
        motorDriverController44.bindField(motorDriverController44.windingInductance, (ReadOnlyDoubleProperty)((axz)object3).cB, f2 -> motorDriverCommand.motor().d((float)((double)f2 * 0.001)));
        MotorDriverController motorDriverController45 = this;
        object2 = axz2;
        motorDriverController45.bindField(motorDriverController45.windingMaxCurrent, (ReadOnlyDoubleProperty)((axz)object2).ct, f2 -> motorDriverCommand.motor().a(f2));
        MotorDriverController motorDriverController46 = this;
        object3 = axz2;
        motorDriverController46.bindField(motorDriverController46.windingMaxTemp, (ReadOnlyDoubleProperty)((axz)object3).cu, f2 -> motorDriverCommand.motor().b(f2));
        MotorDriverController motorDriverController47 = this;
        object3 = axz2;
        motorDriverController47.bindField(motorDriverController47.motorVelocityTempConstant, (ReadOnlyDoubleProperty)((axz)object3).cA, f2 -> motorDriverCommand.motor().i(f2));
        MotorDriverController motorDriverController48 = this;
        object3 = axz2;
        motorDriverController48.bindField(motorDriverController48.motorTorqueTempConstant, (ReadOnlyDoubleProperty)((axz)object3).cz, f2 -> motorDriverCommand.motor().h(f2));
        MotorDriverController motorDriverController49 = this;
        object3 = axz2;
        motorDriverController49.bindField(motorDriverController49.motorRotorInertia, (ReadOnlyDoubleProperty)((axz)object3).cw, f2 -> motorDriverCommand.motor().j(f2));
        MotorDriverController motorDriverController50 = this;
        object2 = axh2;
        object2 = ((axh)object2).b;
        motorDriverController50.bindField(motorDriverController50.focIqKp, (ReadOnlyDoubleProperty)((axm)object2).aE, f2 -> motorDriverCommand.controller().b().a(f2));
        MotorDriverController motorDriverController51 = this;
        object2 = axh2;
        object2 = ((axh)object2).b;
        motorDriverController51.bindField(motorDriverController51.focIqKi, (ReadOnlyDoubleProperty)((axm)object2).aD, f2 -> motorDriverCommand.controller().b().b(f2));
        MotorDriverController motorDriverController52 = this;
        object2 = axh2;
        object2 = ((axh)object2).b;
        motorDriverController52.bindField(motorDriverController52.focIqIClamp, (ReadOnlyDoubleProperty)((axm)object2).aC, f2 -> motorDriverCommand.controller().b().f(f2));
        MotorDriverController motorDriverController53 = this;
        object2 = axh2;
        object2 = ((axh)object2).a;
        motorDriverController53.bindField(motorDriverController53.focIdKp, (ReadOnlyDoubleProperty)((axm)object2).aE, f2 -> motorDriverCommand.controller().a().a(f2));
        MotorDriverController motorDriverController54 = this;
        object2 = axh2;
        object2 = ((axh)object2).a;
        motorDriverController54.bindField(motorDriverController54.focIdKi, (ReadOnlyDoubleProperty)((axm)object2).aD, f2 -> motorDriverCommand.controller().a().b(f2));
        MotorDriverController motorDriverController55 = this;
        object2 = axh2;
        object2 = ((axh)object2).a;
        motorDriverController55.bindField(motorDriverController55.focIdIClamp, (ReadOnlyDoubleProperty)((axm)object2).aC, f2 -> motorDriverCommand.controller().a().f(f2));
        this.suggestFocGainsButton.disableProperty().bind((ObservableValue)this.focIdKp.getTextInput().disableProperty());
        this.suggestFocGainsButton.setOnAction(actionEvent -> {
            axg axg3 = axg2;
            Object object = axg3;
            object = axg2;
            double d2 = axg3.ac.get() / Math.max(((axg)object).ab.get(), 1.0);
            long l2 = Math.round(d2 * 0.05);
            TextInputDialog textInputDialog = new TextInputDialog(String.valueOf(l2));
            textInputDialog.setHeaderText("The controller bandwidth defaults to 5% of the sampling frequency (" + atn.a(d2 / 1000.0) + " KHz).");
            textInputDialog.setContentText("Controller bandwidth [Hz]");
            Optional optional = textInputDialog.showAndWait();
            if (optional.isPresent()) {
                double d3 = TextUtil.parseDouble((String)optional.get());
                if (!Double.isFinite(d3)) {
                    azy.a((String)optional.get() + " is not a valid value.", bgt.a(actionEvent));
                    return;
                }
                axz axz3 = axz2;
                object = axz3;
                object = axz2;
                double d4 = d3;
                double d5 = d2;
                double d6 = (float)(((axz)object).cB.get() * 0.001);
                double d7 = axz3.cC.get();
                double d8 = 1.0 / d5;
                double d9 = d4 * (Math.PI * 2) * d8;
                double d10 = d7 * (d9 / (1.0 - Math.exp(-d7 * d8 / d6)));
                double d11 = 1.0 - Math.exp(-d7 * d8 / d6);
                bbv bbv2 = new bbv(d10, d11);
                object = axz2;
                double d12 = ((axz)object).ct.get() * 0.1;
                this.focIqKp.setTextNullable(bbv2.dv);
                this.focIqKi.setTextNullable(bbv2.dw);
                this.focIqIClamp.setTextNullable(d12);
                if (this.showAdvancedToggle.isSelected()) {
                    this.focIdKp.setTextNullable(bbv2.dv);
                    this.focIdKi.setTextNullable(bbv2.dw);
                    this.focIdIClamp.setTextNullable(d12);
                }
            }
        });
        this.calibrateMotorEncoderBtn.disableProperty().bind((ObservableValue)this.motorEncoder.disabledProperty());
        this.calibrateMotorEncoderBtn.setOnAction(actionEvent -> this.dialogService.a(this.motorEncoderCalibrationDialog).setOnResult(bcc2 -> {}));
        this.calibrateAdcBtn.disableProperty().bind((ObservableValue)this.calibOffsetIa.getTextInput().disabledProperty());
        this.calibrateAdcBtn.setOnAction(actionEvent -> this.dialogService.a(this.adcCalibrationDialog).setOnResult(bbo2 -> {
            this.calibOffsetIa.setTextNullable(Float.valueOf(bbo2.Q));
            this.calibOffsetIb.setTextNullable(Float.valueOf(bbo2.R));
            this.calibOffsetIc.setTextNullable(Float.valueOf(bbo2.S));
            this.calibOffsetIBus.setTextNullable(Float.valueOf(bbo2.T));
        }));
        bgt.b(() -> {
            if (!this.showAdvancedToggle.isSelected()) {
                this.focIdKp.setText(this.focIqKp.getText());
                this.focIdKi.setText(this.focIqKi.getText());
                this.focIdIClamp.setText(this.focIqIClamp.getText());
            }
        }, new Observable[]{this.showAdvancedToggle.selectedProperty(), this.focIqKp.textProperty(), this.focIqKi.textProperty(), this.focIqIClamp.textProperty()});
        this.controlMode.getChoiceBox().setDisable(true);
        MotorDriverController motorDriverController56 = this;
        object3 = axh2;
        motorDriverController56.bindEnumField(motorDriverController56.controlMode, (ReadOnlyObjectProperty)((axh)object3).l, (Consumer)ans2 -> {});
    }

    <E extends Enum<E>> void bindEnumField(HEnumInputField<E> hEnumInputField, ReadOnlyObjectProperty<E> readOnlyObjectProperty, Consumer<E> consumer) {
        Enum enum_ = MotorDriverController.getDefaultEnumValue((Enum)readOnlyObjectProperty.get());
        hEnumInputField.initValues(readOnlyObjectProperty, enum_);
        this.validation.registerValidator((Control)hEnumInputField.getChoiceBox(), false, bgh.a(hEnumInputField));
        this.onClear.add(hEnumInputField::clear);
        this.addInputList.add(() -> {
            Object e2 = hEnumInputField.getValue();
            if (e2 != null && e2 != enum_) {
                consumer.accept(e2);
            }
        });
    }

    private static <E extends Enum<E>> E getDefaultEnumValue(E e2) {
        if (e2 instanceof anp) {
            return (E)((Object)anp.a);
        }
        if (e2 instanceof ano) {
            return (E)((Object)ano.a);
        }
        if (e2 instanceof anu) {
            return (E)((Object)anu.a);
        }
        if (e2 instanceof ant) {
            return (E)((Object)ant.a);
        }
        if (e2 instanceof anv) {
            return (E)((Object)anv.a);
        }
        if (e2 instanceof anr) {
            return (E)((Object)anr.a);
        }
        if (e2 instanceof anq) {
            return (E)((Object)anq.a);
        }
        if (e2 instanceof anm) {
            return (E)((Object)anm.a);
        }
        if (e2 instanceof ann) {
            return (E)((Object)ann.a);
        }
        if (e2 instanceof anl) {
            return (E)((Object)anl.a);
        }
        if (e2 instanceof ans) {
            return (E)((Object)ans.a);
        }
        throw new IllegalArgumentException("Unknown default type for: " + String.valueOf(e2));
    }

    void bindField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, auj auj2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = bgh.a(customTextField, ParseUtils.FINITE_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Double d2;
            if (!customTextField.getText().isBlank() && (d2 = ParseUtils.tryParseFiniteDouble(customTextField)) != null) {
                auj2.accept(d2.floatValue());
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    void bindIntField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, IntConsumer intConsumer) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = bgh.a(customTextField, ParseUtils.INTEGER_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Integer n2;
            if (!customTextField.getText().isBlank() && (n2 = ParseUtils.tryParseInteger(customTextField.getText())) != null) {
                intConsumer.accept(n2);
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    @Generated
    public ToggleButton getPersistToggle() {
        return this.persistToggle;
    }
}

