/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.bdu;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bmn;
import us.hebi.gui.lib.byw;
import us.hebi.gui.lib.na;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class HebiLogFeedback
implements GroupFeedbackHandler {
    int prevTimeIndex = 0;
    int numJoints = -1;
    int maxEntries = -1;
    int numUserStateEntries = -1;
    public na time;
    private double[] timeLookup;
    public na[] positionCmd;
    public na[] velocityCmd;
    public na[] effortCmd;
    public na[] position;
    public na[] velocity;
    public na[] effort;
    public na[] pwmCmd;
    public na[] voltage;
    public na[] motorCurrent;
    public na[] motorTemperature;
    public na[] windingCurrent;
    public na[] windingTemperature;
    public na[] ambientTemperature;
    public na[] processorTemperature;
    public na[] rxSequence;
    public na[] deflection;
    public na[] innerEncoderPosition;
    public na[] motorPosition;
    public na[] motorVelocity;
    public na[] gyroX;
    public na[] gyroY;
    public na[] gyroZ;
    public na[] orientationW;
    public na[] orientationX;
    public na[] orientationY;
    public na[] orientationZ;
    public na[] pressure;
    public na[] focIdCmd;
    public na[] focId;
    public na[] focIqCmd;
    public na[] focIq;
    public na[] focVdCmd;
    public na[] focVd;
    public na[] focVqCmd;
    public na[] focVq;
    public na[] phaseCurrentA;
    public na[] phaseCurrentB;
    public na[] phaseCurrentC;
    public na[] phaseVoltageA;
    public na[] phaseVoltageB;
    public na[] phaseVoltageC;
    public na[] phaseDutyCycleA;
    public na[] phaseDutyCycleB;
    public na[] phaseDutyCycleC;
    public na[] hallState;
    public na[] userStates;
    private static final int NUM_USER_STATES_WITH_TIME = 10;
    double integratedTotalPower = 0.0;
    public na[] power;
    public na[] systemPower;
    public na[] roundTripTime;
    public na[] hwResponseTime;
    public na[] transmitTimeDelta;
    public na[] packetLoss;
    public na[] totalPacketLoss;
    public na[] springStiffness;
    public na[] firstOrientation;
    public na[] firstAccel;

    public int getIndexAt(double d2) {
        this.prevTimeIndex = bmn.a(this.timeLookup, this.timeLookup.length - 1, d2, this.prevTimeIndex);
        return this.prevTimeIndex;
    }

    public int getNumJoints() {
        return this.numJoints;
    }

    public HebiLogFeedback() {
        this.init(0, 8192, 0);
    }

    public HebiLogFeedback init(int n2, int n3, int n4) {
        this.numJoints = n2;
        this.maxEntries = n3;
        this.numUserStateEntries = n4;
        this.resize();
        return this;
    }

    @Override
    public void init(int n2) {
        this.init(n2, this.maxEntries, 0);
    }

    private na[] resizeGroup(na[] naArray) {
        return this.resizeMultiple(naArray, this.numJoints);
    }

    private na[] resizeMultiple(na[] naArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(naArray, n2, this.maxEntries);
    }

    private na resizeSingle(na na2) {
        return TDoubleArrayListRegistry.resizeSingle(na2, this.maxEntries);
    }

    @Override
    public void onInvalidate() {
        this.timeLookup = this.time.a();
        if (this.timeLookup.length > 0) {
            for (int i2 = 0; i2 < this.numJoints; ++i2) {
                na na2 = this.totalPacketLoss[i2];
                double d2 = na2.a(0);
                int n2 = 0;
                while (n2 < this.timeLookup.length) {
                    double d3 = na2.a(n2) - d2;
                    int n3 = n2++;
                    na na3 = na2;
                    na3.b[n3] = d3;
                }
            }
        }
    }

    @Override
    public void onGroupFeedback(double d2, FlatFeedback[] flatFeedbackArray, FlatFeedback[] flatFeedbackArray2) {
        if (flatFeedbackArray2.length == 0) {
            return;
        }
        this.time.c(d2);
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.numJoints; ++i2) {
            this.positionCmd[i2].c(flatFeedbackArray2[i2].positionCmd);
            this.velocityCmd[i2].c(flatFeedbackArray2[i2].velocityCmd);
            this.effortCmd[i2].c(flatFeedbackArray2[i2].effortCmd);
            this.position[i2].c(flatFeedbackArray2[i2].position);
            this.velocity[i2].c(flatFeedbackArray2[i2].velocity);
            this.effort[i2].c(flatFeedbackArray2[i2].effort);
            this.pwmCmd[i2].c(flatFeedbackArray2[i2].pwmCmd);
            this.voltage[i2].c(flatFeedbackArray2[i2].voltage);
            this.motorCurrent[i2].c(flatFeedbackArray2[i2].motorCurrent);
            this.motorTemperature[i2].c(flatFeedbackArray2[i2].motorTemperature);
            this.windingCurrent[i2].c(flatFeedbackArray2[i2].windingCurrent);
            this.windingTemperature[i2].c(flatFeedbackArray2[i2].windingTemperature);
            this.ambientTemperature[i2].c(flatFeedbackArray2[i2].ambientTemperature);
            this.processorTemperature[i2].c(flatFeedbackArray2[i2].processorTemperature);
            this.rxSequence[i2].c(flatFeedbackArray2[i2].rxSequence);
            this.gyroX[i2].c(flatFeedbackArray2[i2].gyroX);
            this.gyroY[i2].c(flatFeedbackArray2[i2].gyroY);
            this.gyroZ[i2].c(flatFeedbackArray2[i2].gyroZ);
            this.orientationW[i2].c(flatFeedbackArray2[i2].orientationW);
            this.orientationX[i2].c(flatFeedbackArray2[i2].orientationX);
            this.orientationY[i2].c(flatFeedbackArray2[i2].orientationY);
            this.orientationZ[i2].c(flatFeedbackArray2[i2].orientationZ);
            this.pressure[i2].c(flatFeedbackArray2[i2].pressure);
            this.focIdCmd[i2].c(flatFeedbackArray2[i2].focIdCmd);
            this.focId[i2].c(flatFeedbackArray2[i2].focId);
            this.focIqCmd[i2].c(flatFeedbackArray2[i2].focIqCmd);
            this.focIq[i2].c(flatFeedbackArray2[i2].focIq);
            this.focVdCmd[i2].c(flatFeedbackArray2[i2].focVdCmd);
            this.focVd[i2].c(flatFeedbackArray2[i2].focVd);
            this.focVqCmd[i2].c(flatFeedbackArray2[i2].focVqCmd);
            this.focVq[i2].c(flatFeedbackArray2[i2].focVq);
            this.phaseCurrentA[i2].c(flatFeedbackArray2[i2].phaseCurrentA);
            this.phaseCurrentB[i2].c(flatFeedbackArray2[i2].phaseCurrentB);
            this.phaseCurrentC[i2].c(flatFeedbackArray2[i2].phaseCurrentC);
            this.phaseVoltageA[i2].c(flatFeedbackArray2[i2].phaseVoltageA);
            this.phaseVoltageB[i2].c(flatFeedbackArray2[i2].phaseVoltageB);
            this.phaseVoltageC[i2].c(flatFeedbackArray2[i2].phaseVoltageC);
            this.phaseDutyCycleA[i2].c(flatFeedbackArray2[i2].phaseDutyCycleA);
            this.phaseDutyCycleB[i2].c(flatFeedbackArray2[i2].phaseDutyCycleB);
            this.phaseDutyCycleC[i2].c(flatFeedbackArray2[i2].phaseDutyCycleC);
            this.hallState[i2].c(flatFeedbackArray2[i2].hallState);
            this.motorPosition[i2].c(flatFeedbackArray2[i2].motorPosition);
            this.motorVelocity[i2].c(flatFeedbackArray2[i2].motorVelocity);
            this.deflection[i2].c(flatFeedbackArray2[i2].deflection);
            this.innerEncoderPosition[i2].c(flatFeedbackArray2[i2].position - flatFeedbackArray2[i2].deflection);
            this.springStiffness[i2].c(flatFeedbackArray2[i2].effort / -flatFeedbackArray2[i2].deflection);
            double d4 = flatFeedbackArray2[i2].voltage * flatFeedbackArray2[i2].motorCurrent;
            this.power[i2].c(d4);
            if (!Double.isNaN(d4)) {
                d3 += d4;
                double d5 = flatFeedbackArray2[i2].time - flatFeedbackArray[i2].time;
                if (!Double.isNaN(d5)) {
                    this.integratedTotalPower += d5 * d4;
                }
            }
            this.roundTripTime[i2].c(1000.0 * (flatFeedbackArray2[i2].pcRxTime - flatFeedbackArray2[i2].pcTxTime));
            this.hwResponseTime[i2].c(1000.0 * (flatFeedbackArray2[i2].hwTxTime - flatFeedbackArray2[i2].hwRxTime));
            this.transmitTimeDelta[i2].c(1000.0 * (flatFeedbackArray2[i2].pcTxTime - flatFeedbackArray[i2].pcTxTime));
            this.packetLoss[i2].c(flatFeedbackArray2[i2].sequence - flatFeedbackArray[i2].sequence - 1.0);
            this.totalPacketLoss[i2].c(flatFeedbackArray2[i2].sequence - flatFeedbackArray2[i2].rxSequence);
        }
        this.systemPower[0].c(d3);
        this.systemPower[1].c(this.integratedTotalPower / 3600.0);
        FlatFeedback flatFeedback = flatFeedbackArray2[0];
        this.firstAccel[0].c(flatFeedback.accelX);
        this.firstAccel[1].c(flatFeedback.accelY);
        this.firstAccel[2].c(flatFeedback.accelZ);
        this.firstOrientation[0].c(flatFeedback.orientationW);
        this.firstOrientation[1].c(flatFeedback.orientationX);
        this.firstOrientation[2].c(flatFeedback.orientationY);
        this.firstOrientation[3].c(flatFeedback.orientationZ);
    }

    @Override
    public void onUserState(double d2, byw byw2) {
        this.userStates[0].c(d2);
        this.userStates[1].c(byw2.bw);
        this.userStates[2].c(byw2.bx);
        this.userStates[3].c(byw2.by);
        this.userStates[4].c(byw2.bz);
        this.userStates[5].c(byw2.bA);
        this.userStates[6].c(byw2.bB);
        this.userStates[7].c(byw2.bC);
        this.userStates[8].c(byw2.bD);
        this.userStates[9].c(byw2.bE);
    }

    private void resize() {
        this.integratedTotalPower = 0.0;
        this.time = this.resizeSingle(this.time);
        this.userStates = TDoubleArrayListRegistry.resizeMultiple(this.userStates, 10, this.numUserStateEntries);
        this.positionCmd = this.resizeGroup(this.positionCmd);
        this.velocityCmd = this.resizeGroup(this.velocityCmd);
        this.effortCmd = this.resizeGroup(this.effortCmd);
        this.position = this.resizeGroup(this.position);
        this.velocity = this.resizeGroup(this.velocity);
        this.effort = this.resizeGroup(this.effort);
        this.pwmCmd = this.resizeGroup(this.pwmCmd);
        this.voltage = this.resizeGroup(this.voltage);
        this.motorCurrent = this.resizeGroup(this.motorCurrent);
        this.motorTemperature = this.resizeGroup(this.motorTemperature);
        this.windingCurrent = this.resizeGroup(this.windingCurrent);
        this.windingTemperature = this.resizeGroup(this.windingTemperature);
        this.ambientTemperature = this.resizeGroup(this.ambientTemperature);
        this.processorTemperature = this.resizeGroup(this.processorTemperature);
        this.rxSequence = this.resizeGroup(this.rxSequence);
        this.gyroX = this.resizeGroup(this.gyroX);
        this.gyroY = this.resizeGroup(this.gyroY);
        this.gyroZ = this.resizeGroup(this.gyroZ);
        this.orientationW = this.resizeGroup(this.orientationW);
        this.orientationX = this.resizeGroup(this.orientationX);
        this.orientationY = this.resizeGroup(this.orientationY);
        this.orientationZ = this.resizeGroup(this.orientationZ);
        this.pressure = this.resizeGroup(this.pressure);
        this.focIdCmd = this.resizeGroup(this.focIdCmd);
        this.focId = this.resizeGroup(this.focId);
        this.focIqCmd = this.resizeGroup(this.focIqCmd);
        this.focIq = this.resizeGroup(this.focIq);
        this.focVdCmd = this.resizeGroup(this.focVdCmd);
        this.focVd = this.resizeGroup(this.focVd);
        this.focVqCmd = this.resizeGroup(this.focVqCmd);
        this.focVq = this.resizeGroup(this.focVq);
        this.phaseCurrentA = this.resizeGroup(this.phaseCurrentA);
        this.phaseCurrentB = this.resizeGroup(this.phaseCurrentB);
        this.phaseCurrentC = this.resizeGroup(this.phaseCurrentC);
        this.phaseVoltageA = this.resizeGroup(this.phaseVoltageA);
        this.phaseVoltageB = this.resizeGroup(this.phaseVoltageB);
        this.phaseVoltageC = this.resizeGroup(this.phaseVoltageC);
        this.phaseDutyCycleA = this.resizeGroup(this.phaseDutyCycleA);
        this.phaseDutyCycleB = this.resizeGroup(this.phaseDutyCycleB);
        this.phaseDutyCycleC = this.resizeGroup(this.phaseDutyCycleC);
        this.hallState = this.resizeGroup(this.hallState);
        this.motorPosition = this.resizeGroup(this.motorPosition);
        this.motorVelocity = this.resizeGroup(this.motorVelocity);
        this.deflection = this.resizeGroup(this.deflection);
        this.innerEncoderPosition = this.resizeGroup(this.innerEncoderPosition);
        this.springStiffness = this.resizeGroup(this.springStiffness);
        this.power = this.resizeGroup(this.power);
        this.systemPower = this.resizeMultiple(this.systemPower, 2);
        this.roundTripTime = this.resizeGroup(this.roundTripTime);
        this.hwResponseTime = this.resizeGroup(this.hwResponseTime);
        this.transmitTimeDelta = this.resizeGroup(this.transmitTimeDelta);
        this.packetLoss = this.resizeGroup(this.packetLoss);
        this.totalPacketLoss = this.resizeGroup(this.totalPacketLoss);
        this.firstAccel = this.resizeMultiple(this.firstAccel, 3);
        this.firstOrientation = this.resizeMultiple(this.firstOrientation, 4);
    }

    public void getCharts(ChartList chartList) {
        chartList.setTime(this.time).setTraceType(bek.a).addCommandChart(ChartCategory.Commands, "Position", "rad", -1.5707963267948966, 1.5707963267948966, this.positionCmd, this.position).addErrorChart(ChartCategory.Commands, "Position error", "rad", 0.0, 0.05, this.positionCmd, this.position).addCommandChart(ChartCategory.Commands, "Velocity", "rad/s", -5.0, 5.0, this.velocityCmd, this.velocity).addErrorChart(ChartCategory.Commands, "Velocity error", "rad/s", 0.0, 0.05, this.velocityCmd, this.velocity).addCommandChart(ChartCategory.Commands, "Torque", "Nm", -5.0, 5.0, this.effortCmd, this.effort).addErrorChart(ChartCategory.Commands, "Torque error", "Nm", 0.0, 0.05, this.effortCmd, this.effort).addDeviceChart(ChartCategory.Actuator, "PWM", "0-1", -1.0, 1.0, this.pwmCmd).addDeviceChart(ChartCategory.Actuator, "Power", "W", 0.0, 1.0, this.power).addDeviceChart(ChartCategory.Actuator, "Voltage", "V", 0.0, 50.0, this.voltage).addDeviceChart(ChartCategory.Actuator, "Motor current", "A", 0.0, 1.0, this.motorCurrent).addDeviceChart(ChartCategory.Actuator, "Motor temperature", "\u00b0C", 0.0, 100.0, this.motorTemperature).addDeviceChart(ChartCategory.Actuator, "Winding current", "A", 0.0, 1.0, this.windingCurrent).addDeviceChart(ChartCategory.Actuator, "Winding temperature", "\u00b0C", 0.0, 100.0, this.windingTemperature).addAsHistogram(ChartCategory.Actuator, "Winding temperature %", "\u00b0C", this.windingTemperature).addDeviceChart(ChartCategory.Actuator, "Ambient temperature", "\u00b0C", 0.0, 100.0, this.ambientTemperature).addDeviceChart(ChartCategory.Actuator, "Processor temperature", "\u00b0C", 0.0, 100.0, this.processorTemperature).addDeviceChart(ChartCategory.Actuator, "Pressure", "kPa", 0.0, 150.0, this.pressure).addSingleTrace(ChartCategory.Actuator, "System power ", "W", 0.0, 10.0, this.systemPower[0]).addSingleTrace(ChartCategory.Actuator, "System energy use", "Wh", 0.0, 1.0, this.systemPower[1]).addCommandChart(ChartCategory.MotorDriver, "FOC Id", "A", -1.0, 1.0, this.focIdCmd, this.focId).addErrorChart(ChartCategory.MotorDriver, "FOC Id error", "A", -1.0, 1.0, this.focIdCmd, this.focId).addCommandChart(ChartCategory.MotorDriver, "FOC Iq", "A", -1.0, 1.0, this.focIqCmd, this.focIq).addErrorChart(ChartCategory.MotorDriver, "FOC Iq error", "A", -1.0, 1.0, this.focIqCmd, this.focIq).addCommandChart(ChartCategory.MotorDriver, "FOC Vd", "V", -1.0, 1.0, this.focVdCmd, this.focVd).addErrorChart(ChartCategory.MotorDriver, "FOC Vd error", "V", -1.0, 1.0, this.focVdCmd, this.focVd).addCommandChart(ChartCategory.MotorDriver, "FOC Vq", "V", -1.0, 1.0, this.focVqCmd, this.focVq).addErrorChart(ChartCategory.MotorDriver, "FOC Vq error", "V", -1.0, 1.0, this.focVqCmd, this.focVq).addPhaseChart(ChartCategory.MotorDriver, "Phase current", "A", -1.0, 1.0, this.phaseCurrentA, this.phaseCurrentB, this.phaseCurrentC).addPhaseChart(ChartCategory.MotorDriver, "Phase voltage", "V", -1.0, 1.0, this.phaseVoltageA, this.phaseVoltageB, this.phaseVoltageC).addPhaseChart(ChartCategory.MotorDriver, "Phase duty cycle", "0-1", -1.0, 1.0, this.phaseDutyCycleA, this.phaseDutyCycleB, this.phaseDutyCycleC).addDeviceChart(ChartCategory.MotorDriver, "Motor position", "rad", Double.NaN, Double.NaN, this.motorPosition).addDeviceChart(ChartCategory.MotorDriver, "Motor velocity", "rad/s", Double.NaN, Double.NaN, this.motorVelocity).addDeviceChart(ChartCategory.MotorDriver, "Hall state", "enum", 0.0, 6.0, this.hallState).setTraceType(bek.c).addDeviceChart(ChartCategory.Network, "Round trip time", "ms", 0.0, 0.5, this.roundTripTime).addAsHistogram(ChartCategory.Network, "Round trip time %", "ms", this.roundTripTime).addMedianBarChart(ChartCategory.Network, "Round trip time / Index", bdu.a("Median round trip time", "ms").a(0.0, 0.5, false), this.roundTripTime).addDeviceChart(ChartCategory.Network, "Hardware response time", "ms", 0.0, 0.5, this.hwResponseTime).addAsHistogram(ChartCategory.Network, "Hardware response time %", "ms", this.hwResponseTime).addDeviceChart(ChartCategory.Network, "Transmit time delta", "ms", 0.0, 0.5, this.transmitTimeDelta).addAsHistogram(ChartCategory.Network, "Transmit time delta %", "ms", this.transmitTimeDelta).addDeviceChart(ChartCategory.Network, "Packet loss", null, 0.0, 1.0, this.packetLoss).addAsHistogram(ChartCategory.Network, "Packet loss %", null, this.packetLoss).addDeviceChart(ChartCategory.Network, "Rx sequence", null, 0.0, 1.0, this.rxSequence).addDeviceChart(ChartCategory.Network, "Total packet loss", null, 0.0, 1.0, this.totalPacketLoss).addIndexBarChart(ChartCategory.Network, "Total packet loss / index", bdu.a("Total packet loss", null), n2 -> this.totalPacketLoss[n2].a(this.totalPacketLoss[n2].size() - 1), this.numJoints).setTraceType(bek.a).addCombinedUserStates(ChartCategory.UserState, "States", this.userStates).addXyzChart(ChartCategory.BaseImu, "Accelerometer", "m/s^2", -10.0, 10.0, this.firstAccel).addXyzChart(ChartCategory.BaseImu, "Gyroscope", "rad/s", -3.0, 3.0, new na[]{this.gyroX[0], this.gyroY[0], this.gyroZ[0]}).addQuaternionTraces(ChartCategory.BaseImu, "Orientation", this.firstOrientation).addDeviceChart(ChartCategory.Encoders, "Inner position", "rad", -1.5707963267948966, 1.5707963267948966, this.innerEncoderPosition).addDeviceChart(ChartCategory.Encoders, "Deflection", "rad", -0.1, 0.1, this.deflection).addDeviceChart(ChartCategory.Encoders, "Stiffness", "Nm/rad", 0.0, 130.0, this.springStiffness).addDeviceXY(ChartCategory.Encoders, "Stiffness / deflection", bdu.a("Deflection", "rad").a(-0.1, 0.1, false), this.deflection, bdu.a("Stiffness", "Nm/rad").a(0.0, 130.0, false), this.springStiffness).addDeviceXY(ChartCategory.Encoders, "Effort / deflection", bdu.a("Deflection", "rad").a(-0.1, 0.1, false), this.deflection, bdu.a("Effort", "Nm").a(0.0, 130.0, false), this.effort);
    }
}

