/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.glue;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import us.hebi.glue.UnsafeAccess;

public final class Jvm {
    private static final int JVM_JAVA_MAJOR_VERSION = Jvm.getMajorVersion0();
    static final boolean IS_JAVA_8_PLUS = JVM_JAVA_MAJOR_VERSION >= 8;
    static final boolean IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION >= 9;
    static final boolean IS_JAVA_12_PLUS = JVM_JAVA_MAJOR_VERSION >= 12;
    static final boolean IS_JAVA_16_PLUS = JVM_JAVA_MAJOR_VERSION >= 16;
    static final boolean IS_JAVA_17_PLUS = JVM_JAVA_MAJOR_VERSION >= 17;
    static final int CLASS_VERSION_6 = 50;
    static final int CLASS_VERSION_7 = 51;
    static final int CLASS_VERSION_8 = 52;
    static final int CLASS_VERSION_9 = 53;
    static final int CLASS_VERSION_10 = 54;
    static final int CLASS_VERSION_11 = 55;

    public static int majorVersion() {
        return JVM_JAVA_MAJOR_VERSION;
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object object = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clazz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clazz.getDeclaredMethod("major", new Class[0]).invoke(object, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
    }

    public static Field getField(Class clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            Jvm.setAccessible(field);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                try {
                    return Jvm.getField(clazz2, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)noSuchFieldException);
        }
    }

    public static Method getMethod(Class clazz, String string, Class ... classArray) {
        return Jvm.getMethod0(clazz, string, classArray, true);
    }

    private static Method getMethod0(Class clazz, String string, Class[] classArray, boolean bl2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                Jvm.setAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                try {
                    Method method = Jvm.getMethod0(clazz2, string, classArray, false);
                    if (method != null) {
                        return method;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl2) {
                throw new AssertionError((Object)noSuchMethodException);
            }
            return null;
        }
    }

    private static void setAccessible(AccessibleObject accessibleObject) {
        if (!IS_JAVA_9_PLUS || IS_JAVA_12_PLUS) {
            accessibleObject.setAccessible(true);
            return;
        }
        try {
            Field field = AccessibleObject.class.getDeclaredField("override");
            long l2 = UnsafeAccess.UNSAFE.objectFieldOffset(field);
            UnsafeAccess.UNSAFE.putBoolean(accessibleObject, l2, true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Jvm() {
    }
}

