/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.controlsfx.control.table.ColumnFilter;

public final class TableFilter<T> {
    private final TableView<T> tableView;
    private final ObservableList<T> backingList;
    private final FilteredList<T> filteredList;
    private final ObservableList<ColumnFilter<T, ?>> columnFilters = FXCollections.observableArrayList();

    @Deprecated
    public TableFilter(TableView<T> tableView) {
        this(tableView, false);
    }

    private TableFilter(TableView<T> tableView, boolean bl2) {
        this.tableView = tableView;
        this.backingList = tableView.getItems();
        this.filteredList = new FilteredList((ObservableList)new SortedList(this.backingList));
        SortedList sortedList = new SortedList(this.filteredList);
        this.filteredList.setPredicate(object -> true);
        sortedList.comparatorProperty().bind((ObservableValue)tableView.comparatorProperty());
        tableView.setItems((ObservableList)sortedList);
        this.applyForAllColumns();
        tableView.getStylesheets().add((Object)TableFilter.class.getResource("/impl/org/controlsfx/table/tablefilter.css").toExternalForm());
        if (!bl2) {
            this.columnFilters.forEach(ColumnFilter::initialize);
        }
        tableView.getColumns().addListener(change -> {
            while (change.next()) {
                this.columnFilters.addAll((Collection)change.getAddedSubList().stream().flatMap(this::extractNestedColumns).map(tableColumn -> new ColumnFilter(this, tableColumn)).collect(Collectors.toList()));
                this.columnFilters.removeAll((Collection)change.getRemoved().stream().flatMap(this::extractNestedColumns).flatMap(tableColumn -> this.columnFilters.stream().filter(columnFilter -> columnFilter.getTableColumn() == tableColumn)).collect(Collectors.toList()));
            }
        });
    }

    public void setSearchStrategy(BiPredicate<String, String> biPredicate) {
        this.columnFilters.forEach(columnFilter -> columnFilter.setSearchStrategy(biPredicate));
    }

    public ObservableList<T> getBackingList() {
        return this.backingList;
    }

    public FilteredList<T> getFilteredList() {
        return this.filteredList;
    }

    private void applyForAllColumns() {
        this.columnFilters.setAll((Collection)this.tableView.getColumns().stream().flatMap(this::extractNestedColumns).map(tableColumn -> new ColumnFilter(this, tableColumn)).collect(Collectors.toList()));
    }

    private <S> Stream<TableColumn<T, ?>> extractNestedColumns(TableColumn<T, S> tableColumn) {
        if (tableColumn.getColumns().size() == 0) {
            return Stream.of(tableColumn);
        }
        return tableColumn.getColumns().stream().flatMap(this::extractNestedColumns);
    }

    public void selectValue(TableColumn<?, ?> tableColumn, Object object) {
        this.columnFilters.stream().filter(columnFilter -> columnFilter.getTableColumn() == tableColumn).forEach(columnFilter -> columnFilter.selectValue(object));
    }

    public void unselectValue(TableColumn<?, ?> tableColumn, Object object) {
        this.columnFilters.stream().filter(columnFilter -> columnFilter.getTableColumn() == tableColumn).forEach(columnFilter -> columnFilter.unselectValue(object));
    }

    public void selectAllValues(TableColumn<?, ?> tableColumn) {
        this.columnFilters.stream().filter(columnFilter -> columnFilter.getTableColumn() == tableColumn).forEach(ColumnFilter::selectAllValues);
    }

    public void unSelectAllValues(TableColumn<?, ?> tableColumn) {
        this.columnFilters.stream().filter(columnFilter -> columnFilter.getTableColumn() == tableColumn).forEach(ColumnFilter::unSelectAllValues);
    }

    public void executeFilter() {
        if (this.columnFilters.stream().anyMatch(ColumnFilter::isFiltered)) {
            this.filteredList.setPredicate(object -> this.columnFilters.stream().allMatch(columnFilter -> columnFilter.evaluate(object)));
        } else {
            this.resetFilter();
        }
        for (ColumnFilter columnFilter : this.columnFilters) {
            columnFilter.applyFilterIcon();
        }
    }

    public void resetFilter() {
        this.filteredList.setPredicate(object -> true);
    }

    public void resetAllFilters() {
        for (ColumnFilter columnFilter : this.columnFilters) {
            columnFilter.resetAllFilters();
            columnFilter.applyFilterIcon();
        }
    }

    public TableView<T> getTableView() {
        return this.tableView;
    }

    public ObservableList<ColumnFilter<T, ?>> getColumnFilters() {
        return this.columnFilters;
    }

    public Optional<ColumnFilter<T, ?>> getColumnFilter(TableColumn<T, ?> tableColumn) {
        Optional<ColumnFilter<ColumnFilter, ?>> optional = this.columnFilters.stream().filter(columnFilter -> columnFilter.getTableColumn().equals(tableColumn)).findAny();
        optional.ifPresent(ColumnFilter::initialize);
        return optional;
    }

    public boolean isDirty() {
        return this.columnFilters.stream().anyMatch(ColumnFilter::isFiltered);
    }

    public static <T> Builder<T> forTableView(TableView<T> tableView) {
        return new Builder<T>(tableView);
    }

    public static final class Builder<T> {
        private final TableView<T> tableView;
        private volatile boolean lazyInd = false;

        private Builder(TableView<T> tableView) {
            this.tableView = tableView;
        }

        public Builder<T> lazy(boolean bl2) {
            this.lazyInd = bl2;
            return this;
        }

        public TableFilter<T> apply() {
            return new TableFilter<T>(this.tableView, this.lazyInd);
        }
    }
}

