/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import com.sun.javafx.event.EventHandlerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;

public class SpreadsheetCellBase
implements SpreadsheetCell,
EventTarget {
    private static final int EDITABLE_BIT_POSITION = 4;
    private static final int WRAP_BIT_POSITION = 5;
    private static final int POPUP_BIT_POSITION = 6;
    private static final int IS_BROWSER_POSITION = 7;
    private final SpreadsheetCellType type;
    private final int row;
    private final int column;
    private int rowSpan;
    private int columnSpan;
    private final StringProperty format;
    private final StringProperty text;
    private final StringProperty styleProperty;
    private final ObjectProperty<Node> graphic;
    private String tooltip;
    private int propertyContainer = 0;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private ObservableSet<String> styleClass;
    private List<MenuItem> actionsList;
    private final ObjectProperty<Object> item = new SimpleObjectProperty<Object>((Object)this, "item"){

        protected void invalidated() {
            SpreadsheetCellBase.this.updateText();
        }
    };

    public SpreadsheetCellBase(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, SpreadsheetCellType.OBJECT);
    }

    public SpreadsheetCellBase(int n2, int n3, int n4, int n5, SpreadsheetCellType<?> spreadsheetCellType) {
        this.row = n2;
        this.column = n3;
        this.rowSpan = n4;
        this.columnSpan = n5;
        this.type = spreadsheetCellType;
        this.text = new SimpleStringProperty("");
        this.format = new SimpleStringProperty("");
        this.graphic = new SimpleObjectProperty();
        this.format.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                SpreadsheetCellBase.this.updateText();
            }
        });
        this.setEditable(true);
        this.getStyleClass().add((Object)"spreadsheet-cell");
        this.styleProperty = new SimpleStringProperty();
    }

    @Override
    public boolean match(Object object) {
        return this.type.match(object, this.getOptionsForEditor());
    }

    @Override
    public final void setItem(Object object) {
        if (this.isEditable()) {
            this.item.set(object);
        }
    }

    @Override
    public final Object getItem() {
        return this.item.get();
    }

    @Override
    public final ObjectProperty<Object> itemProperty() {
        return this.item;
    }

    @Override
    public final boolean isEditable() {
        return this.isSet(4);
    }

    @Override
    public final void setEditable(boolean bl2) {
        if (this.setMask(bl2, 4)) {
            Event.fireEvent((EventTarget)this, (Event)new Event(EDITABLE_EVENT_TYPE));
        }
    }

    @Override
    public boolean isWrapText() {
        return this.isSet(5);
    }

    @Override
    public boolean isCellGraphic() {
        return this.isSet(7);
    }

    @Override
    public void setCellGraphic(boolean bl2) {
        this.setMask(bl2, 7);
    }

    @Override
    public void setWrapText(boolean bl2) {
        if (this.setMask(bl2, 5)) {
            Event.fireEvent((EventTarget)this, (Event)new Event(WRAP_EVENT_TYPE));
        }
    }

    @Override
    public List<Object> getOptionsForEditor() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasPopup() {
        return this.isSet(6);
    }

    @Override
    public void setHasPopup(boolean bl2) {
        this.setMask(bl2, 6);
        Event.fireEvent((EventTarget)this, (Event)new Event(CORNER_EVENT_TYPE));
    }

    @Override
    public List<MenuItem> getPopupItems() {
        if (this.actionsList == null) {
            this.actionsList = new ArrayList<MenuItem>();
        }
        return this.actionsList;
    }

    @Override
    public final StringProperty formatProperty() {
        return this.format;
    }

    @Override
    public final String getFormat() {
        return (String)this.format.get();
    }

    @Override
    public final void setFormat(String string) {
        this.formatProperty().set((Object)string);
        this.updateText();
    }

    @Override
    public final ReadOnlyStringProperty textProperty() {
        return this.text;
    }

    @Override
    public final String getText() {
        return (String)this.text.get();
    }

    @Override
    public final SpreadsheetCellType getCellType() {
        return this.type;
    }

    @Override
    public final int getRow() {
        return this.row;
    }

    @Override
    public final int getColumn() {
        return this.column;
    }

    @Override
    public final int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public final void setRowSpan(int n2) {
        this.rowSpan = n2;
    }

    @Override
    public final int getColumnSpan() {
        return this.columnSpan;
    }

    @Override
    public final void setColumnSpan(int n2) {
        this.columnSpan = n2;
    }

    @Override
    public final ObservableSet<String> getStyleClass() {
        if (this.styleClass == null) {
            this.styleClass = FXCollections.observableSet((Object[])new String[0]);
        }
        return this.styleClass;
    }

    @Override
    public void setStyle(String string) {
        this.styleProperty.set((Object)string);
    }

    @Override
    public String getStyle() {
        return (String)this.styleProperty.get();
    }

    @Override
    public StringProperty styleProperty() {
        return this.styleProperty;
    }

    @Override
    public ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    @Override
    public void setGraphic(Node node) {
        this.graphic.set((Object)node);
    }

    @Override
    public Node getGraphic() {
        return (Node)this.graphic.get();
    }

    @Override
    public Optional<String> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    @Override
    public void activateCorner(SpreadsheetCell.CornerPosition cornerPosition) {
        if (this.setMask(true, this.getCornerBitNumber(cornerPosition))) {
            Event.fireEvent((EventTarget)this, (Event)new Event(CORNER_EVENT_TYPE));
        }
    }

    @Override
    public void deactivateCorner(SpreadsheetCell.CornerPosition cornerPosition) {
        if (this.setMask(false, this.getCornerBitNumber(cornerPosition))) {
            Event.fireEvent((EventTarget)this, (Event)new Event(CORNER_EVENT_TYPE));
        }
    }

    @Override
    public boolean isCornerActivated(SpreadsheetCell.CornerPosition cornerPosition) {
        return this.isSet(this.getCornerBitNumber(cornerPosition));
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.append((EventDispatcher)this.eventHandlerManager);
    }

    public String toString() {
        return "cell[" + this.row + "][" + this.column + "]" + this.rowSpan + "-" + this.columnSpan;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpreadsheetCell)) {
            return false;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)object;
        return spreadsheetCell.getRow() == this.row && spreadsheetCell.getColumn() == this.column && Objects.equals(spreadsheetCell.getText(), this.getText()) && this.rowSpan == spreadsheetCell.getRowSpan() && this.columnSpan == spreadsheetCell.getColumnSpan() && Objects.equals(this.getStyleClass(), spreadsheetCell.getStyleClass());
    }

    public final int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.column;
        n3 = 31 * n3 + this.row;
        n3 = 31 * n3 + this.rowSpan;
        n3 = 31 * n3 + this.columnSpan;
        n3 = 31 * n3 + Objects.hashCode(this.getText());
        n3 = 31 * n3 + Objects.hashCode(this.getStyleClass());
        return n3;
    }

    @Override
    public void addEventHandler(EventType<Event> eventType, EventHandler<Event> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public void removeEventHandler(EventType<Event> eventType, EventHandler<Event> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    protected void updateText() {
        if (this.getItem() == null) {
            this.text.setValue("");
        } else if (!"".equals(this.getFormat())) {
            this.text.setValue(this.type.toString(this.getItem(), this.getFormat()));
        } else {
            this.text.setValue(this.type.toString(this.getItem()));
        }
    }

    private int getCornerBitNumber(SpreadsheetCell.CornerPosition cornerPosition) {
        switch (cornerPosition) {
            case TOP_LEFT: {
                return 0;
            }
            case TOP_RIGHT: {
                return 1;
            }
            case BOTTOM_RIGHT: {
                return 2;
            }
        }
        return 3;
    }

    private boolean setMask(boolean bl2, int n2) {
        int n3 = this.propertyContainer;
        this.propertyContainer = bl2 ? (this.propertyContainer |= 1 << n2) : (this.propertyContainer &= ~(1 << n2));
        return this.propertyContainer != n3;
    }

    private boolean isSet(int n2) {
        return (this.propertyContainer & 1 << n2) != 0;
    }
}

