/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public class DirectBufferDataInput
implements DataInput {
    private DirectBuffer buffer;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int length;
    private int position;

    public DirectBufferDataInput(DirectBuffer directBuffer) {
        this.wrap(directBuffer, 0, directBuffer.capacity());
    }

    public DirectBufferDataInput(DirectBuffer directBuffer, int n2, int n3) {
        this.wrap(directBuffer, n2, n3);
    }

    public void wrap(DirectBuffer directBuffer) {
        this.wrap(directBuffer, 0, directBuffer.capacity());
    }

    public void wrap(DirectBuffer directBuffer, int n2, int n3) {
        if (null == directBuffer) {
            throw new NullPointerException("buffer cannot be null");
        }
        DirectBufferDataInput.boundsCheckWrap(n2, n3, directBuffer.capacity());
        this.buffer = directBuffer;
        this.length = n3 + n2;
        this.position = n2;
    }

    public void byteOrder(ByteOrder byteOrder) {
        if (null == byteOrder) {
            throw new IllegalArgumentException("byteOrder cannot be null");
        }
        this.byteOrder = byteOrder;
    }

    public int remaining() {
        return this.length - this.position;
    }

    @Override
    public void readFully(byte[] byArray) throws EOFException {
        if (byArray == null) {
            throw new NullPointerException("Destination must not be null");
        }
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws EOFException {
        if (byArray == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("invalid destinationOffset: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("invalid length: " + n3);
        }
        if (n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("destinationOffset=" + n2 + " length=" + n3 + " not valid for length=" + n3);
        }
        this.boundsCheck0(n3);
        this.buffer.getBytes(this.position, byArray, n2, n3);
        this.position += n3;
    }

    @Override
    public int skipBytes(int n2) {
        int n3 = Math.min(n2, this.remaining());
        this.position += n3;
        return n3;
    }

    @Override
    public boolean readBoolean() throws EOFException {
        this.boundsCheck0(1);
        return this.buffer.getByte(this.position++) != 0;
    }

    @Override
    public byte readByte() throws EOFException {
        this.boundsCheck0(1);
        return this.buffer.getByte(this.position++);
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        this.boundsCheck0(1);
        return this.buffer.getByte(this.position++) & 0xFF;
    }

    @Override
    public short readShort() throws EOFException {
        this.boundsCheck0(2);
        short s2 = this.buffer.getShort(this.position, this.byteOrder);
        this.position += 2;
        return s2;
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        this.boundsCheck0(2);
        int n2 = this.buffer.getShort(this.position, this.byteOrder) & 0xFFFF;
        this.position += 2;
        return n2;
    }

    @Override
    public char readChar() throws EOFException {
        this.boundsCheck0(2);
        char c2 = this.buffer.getChar(this.position, this.byteOrder);
        this.position += 2;
        return c2;
    }

    @Override
    public int readInt() throws EOFException {
        this.boundsCheck0(4);
        int n2 = this.buffer.getInt(this.position, this.byteOrder);
        this.position += 4;
        return n2;
    }

    @Override
    public long readLong() throws EOFException {
        this.boundsCheck0(8);
        long l2 = this.buffer.getLong(this.position, this.byteOrder);
        this.position += 8;
        return l2;
    }

    @Override
    public float readFloat() throws EOFException {
        this.boundsCheck0(4);
        float f2 = this.buffer.getFloat(this.position, this.byteOrder);
        this.position += 4;
        return f2;
    }

    @Override
    public double readDouble() throws EOFException {
        this.boundsCheck0(8);
        double d2 = this.buffer.getDouble(this.position, this.byteOrder);
        this.position += 8;
        return d2;
    }

    @Override
    public String readLine() throws IOException {
        if (this.remaining() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.readLine(stringBuilder);
        return stringBuilder.toString();
    }

    public int readLine(Appendable appendable) throws IOException {
        int n2 = this.position;
        while (this.remaining() > 0) {
            byte by2 = this.readByte();
            if (by2 == 10) {
                return this.position - n2;
            }
            if (by2 == 13) {
                byte by3;
                if (this.remaining() > 0 && (by3 = this.readByte()) != 10) {
                    this.skipBytes(-1);
                }
                return this.position - n2;
            }
            appendable.append((char)by2);
        }
        return this.position - n2;
    }

    @Override
    public String readUTF() throws EOFException {
        this.boundsCheck0(2);
        short s2 = this.readShort();
        this.boundsCheck0(s2);
        String string = this.buffer.getStringWithoutLengthUtf8(this.position, s2);
        this.position += s2;
        return string;
    }

    public String readStringUTF8() {
        String string = this.buffer.getStringUtf8(this.position, this.byteOrder);
        this.position += string.length();
        return string;
    }

    public String readStringAscii() {
        String string = this.buffer.getStringAscii(this.position, this.byteOrder);
        this.position += string.length();
        return string;
    }

    public int readStringAscii(Appendable appendable) {
        int n2 = this.buffer.getStringAscii(this.position, appendable, this.byteOrder);
        this.position += n2;
        return n2;
    }

    private void boundsCheck0(int n2) throws EOFException {
        long l2 = this.position + n2;
        if (l2 > (long)this.length) {
            throw new EOFException("position=" + this.position + " requestedReadBytes=" + n2 + " capacity=" + this.length);
        }
    }

    private static void boundsCheckWrap(int n2, int n3, int n4) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid offset: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("invalid length: " + n3);
        }
        if (n2 > n4 - n3 || n3 > n4 - n2) {
            throw new IllegalArgumentException("offset=" + n2 + " length=" + n3 + " not valid for capacity=" + n4);
        }
    }
}

