/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class SpecialisationGenerator {
    private static final String COLLECTIONS_PACKAGE = "org/agrona/collections";
    private static final String SRC_DIR = "src/main/java/";
    private static final String DST_DIR = "build/generated-src";
    private static final String SUFFIX = ".java";
    private static final List<Substitution> SUBSTITUTIONS = Collections.singletonList(new Substitution("long", "Long", "Long"));

    public static void main(String[] stringArray) throws IOException {
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntIntConsumer", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntIntFunction", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntIntPredicate", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntObjConsumer", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntObjPredicate", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntObjectToObjectFunction", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "ObjectIntToIntFunction", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "ObjIntConsumer", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "ObjIntPredicate", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntArrayList", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntArrayQueue", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Int2IntHashMap", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Int2IntCounterMap", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntHashSet", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "IntLruCache", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Int2ObjectCache", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Int2ObjectHashMap", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Int2NullableObjectHashMap", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Object2IntHashMap", SRC_DIR, DST_DIR);
        SpecialisationGenerator.specialise(SUBSTITUTIONS, COLLECTIONS_PACKAGE, "Object2IntCounterMap", SRC_DIR, DST_DIR);
    }

    public static void specialise(List<Substitution> list, String string, String string2, String string3, String string4) throws IOException {
        Path path = Paths.get(string3, string, string2 + SUFFIX);
        Path path2 = Paths.get(string4, string);
        Files.createDirectories(path2, new FileAttribute[0]);
        List<String> list2 = Files.readAllLines(path, StandardCharsets.UTF_8);
        for (Substitution substitution : list) {
            String string5 = substitution.substitute(string2);
            List list3 = list2.stream().map(substitution::conditionalSubstitute).collect(Collectors.toList());
            Path path3 = Paths.get(string4, string, string5 + SUFFIX);
            Files.write(path3, list3, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public static final class Substitution {
        private final String primitiveType;
        private final String boxedType;
        private final String className;

        private Substitution(String string, String string2, String string3) {
            this.primitiveType = string;
            this.boxedType = string2;
            this.className = string3;
        }

        public String substitute(String string) {
            return string.replace("int", this.primitiveType).replace("Integer", this.boxedType).replace("Int", this.className);
        }

        public String conditionalSubstitute(String string) {
            return string.contains("@DoNotSub") || string.contains("interface") || string.contains("Interface") ? string : this.substitute(string);
        }
    }
}

