/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.broadcast;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.MemoryAccess;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.broadcast.RecordDescriptor;

public class BroadcastTransmitter {
    private final AtomicBuffer buffer;
    private final int capacity;
    private final int maxMsgLength;
    private final int tailIntentCountIndex;
    private final int tailCounterIndex;
    private final int latestCounterIndex;

    public BroadcastTransmitter(AtomicBuffer atomicBuffer) {
        this.buffer = atomicBuffer;
        this.capacity = atomicBuffer.capacity() - BroadcastBufferDescriptor.TRAILER_LENGTH;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        atomicBuffer.verifyAlignment();
        this.maxMsgLength = RecordDescriptor.calculateMaxMessageLength(this.capacity);
        this.tailIntentCountIndex = this.capacity + BroadcastBufferDescriptor.TAIL_INTENT_COUNTER_OFFSET;
        this.tailCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_COUNTER_OFFSET;
        this.latestCounterIndex = this.capacity + BroadcastBufferDescriptor.LATEST_COUNTER_OFFSET;
    }

    public int capacity() {
        return this.capacity;
    }

    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    public void transmit(int n2, DirectBuffer directBuffer, int n3, int n4) {
        RecordDescriptor.checkTypeId(n2);
        this.checkMessageLength(n4);
        AtomicBuffer atomicBuffer = this.buffer;
        long l2 = atomicBuffer.getLong(this.tailCounterIndex);
        int n5 = (int)l2 & this.capacity - 1;
        int n6 = 8 + n4;
        int n7 = BitUtil.align(n6, 8);
        long l3 = l2 + (long)n7;
        int n8 = this.capacity - n5;
        if (n8 < n7) {
            this.signalTailIntent(atomicBuffer, l3 + (long)n8);
            BroadcastTransmitter.insertPaddingRecord(atomicBuffer, n5, n8);
            l2 += (long)n8;
            n5 = 0;
        } else {
            this.signalTailIntent(atomicBuffer, l3);
        }
        atomicBuffer.putInt(RecordDescriptor.lengthOffset(n5), n6);
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n5), n2);
        atomicBuffer.putBytes(RecordDescriptor.msgOffset(n5), directBuffer, n3, n4);
        atomicBuffer.putLongOrdered(this.latestCounterIndex, l2);
        atomicBuffer.putLongOrdered(this.tailCounterIndex, l2 + (long)n7);
    }

    private void signalTailIntent(AtomicBuffer atomicBuffer, long l2) {
        atomicBuffer.putLongOrdered(this.tailIntentCountIndex, l2);
        MemoryAccess.releaseFence();
    }

    private static void insertPaddingRecord(AtomicBuffer atomicBuffer, int n2, int n3) {
        atomicBuffer.putInt(RecordDescriptor.lengthOffset(n2), n3);
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n2), -1);
    }

    private void checkMessageLength(int n2) {
        if (n2 > this.maxMsgLength) {
            throw new IllegalArgumentException("encoded message exceeds maxMsgLength of " + this.maxMsgLength + ", length=" + n2);
        }
    }
}

