/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;

public class DynamicCompositeAgent
implements Agent {
    private static final Agent[] EMPTY_AGENTS = new Agent[0];
    private int agentIndex = 0;
    private volatile Status status = Status.INIT;
    private Agent[] agents;
    private final String roleName;
    private final AtomicReference<Agent> addAgent = new AtomicReference();
    private final AtomicReference<Agent> removeAgent = new AtomicReference();

    public DynamicCompositeAgent(String string) {
        this.roleName = string;
        this.agents = EMPTY_AGENTS;
    }

    public DynamicCompositeAgent(String string, List<? extends Agent> list) {
        this.roleName = string;
        this.agents = new Agent[list.size()];
        int n2 = 0;
        for (Agent agent : list) {
            Objects.requireNonNull(agent, "agent cannot be null");
            this.agents[n2++] = agent;
        }
    }

    public Status status() {
        return this.status;
    }

    public DynamicCompositeAgent(String string, Agent ... agentArray) {
        this.roleName = string;
        this.agents = new Agent[agentArray.length];
        int n2 = 0;
        for (Agent agent : agentArray) {
            Objects.requireNonNull(agent, "agent cannot be null");
            this.agents[n2++] = agent;
        }
    }

    @Override
    public void onStart() {
        for (Agent agent : this.agents) {
            agent.onStart();
        }
        this.status = Status.ACTIVE;
    }

    @Override
    public int doWork() throws Exception {
        Agent agent;
        int n2 = 0;
        Agent agent2 = this.addAgent.get();
        if (null != agent2) {
            this.add(agent2);
        }
        if (null != (agent = this.removeAgent.get())) {
            this.remove(agent);
        }
        Agent[] agentArray = this.agents;
        while (this.agentIndex < agentArray.length) {
            Agent agent3 = agentArray[this.agentIndex++];
            n2 += agent3.doWork();
        }
        this.agentIndex = 0;
        return n2;
    }

    @Override
    public void onClose() {
        this.status = Status.CLOSED;
        Throwable throwable = null;
        for (Agent agent : this.agents) {
            try {
                agent.onClose();
            }
            catch (Exception exception) {
                if (throwable == null) {
                    throwable = new RuntimeException(this.getClass().getName() + ": underlying agent error on close");
                }
                throwable.addSuppressed(exception);
            }
        }
        this.agents = EMPTY_AGENTS;
        if (null != throwable) {
            throw throwable;
        }
    }

    @Override
    public String roleName() {
        return this.roleName;
    }

    public boolean tryAdd(Agent agent) {
        Objects.requireNonNull(agent, "agent cannot be null");
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("add called when not active");
        }
        return this.addAgent.compareAndSet(null, agent);
    }

    public boolean hasAddAgentCompleted() {
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("agent is not active");
        }
        return null == this.addAgent.get();
    }

    public boolean tryRemove(Agent agent) {
        Objects.requireNonNull(agent, "agent cannot be null");
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("remove called when not active");
        }
        return this.removeAgent.compareAndSet(null, agent);
    }

    public boolean hasRemoveAgentCompleted() {
        if (Status.ACTIVE != this.status) {
            throw new IllegalStateException("agent is not active");
        }
        return null == this.removeAgent.get();
    }

    private void add(Agent agent) {
        this.addAgent.lazySet(null);
        try {
            agent.onStart();
        }
        catch (Exception exception) {
            try {
                agent.onClose();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
            throw exception;
        }
        this.agents = ArrayUtil.add(this.agents, agent);
    }

    private void remove(Agent agent) {
        this.removeAgent.lazySet(null);
        Agent[] agentArray = ArrayUtil.remove(this.agents, agent);
        try {
            if (agentArray != this.agents) {
                agent.onClose();
            }
        }
        finally {
            this.agents = agentArray;
        }
    }

    public static enum Status {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

