/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.List;
import java.util.Objects;
import org.agrona.concurrent.Agent;

public class CompositeAgent
implements Agent {
    private final Agent[] agents;
    private final String roleName;
    private int agentIndex = 0;

    public CompositeAgent(List<? extends Agent> list) {
        this(list.toArray(new Agent[0]));
    }

    public CompositeAgent(Agent ... agentArray) {
        if (agentArray.length == 0) {
            throw new IllegalArgumentException("requires at least one sub-agent");
        }
        this.agents = new Agent[agentArray.length];
        StringBuilder stringBuilder = new StringBuilder(agentArray.length * 16);
        stringBuilder.append('[');
        int n2 = 0;
        for (Agent agent : agentArray) {
            Objects.requireNonNull(agent, "agent cannot be null");
            stringBuilder.append(agent.roleName()).append(',');
            this.agents[n2++] = agent;
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        this.roleName = stringBuilder.toString();
    }

    @Override
    public String roleName() {
        return this.roleName;
    }

    @Override
    public void onStart() {
        Throwable throwable = null;
        for (Agent agent : this.agents) {
            try {
                agent.onStart();
            }
            catch (Exception exception) {
                if (throwable == null) {
                    throwable = new RuntimeException(this.getClass().getName() + ": underlying agent error on start");
                }
                throwable.addSuppressed(exception);
            }
        }
        if (null != throwable) {
            throw throwable;
        }
    }

    @Override
    public int doWork() throws Exception {
        int n2 = 0;
        Agent[] agentArray = this.agents;
        while (this.agentIndex < agentArray.length) {
            Agent agent = agentArray[this.agentIndex++];
            n2 += agent.doWork();
        }
        this.agentIndex = 0;
        return n2;
    }

    @Override
    public void onClose() {
        Throwable throwable = null;
        for (Agent agent : this.agents) {
            try {
                agent.onClose();
            }
            catch (Exception exception) {
                if (throwable == null) {
                    throwable = new RuntimeException(this.getClass().getName() + ": underlying agent error on close");
                }
                throwable.addSuppressed(exception);
            }
        }
        if (null != throwable) {
            throw throwable;
        }
    }
}

