/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.agrona.AsciiNumberFormatException;

public final class AsciiEncoding {
    public static final int INT_MAX_DIGITS = 10;
    public static final int LONG_MAX_DIGITS = 19;
    public static final long INTEGER_ABSOLUTE_MIN_VALUE;
    public static final byte[] MIN_INTEGER_VALUE;
    public static final byte[] MAX_INTEGER_VALUE;
    public static final byte[] MIN_LONG_VALUE;
    public static final byte[] MAX_LONG_VALUE;
    public static final byte MINUS_SIGN = 45;
    public static final byte ZERO = 48;
    public static final byte[] ASCII_DIGITS;
    public static final int[] LONG_MAX_VALUE_DIGITS;
    public static final int[] LONG_MIN_VALUE_DIGITS;
    public static final int[] INT_POW_10;
    public static final long[] LONG_POW_10;
    private static final long[] INT_DIGITS;
    private static final long[] LONG_DIGITS;

    private AsciiEncoding() {
    }

    @Deprecated
    public static int endOffset(int n2) {
        return AsciiEncoding.digitCount(n2) - 1;
    }

    @Deprecated
    public static int endOffset(long l2) {
        return AsciiEncoding.digitCount(l2) - 1;
    }

    public static int digitCount(int n2) {
        return (int)((long)n2 + INT_DIGITS[31 - Integer.numberOfLeadingZeros(n2 | 1)] >> 32);
    }

    public static int digitCount(long l2) {
        int n2 = 0x3F ^ Long.numberOfLeadingZeros(l2 | 1L);
        return (int)(LONG_DIGITS[n2] + (l2 >> (n2 >> 2)) >> 52);
    }

    public static boolean isDigit(byte by2) {
        return by2 >= 48 && by2 <= 57;
    }

    public static int getDigit(int n2, byte by2) {
        if (by2 < 48 || by2 > 57) {
            throw new AsciiNumberFormatException("'" + (char)by2 + "' is not a valid digit @ " + n2);
        }
        return by2 - 48;
    }

    public static int getDigit(int n2, char c2) {
        if (c2 < '0' || c2 > '9') {
            throw new AsciiNumberFormatException("'" + c2 + "' is not a valid digit @ " + n2);
        }
        return c2 - 48;
    }

    public static int parseIntAscii(CharSequence charSequence, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + n2 + " length=" + n3);
        }
        boolean bl2 = '-' == charSequence.charAt(n2);
        int n5 = n2;
        if (bl2) {
            ++n5;
            if (1 == n3) {
                AsciiEncoding.throwParseIntError(charSequence, n2, n3);
            }
        }
        if ((n4 = n2 + n3) - n5 < 10) {
            int n6 = AsciiEncoding.parsePositiveIntAscii(charSequence, n2, n3, n5, n4);
            return bl2 ? -n6 : n6;
        }
        long l2 = AsciiEncoding.parsePositiveIntAsciiOverflowCheck(charSequence, n2, n3, n5, n4);
        if (l2 > INTEGER_ABSOLUTE_MIN_VALUE || INTEGER_ABSOLUTE_MIN_VALUE == l2 && !bl2) {
            AsciiEncoding.throwParseIntOverflowError(charSequence, n2, n3);
        }
        return (int)(bl2 ? -l2 : l2);
    }

    public static long parseLongAscii(CharSequence charSequence, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + n2 + " length=" + n3);
        }
        boolean bl2 = '-' == charSequence.charAt(n2);
        int n5 = n2;
        if (bl2) {
            ++n5;
            if (1 == n3) {
                AsciiEncoding.throwParseLongError(charSequence, n2, n3);
            }
        }
        if ((n4 = n2 + n3) - n5 < 19) {
            long l2 = AsciiEncoding.parsePositiveLongAscii(charSequence, n2, n3, n5, n4);
            return bl2 ? -l2 : l2;
        }
        if (bl2) {
            return -AsciiEncoding.parseLongAsciiOverflowCheck(charSequence, n2, n3, LONG_MIN_VALUE_DIGITS, n5, n4);
        }
        return AsciiEncoding.parseLongAsciiOverflowCheck(charSequence, n2, n3, LONG_MAX_VALUE_DIGITS, n5, n4);
    }

    public static boolean isFourDigitsAsciiEncodedNumber(int n2) {
        return 0 == ((n2 + 0x46464646 | n2 - 0x30303030) & 0x80808080);
    }

    public static int parseFourDigitsLittleEndian(int n2) {
        int n3 = n2 & 0xF0F0F0F;
        n3 = n3 * 10 + (n3 >> 8);
        return (n3 & 0xFF00FF) * 6553601 >> 16;
    }

    public static boolean isEightDigitAsciiEncodedNumber(long l2) {
        return 0L == ((l2 + 0x4646464646464646L | l2 - 0x3030303030303030L) & 0x8080808080808080L);
    }

    public static int parseEightDigitsLittleEndian(long l2) {
        long l3 = l2 - 0x3030303030303030L;
        l3 = l3 * 10L + (l3 >> 8);
        l3 = (l3 & 0xFF000000FFL) * 4294967296000100L + (l3 >> 16 & 0xFF000000FFL) * 42949672960001L >> 32;
        return (int)l3;
    }

    private static int parsePositiveIntAscii(CharSequence charSequence, int n2, int n3, int n4, int n5) {
        byte by2;
        int n6;
        int n7 = n4;
        int n8 = 0;
        while (n5 - n7 >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(n6 = AsciiEncoding.readFourBytesLittleEndian(charSequence, n7))) {
            n8 = n8 * 10000 + AsciiEncoding.parseFourDigitsLittleEndian(n6);
            n7 += 4;
        }
        while (n7 < n5 && AsciiEncoding.isDigit(by2 = (byte)charSequence.charAt(n7))) {
            n8 = n8 * 10 + (by2 - 48);
            ++n7;
        }
        if (n7 != n5) {
            AsciiEncoding.throwParseIntError(charSequence, n2, n3);
        }
        return n8;
    }

    private static long parsePositiveIntAsciiOverflowCheck(CharSequence charSequence, int n2, int n3, int n4, int n5) {
        if (n5 - n4 > 10) {
            AsciiEncoding.throwParseIntOverflowError(charSequence, n2, n3);
        }
        int n6 = n4;
        long l2 = 0L;
        long l3 = AsciiEncoding.readEightBytesLittleEndian(charSequence, n6);
        if (AsciiEncoding.isEightDigitAsciiEncodedNumber(l3)) {
            byte by2;
            l2 = AsciiEncoding.parseEightDigitsLittleEndian(l3);
            n6 += 8;
            while (n6 < n5 && AsciiEncoding.isDigit(by2 = (byte)charSequence.charAt(n6))) {
                l2 = l2 * 10L + (long)(by2 - 48);
                ++n6;
            }
        }
        if (n6 != n5) {
            AsciiEncoding.throwParseIntError(charSequence, n2, n3);
        }
        return l2;
    }

    private static void throwParseIntError(CharSequence charSequence, int n2, int n3) {
        throw new AsciiNumberFormatException("error parsing int: " + charSequence.subSequence(n2, n2 + n3));
    }

    private static void throwParseIntOverflowError(CharSequence charSequence, int n2, int n3) {
        throw new AsciiNumberFormatException("int overflow parsing: " + charSequence.subSequence(n2, n2 + n3));
    }

    private static long parsePositiveLongAscii(CharSequence charSequence, int n2, int n3, int n4, int n5) {
        byte by2;
        int n6;
        long l2;
        int n7 = n4;
        long l3 = 0L;
        while (n5 - n7 >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(l2 = AsciiEncoding.readEightBytesLittleEndian(charSequence, n7))) {
            l3 = l3 * 100000000L + (long)AsciiEncoding.parseEightDigitsLittleEndian(l2);
            n7 += 8;
        }
        while (n5 - n7 >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(n6 = AsciiEncoding.readFourBytesLittleEndian(charSequence, n7))) {
            l3 = l3 * 10000L + (long)AsciiEncoding.parseFourDigitsLittleEndian(n6);
            n7 += 4;
        }
        while (n7 < n5 && AsciiEncoding.isDigit(by2 = (byte)charSequence.charAt(n7))) {
            l3 = l3 * 10L + (long)(by2 - 48);
            ++n7;
        }
        if (n7 != n5) {
            AsciiEncoding.throwParseLongError(charSequence, n2, n3);
        }
        return l3;
    }

    private static long parseLongAsciiOverflowCheck(CharSequence charSequence, int n2, int n3, int[] nArray, int n4, int n5) {
        int n6;
        long l2;
        if (n5 - n4 > 19) {
            AsciiEncoding.throwParseLongOverflowError(charSequence, n2, n3);
        }
        int n7 = n4;
        int n8 = 0;
        boolean bl2 = true;
        long l3 = 0L;
        while (n5 - n7 >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(l2 = AsciiEncoding.readEightBytesLittleEndian(charSequence, n7))) {
            n6 = AsciiEncoding.parseEightDigitsLittleEndian(l2);
            if (bl2) {
                if (n6 > nArray[n8]) {
                    AsciiEncoding.throwParseLongOverflowError(charSequence, n2, n3);
                } else if (n6 < nArray[n8]) {
                    bl2 = false;
                }
                ++n8;
            }
            l3 = l3 * 100000000L + (long)n6;
            n7 += 8;
        }
        int n9 = 0;
        while (n7 < n5) {
            byte by2 = (byte)charSequence.charAt(n7);
            n6 = by2;
            if (!AsciiEncoding.isDigit(by2)) break;
            n9 = n9 * 10 + (n6 - 48);
            ++n7;
        }
        if (n7 != n5) {
            AsciiEncoding.throwParseLongError(charSequence, n2, n3);
        } else if (bl2 && n9 > nArray[n8]) {
            AsciiEncoding.throwParseLongOverflowError(charSequence, n2, n3);
        }
        return l3 * 1000L + (long)n9;
    }

    private static void throwParseLongError(CharSequence charSequence, int n2, int n3) {
        throw new AsciiNumberFormatException("error parsing long: " + charSequence.subSequence(n2, n2 + n3));
    }

    private static void throwParseLongOverflowError(CharSequence charSequence, int n2, int n3) {
        throw new AsciiNumberFormatException("long overflow parsing: " + charSequence.subSequence(n2, n2 + n3));
    }

    private static int readFourBytesLittleEndian(CharSequence charSequence, int n2) {
        return charSequence.charAt(n2 + 3) << 24 | charSequence.charAt(n2 + 2) << 16 | charSequence.charAt(n2 + 1) << 8 | charSequence.charAt(n2);
    }

    private static long readEightBytesLittleEndian(CharSequence charSequence, int n2) {
        return (long)charSequence.charAt(n2 + 7) << 56 | (long)charSequence.charAt(n2 + 6) << 48 | (long)charSequence.charAt(n2 + 5) << 40 | (long)charSequence.charAt(n2 + 4) << 32 | (long)charSequence.charAt(n2 + 3) << 24 | (long)charSequence.charAt(n2 + 2) << 16 | (long)(charSequence.charAt(n2 + 1) << 8) | (long)charSequence.charAt(n2);
    }

    static {
        int n2;
        INTEGER_ABSOLUTE_MIN_VALUE = Math.abs(Integer.MIN_VALUE);
        MIN_INTEGER_VALUE = String.valueOf(Integer.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
        MAX_INTEGER_VALUE = String.valueOf(Integer.MAX_VALUE).getBytes(StandardCharsets.US_ASCII);
        MIN_LONG_VALUE = String.valueOf(Long.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
        MAX_LONG_VALUE = String.valueOf(Long.MAX_VALUE).getBytes(StandardCharsets.US_ASCII);
        ASCII_DIGITS = new byte[]{48, 48, 48, 49, 48, 50, 48, 51, 48, 52, 48, 53, 48, 54, 48, 55, 48, 56, 48, 57, 49, 48, 49, 49, 49, 50, 49, 51, 49, 52, 49, 53, 49, 54, 49, 55, 49, 56, 49, 57, 50, 48, 50, 49, 50, 50, 50, 51, 50, 52, 50, 53, 50, 54, 50, 55, 50, 56, 50, 57, 51, 48, 51, 49, 51, 50, 51, 51, 51, 52, 51, 53, 51, 54, 51, 55, 51, 56, 51, 57, 52, 48, 52, 49, 52, 50, 52, 51, 52, 52, 52, 53, 52, 54, 52, 55, 52, 56, 52, 57, 53, 48, 53, 49, 53, 50, 53, 51, 53, 52, 53, 53, 53, 54, 53, 55, 53, 56, 53, 57, 54, 48, 54, 49, 54, 50, 54, 51, 54, 52, 54, 53, 54, 54, 54, 55, 54, 56, 54, 57, 55, 48, 55, 49, 55, 50, 55, 51, 55, 52, 55, 53, 55, 54, 55, 55, 55, 56, 55, 57, 56, 48, 56, 49, 56, 50, 56, 51, 56, 52, 56, 53, 56, 54, 56, 55, 56, 56, 56, 57, 57, 48, 57, 49, 57, 50, 57, 51, 57, 52, 57, 53, 57, 54, 57, 55, 57, 56, 57, 57};
        LONG_MAX_VALUE_DIGITS = new int[]{92233720, 36854775, 807};
        LONG_MIN_VALUE_DIGITS = new int[]{92233720, 36854775, 808};
        INT_POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        LONG_POW_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        INT_DIGITS = new long[32];
        LONG_DIGITS = new long[64];
        for (int i2 = 1; i2 < 33; ++i2) {
            n2 = 1 << i2 - 1;
            long l2 = (long)Math.ceil(Math.log10(n2) / Math.log10(10.0));
            AsciiEncoding.INT_DIGITS[i2 - 1] = 1 == i2 ? 0x100000000L : (i2 < 31 ? 0x100000000L - LONG_POW_10[(int)l2] + (l2 << 32) : l2 << 32);
        }
        BigInteger bigInteger = BigInteger.TEN.pow(19);
        for (n2 = 0; n2 < 64; ++n2) {
            long l3;
            if (0 == n2) {
                AsciiEncoding.LONG_DIGITS[n2] = 0x10000000000000L;
                continue;
            }
            int n3 = (n2 * 0x134413 >> 22) + 1;
            long l4 = n3 < 19 ? LONG_POW_10[n3] >> (n2 >> 2) : bigInteger.shiftRight(n2 >> 2).longValueExact();
            AsciiEncoding.LONG_DIGITS[n2] = l3 = ((long)(n3 + 1) << 52) - l4;
        }
    }
}

