/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    private static final List<Protocol> ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    private final Request originalRequest;
    final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private final String key;
    private Call call;
    private final Runnable writerRunnable;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private ScheduledExecutorService executor;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private final ArrayDeque<Object> messageAndCloseQueue = new ArrayDeque();
    private long queueSize;
    private boolean enqueuedClose;
    private ScheduledFuture<?> cancelFuture;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;

    public RealWebSocket(Request request, WebSocketListener webSocketListener, Random random, long l2) {
        if (!"GET".equals(request.method())) {
            throw new IllegalArgumentException("Request must be GET: " + request.method());
        }
        this.originalRequest = request;
        this.listener = webSocketListener;
        this.random = random;
        this.pingIntervalMillis = l2;
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        this.key = ByteString.of(byArray).base64();
        this.writerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (RealWebSocket.this.writeOneFrame()) {
                    }
                }
                catch (IOException iOException) {
                    RealWebSocket.this.failWebSocket(iOException, null);
                }
            }
        };
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void connect(OkHttpClient okHttpClient) {
        okHttpClient = okHttpClient.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        final Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        this.call = Internal.instance.newWebSocketCall(okHttpClient, request);
        this.call.enqueue(new Callback(){

            @Override
            public void onResponse(Call call, Response response) {
                try {
                    RealWebSocket.this.checkResponse(response);
                }
                catch (ProtocolException protocolException) {
                    RealWebSocket.this.failWebSocket(protocolException, response);
                    Util.closeQuietly(response);
                    return;
                }
                StreamAllocation streamAllocation = Internal.instance.streamAllocation(call);
                streamAllocation.noNewStreams();
                Streams streams = streamAllocation.connection().newWebSocketStreams(streamAllocation);
                try {
                    RealWebSocket.this.listener.onOpen(RealWebSocket.this, response);
                    String string = "OkHttp WebSocket " + request.url().redact();
                    RealWebSocket.this.initReaderAndWriter(string, streams);
                    streamAllocation.connection().socket().setSoTimeout(0);
                    RealWebSocket.this.loopReader();
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                }
            }

            @Override
            public void onFailure(Call call, IOException iOException) {
                RealWebSocket.this.failWebSocket(iOException, null);
            }
        });
    }

    void checkResponse(Response response) throws ProtocolException {
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + " " + response.message() + "'");
        }
        String string = response.header("Connection");
        if (!"Upgrade".equalsIgnoreCase(string)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + string + "'");
        }
        String string2 = response.header("Upgrade");
        if (!"websocket".equalsIgnoreCase(string2)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + string2 + "'");
        }
        String string3 = response.header("Sec-WebSocket-Accept");
        String string4 = ByteString.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!string4.equals(string3)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + string4 + "' but was '" + string3 + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initReaderAndWriter(String string, Streams streams) throws IOException {
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.client, streams.sink, this.random);
            this.executor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(string, false));
            if (this.pingIntervalMillis != 0L) {
                this.executor.scheduleAtFixedRate(new PingRunnable(), this.pingIntervalMillis, this.pingIntervalMillis, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.client, streams.source, this);
    }

    public void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    boolean processNextFrame() throws IOException {
        try {
            this.reader.processNextFrame();
            return this.receivedCloseCode == -1;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    void awaitTermination(int n2, TimeUnit timeUnit) throws InterruptedException {
        this.executor.awaitTermination(n2, timeUnit);
    }

    void tearDown() throws InterruptedException {
        if (this.cancelFuture != null) {
            this.cancelFuture.cancel(false);
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    @Override
    public void onReadMessage(String string) throws IOException {
        this.listener.onMessage((WebSocket)this, string);
    }

    @Override
    public void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public synchronized void onReadPing(ByteString byteString) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add(byteString);
        this.runWriter();
        ++this.receivedPingCount;
    }

    @Override
    public synchronized void onReadPong(ByteString byteString) {
        ++this.receivedPongCount;
        this.awaitingPong = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadClose(int n2, String string) {
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        Streams streams = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.receivedCloseCode != -1) {
                throw new IllegalStateException("already closed");
            }
            this.receivedCloseCode = n2;
            this.receivedCloseReason = string;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                streams = this.streams;
                this.streams = null;
                if (this.cancelFuture != null) {
                    this.cancelFuture.cancel(false);
                }
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onClosing(this, n2, string);
            if (streams != null) {
                this.listener.onClosed(this, n2, string);
            }
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    @Override
    public boolean send(String string) {
        if (string == null) {
            throw new NullPointerException("text == null");
        }
        return this.send(ByteString.encodeUtf8(string), 1);
    }

    @Override
    public boolean send(ByteString byteString) {
        if (byteString == null) {
            throw new NullPointerException("bytes == null");
        }
        return this.send(byteString, 2);
    }

    private synchronized boolean send(ByteString byteString, int n2) {
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)byteString.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)byteString.size();
        this.messageAndCloseQueue.add(new Message(n2, byteString));
        this.runWriter();
        return true;
    }

    synchronized boolean pong(ByteString byteString) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add(byteString);
        this.runWriter();
        return true;
    }

    @Override
    public boolean close(int n2, String string) {
        return this.close(n2, string, 60000L);
    }

    synchronized boolean close(int n2, String string, long l2) {
        WebSocketProtocol.validateCloseCode(n2);
        ByteString byteString = null;
        if (string != null && (long)(byteString = ByteString.encodeUtf8(string)).size() > 123L) {
            throw new IllegalArgumentException("reason.size() > 123: " + string);
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close(n2, byteString, l2));
        this.runWriter();
        return true;
    }

    private void runWriter() {
        assert (Thread.holdsLock(this));
        if (this.executor != null) {
            this.executor.execute(this.writerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeOneFrame() throws IOException {
        ByteString byteString;
        WebSocketWriter webSocketWriter;
        Object object = null;
        int n2 = -1;
        String string = null;
        Streams streams = null;
        Object object2 = this;
        synchronized (object2) {
            if (this.failed) {
                return false;
            }
            webSocketWriter = this.writer;
            byteString = this.pongQueue.poll();
            if (byteString == null) {
                object = this.messageAndCloseQueue.poll();
                if (object instanceof Close) {
                    n2 = this.receivedCloseCode;
                    string = this.receivedCloseReason;
                    if (n2 != -1) {
                        streams = this.streams;
                        this.streams = null;
                        this.executor.shutdown();
                    } else {
                        this.cancelFuture = this.executor.schedule(new CancelRunnable(), ((Close)object).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
                    }
                } else if (object == null) {
                    return false;
                }
            }
        }
        try {
            if (byteString != null) {
                webSocketWriter.writePong(byteString);
            } else if (object instanceof Message) {
                object2 = ((Message)object).data;
                BufferedSink bufferedSink = Okio.buffer(webSocketWriter.newMessageSink(((Message)object).formatOpcode, ((ByteString)object2).size()));
                bufferedSink.write((ByteString)object2);
                bufferedSink.close();
                RealWebSocket realWebSocket = this;
                synchronized (realWebSocket) {
                    this.queueSize -= (long)((ByteString)object2).size();
                }
            } else if (object instanceof Close) {
                object2 = (Close)object;
                webSocketWriter.writeClose(((Close)object2).code, ((Close)object2).reason);
                if (streams != null) {
                    this.listener.onClosed(this, n2, string);
                }
            } else {
                throw new AssertionError();
            }
            boolean bl2 = true;
            return bl2;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePingFrame() {
        int n2;
        WebSocketWriter webSocketWriter;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            webSocketWriter = this.writer;
            n2 = this.awaitingPong ? this.sentPingCount : -1;
            ++this.sentPingCount;
            this.awaitingPong = true;
        }
        if (n2 != -1) {
            this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (n2 - 1) + " successful ping/pongs)"), null);
            return;
        }
        try {
            webSocketWriter.writePing(ByteString.EMPTY);
        }
        catch (IOException iOException) {
            this.failWebSocket(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failWebSocket(Exception exception, @Nullable Response response) {
        Streams streams;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streams = this.streams;
            this.streams = null;
            if (this.cancelFuture != null) {
                this.cancelFuture.cancel(false);
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onFailure(this, exception, response);
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.cancel();
        }
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSource source;
        public final BufferedSink sink;

        public Streams(boolean bl2, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.client = bl2;
            this.source = bufferedSource;
            this.sink = bufferedSink;
        }
    }

    static final class Close {
        final int code;
        final ByteString reason;
        final long cancelAfterCloseMillis;

        Close(int n2, ByteString byteString, long l2) {
            this.code = n2;
            this.reason = byteString;
            this.cancelAfterCloseMillis = l2;
        }
    }

    static final class Message {
        final int formatOpcode;
        final ByteString data;

        Message(int n2, ByteString byteString) {
            this.formatOpcode = n2;
            this.data = byteString;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.writePingFrame();
        }
    }
}

